/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.lang.reflect.Modifier;
import java.util.List;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractDeploymentUnitProcessor;
import org.jboss.as.ejb3.deployment.processors.EJBComponentDescriptionFactory;
import org.jboss.as.ejb3.util.PropertiesValueResolver;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.metadata.ejb.spec.EjbType;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.GenericBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionBean32MetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionType;
import org.jboss.msc.service.ServiceName;

public class SessionBeanComponentDescriptionFactory
extends EJBComponentDescriptionFactory {
    private static final DotName STATELESS_ANNOTATION = DotName.createSimple((String)Stateless.class.getName());
    private static final DotName STATEFUL_ANNOTATION = DotName.createSimple((String)Stateful.class.getName());
    private static final DotName SINGLETON_ANNOTATION = DotName.createSimple((String)Singleton.class.getName());

    public SessionBeanComponentDescriptionFactory(boolean appclient) {
        super(appclient);
    }

    @Override
    protected void processAnnotations(DeploymentUnit deploymentUnit, CompositeIndex compositeIndex) throws DeploymentUnitProcessingException {
        List sbAnnotations;
        List sfsbAnnotations;
        if (MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit)) {
            return;
        }
        List slsbAnnotations = compositeIndex.getAnnotations(STATELESS_ANNOTATION);
        if (!slsbAnnotations.isEmpty()) {
            this.processSessionBeans(deploymentUnit, slsbAnnotations, SessionBeanComponentDescription.SessionBeanType.STATELESS);
        }
        if (!(sfsbAnnotations = compositeIndex.getAnnotations(STATEFUL_ANNOTATION)).isEmpty()) {
            this.processSessionBeans(deploymentUnit, sfsbAnnotations, SessionBeanComponentDescription.SessionBeanType.STATEFUL);
        }
        if (!(sbAnnotations = compositeIndex.getAnnotations(SINGLETON_ANNOTATION)).isEmpty()) {
            this.processSessionBeans(deploymentUnit, sbAnnotations, SessionBeanComponentDescription.SessionBeanType.SINGLETON);
        }
    }

    @Override
    protected void processBeanMetaData(DeploymentUnit deploymentUnit, EnterpriseBeanMetaData enterpriseBeanMetaData) throws DeploymentUnitProcessingException {
        if (enterpriseBeanMetaData.isSession()) {
            assert (enterpriseBeanMetaData instanceof SessionBeanMetaData) : enterpriseBeanMetaData + " is not a SessionBeanMetaData";
            this.processSessionBeanMetaData(deploymentUnit, (SessionBeanMetaData)enterpriseBeanMetaData);
        }
    }

    private void processSessionBeans(DeploymentUnit deploymentUnit, List<AnnotationInstance> sessionBeanAnnotations, SessionBeanComponentDescription.SessionBeanType annotatedSessionBeanType) {
        EjbJarDescription ejbJarDescription = AbstractDeploymentUnitProcessor.getEjbJarDescription(deploymentUnit);
        ServiceName deploymentUnitServiceName = deploymentUnit.getServiceName();
        boolean replacement = (Boolean)deploymentUnit.getAttachment(org.jboss.as.ee.structure.Attachments.ANNOTATION_PROPERTY_REPLACEMENT);
        for (AnnotationInstance sessionBeanAnnotation : sessionBeanAnnotations) {
            SessionBeanComponentDescription sessionBeanDescription;
            SessionBeanComponentDescription.SessionBeanType sessionBeanType;
            String beanClassName;
            AnnotationTarget target = sessionBeanAnnotation.target();
            if (!(target instanceof ClassInfo)) {
                EjbMessages.MESSAGES.annotationOnlyAllowedOnClass(sessionBeanAnnotation.name().toString(), target);
                continue;
            }
            ClassInfo sessionBeanClassInfo = (ClassInfo)target;
            if (!SessionBeanComponentDescriptionFactory.assertSessionBeanClassValidity(sessionBeanClassInfo)) continue;
            String ejbName = sessionBeanClassInfo.name().local();
            AnnotationValue nameValue = sessionBeanAnnotation.value("name");
            String beanName = nameValue == null || nameValue.asString().isEmpty() ? ejbName : (replacement ? PropertiesValueResolver.replaceProperties(nameValue.asString()) : nameValue.asString());
            SessionBeanMetaData beanMetaData = SessionBeanComponentDescriptionFactory.getEnterpriseBeanMetaData(deploymentUnit, beanName, SessionBeanMetaData.class);
            if (beanMetaData != null) {
                beanClassName = SessionBeanComponentDescriptionFactory.override(sessionBeanClassInfo.name().toString(), beanMetaData.getEjbClass());
                sessionBeanType = SessionBeanComponentDescriptionFactory.override(annotatedSessionBeanType, SessionBeanComponentDescriptionFactory.descriptionOf(beanMetaData.getSessionType()));
            } else {
                beanClassName = sessionBeanClassInfo.name().toString();
                sessionBeanType = annotatedSessionBeanType;
            }
            switch (sessionBeanType) {
                case STATELESS: {
                    sessionBeanDescription = new StatelessComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnitServiceName, beanMetaData);
                    break;
                }
                case STATEFUL: {
                    sessionBeanDescription = new StatefulComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnitServiceName, beanMetaData);
                    boolean passivationCapableAnnotationValue = sessionBeanAnnotation.value("passivationCapable") == null ? true : sessionBeanAnnotation.value("passivationCapable").asBoolean();
                    Boolean passivationCapableDeploymentDescriptorValue = beanMetaData instanceof SessionBean32MetaData ? ((SessionBean32MetaData)beanMetaData).isPassivationCapable() : null;
                    boolean passivationApplicable = SessionBeanComponentDescriptionFactory.override(passivationCapableDeploymentDescriptorValue, passivationCapableAnnotationValue);
                    ((StatefulComponentDescription)sessionBeanDescription).setPassivationApplicable(passivationApplicable);
                    break;
                }
                case SINGLETON: {
                    sessionBeanDescription = new SingletonComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnitServiceName, beanMetaData);
                    break;
                }
                default: {
                    throw EjbMessages.MESSAGES.unknownSessionBeanType(sessionBeanType.name());
                }
            }
            this.addComponent(deploymentUnit, sessionBeanDescription);
        }
        EjbDeploymentMarker.mark((DeploymentUnit)deploymentUnit);
    }

    private static SessionBeanComponentDescription.SessionBeanType descriptionOf(SessionType sessionType) {
        if (sessionType == null) {
            return null;
        }
        switch (sessionType) {
            case Stateless: {
                return SessionBeanComponentDescription.SessionBeanType.STATELESS;
            }
            case Stateful: {
                return SessionBeanComponentDescription.SessionBeanType.STATEFUL;
            }
            case Singleton: {
                return SessionBeanComponentDescription.SessionBeanType.SINGLETON;
            }
        }
        throw EjbMessages.MESSAGES.unknownSessionBeanType(sessionType.name());
    }

    private static boolean assertSessionBeanClassValidity(ClassInfo sessionBeanClass) {
        short flags = sessionBeanClass.flags();
        String className = sessionBeanClass.name().toString();
        if (Modifier.isInterface(flags)) {
            EjbLogger.EJB3_LOGGER.sessionBeanClassCannotBeAnInterface(className);
            return false;
        }
        if (!Modifier.isPublic(flags) || Modifier.isAbstract(flags) || Modifier.isFinal(flags)) {
            EjbLogger.EJB3_LOGGER.sessionBeanClassMustBePublicNonAbstractNonFinal(className);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSessionBeanMetaData(DeploymentUnit deploymentUnit, SessionBeanMetaData sessionBean) throws DeploymentUnitProcessingException {
        void var8_11;
        EjbJarDescription ejbJarDescription = AbstractDeploymentUnitProcessor.getEjbJarDescription(deploymentUnit);
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        String beanName = sessionBean.getName();
        SessionType sessionType = sessionBean.getSessionType();
        if (sessionType == null && sessionBean instanceof GenericBeanMetaData) {
            GenericBeanMetaData bean = (GenericBeanMetaData)sessionBean;
            if (bean.getEjbType() != EjbType.SESSION) return;
            sessionType = this.determineSessionType(sessionBean.getEjbClass(), compositeIndex);
            if (sessionType == null) {
                throw EjbMessages.MESSAGES.sessionTypeNotSpecified(beanName);
            }
        } else if (sessionType == null && (sessionType = this.determineSessionType(sessionBean.getEjbClass(), compositeIndex)) == null) {
            throw EjbMessages.MESSAGES.sessionTypeNotSpecified(beanName);
        }
        String beanClassName = sessionBean.getEjbClass();
        switch (sessionType) {
            case Stateless: {
                StatelessComponentDescription statelessComponentDescription = new StatelessComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName(), sessionBean);
                break;
            }
            case Stateful: {
                StatefulComponentDescription statefulComponentDescription = new StatefulComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName(), sessionBean);
                if (!(sessionBean instanceof SessionBean32MetaData) || ((SessionBean32MetaData)sessionBean).isPassivationCapable() == null) break;
                statefulComponentDescription.setPassivationApplicable(((SessionBean32MetaData)sessionBean).isPassivationCapable());
                break;
            }
            case Singleton: {
                SingletonComponentDescription singletonComponentDescription = new SingletonComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName(), sessionBean);
                break;
            }
            default: {
                throw EjbMessages.MESSAGES.unknownSessionBeanType(sessionType.name());
            }
        }
        this.addComponent(deploymentUnit, (EJBComponentDescription)var8_11);
    }

    private SessionType determineSessionType(String ejbClass, CompositeIndex compositeIndex) {
        if (ejbClass == null) {
            return null;
        }
        ClassInfo info = compositeIndex.getClassByName(DotName.createSimple((String)ejbClass));
        if (info == null) {
            return null;
        }
        if (info.annotations().get(STATEFUL_ANNOTATION) != null) {
            return SessionType.Stateful;
        }
        if (info.annotations().get(STATELESS_ANNOTATION) != null) {
            return SessionType.Stateless;
        }
        if (info.annotations().get(SINGLETON_ANNOTATION) != null) {
            return SessionType.Singleton;
        }
        return null;
    }
}

