/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.messagedriven;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ejb.TransactionAttributeType;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenAllowedMethodsInformation;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentCreateService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentInstance;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.component.pool.PooledComponent;
import org.jboss.as.ejb3.inflow.JBossMessageEndpointFactory;
import org.jboss.as.ejb3.inflow.MessageEndpointService;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.pool.StatelessObjectFactory;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.invocation.Interceptor;
import org.jboss.jca.core.spi.rar.Endpoint;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetClassLoaderAction;

public class MessageDrivenComponent
extends EJBComponent
implements PooledComponent<MessageDrivenComponentInstance> {
    private final Pool<MessageDrivenComponentInstance> pool;
    private final String poolName;
    private final SuspendController suspendController;
    private final ActivationSpec activationSpec;
    private final MessageEndpointFactory endpointFactory;
    private final ClassLoader classLoader;
    private volatile boolean deliveryActive;
    private Endpoint endpoint;
    private String activationName;
    private final ServerActivity serverActivity = new ServerActivity(){

        public void preSuspend(ServerActivityCallback listener) {
            if (MessageDrivenComponent.this.deliveryActive) {
                MessageDrivenComponent.this.deactivate();
            }
            listener.done();
        }

        public void suspended(ServerActivityCallback listener) {
            listener.done();
        }

        public void resume() {
            if (MessageDrivenComponent.this.deliveryActive) {
                MessageDrivenComponent.this.activate();
            }
        }
    };

    protected MessageDrivenComponent(MessageDrivenComponentCreateService ejbComponentCreateService, final Class<?> messageListenerInterface, ActivationSpec activationSpec, boolean deliveryActive) {
        super(ejbComponentCreateService);
        StatelessObjectFactory<MessageDrivenComponentInstance> factory = new StatelessObjectFactory<MessageDrivenComponentInstance>(){

            @Override
            public MessageDrivenComponentInstance create() {
                return (MessageDrivenComponentInstance)MessageDrivenComponent.this.createInstance();
            }

            @Override
            public void destroy(MessageDrivenComponentInstance obj) {
                obj.destroy();
            }
        };
        PoolConfig poolConfig = ejbComponentCreateService.getPoolConfig();
        if (poolConfig == null) {
            EjbLogger.ROOT_LOGGER.debugf("Pooling is disabled for MDB %s", ejbComponentCreateService.getComponentName());
            this.pool = null;
            this.poolName = null;
        } else {
            EjbLogger.ROOT_LOGGER.debugf("Using pool config %s to create pool for MDB %s", poolConfig, ejbComponentCreateService.getComponentName());
            this.pool = poolConfig.createPool(factory);
            this.poolName = poolConfig.getPoolName();
        }
        this.classLoader = ejbComponentCreateService.getModuleClassLoader();
        this.suspendController = (SuspendController)ejbComponentCreateService.getSuspendControllerInjectedValue().getValue();
        this.activationSpec = activationSpec;
        final ClassLoader componentClassLoader = (ClassLoader)AccessController.doPrivileged(new GetClassLoaderAction(ejbComponentCreateService.getComponentClass()));
        MessageEndpointService<Object> service = new MessageEndpointService<Object>(){

            @Override
            public Class<Object> getMessageListenerInterface() {
                return messageListenerInterface;
            }

            @Override
            public TransactionManager getTransactionManager() {
                return MessageDrivenComponent.this.getTransactionManager();
            }

            @Override
            public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
                if (MessageDrivenComponent.this.isBeanManagedTransaction()) {
                    return false;
                }
                return MessageDrivenComponent.this.getTransactionAttributeType(MethodIntf.MESSAGE_ENDPOINT, method) == TransactionAttributeType.REQUIRED;
            }

            @Override
            public String getActivationName() {
                return MessageDrivenComponent.this.activationName;
            }

            @Override
            public Object obtain(long timeout, TimeUnit unit) {
                return MessageDrivenComponent.this.createViewInstanceProxy(MessageDrivenComponent.this.getComponentClass(), Collections.emptyMap());
            }

            @Override
            public void release(Object obj) {
            }

            @Override
            public ClassLoader getClassLoader() {
                return componentClassLoader;
            }
        };
        this.endpointFactory = new JBossMessageEndpointFactory(componentClassLoader, service, this.getComponentClass(), messageListenerInterface);
        this.deliveryActive = deliveryActive;
    }

    protected BasicComponentInstance instantiateComponentInstance(Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, Map<Object, Object> context) {
        return new MessageDrivenComponentInstance(this, preDestroyInterceptor, methodInterceptors);
    }

    @Override
    public Pool<MessageDrivenComponentInstance> getPool() {
        return this.pool;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void start() {
        if (this.endpoint == null) {
            throw EjbLogger.ROOT_LOGGER.endpointUnAvailable(this.getComponentName());
        }
        super.start();
        if (this.deliveryActive) {
            this.activate();
        }
        if (this.pool != null) {
            this.pool.start();
        }
        this.suspendController.registerActivity(this.serverActivity);
    }

    @Override
    public void done() {
        this.deactivate();
        if (this.pool != null) {
            this.pool.stop();
        }
        this.suspendController.unRegisterActivity(this.serverActivity);
        super.done();
    }

    private void activate() {
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            this.endpoint.activate(this.endpointFactory, this.activationSpec);
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    private void deactivate() {
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            this.endpoint.deactivate(this.endpointFactory, this.activationSpec);
        }
        catch (ResourceException re) {
            throw EjbLogger.ROOT_LOGGER.failureDuringEndpointDeactivation(this.getComponentName(), re);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    public void startDelivery() {
        if (!this.deliveryActive) {
            this.deliveryActive = true;
            this.activate();
        }
    }

    public void stopDelivery() {
        if (this.deliveryActive) {
            this.deactivate();
            this.deliveryActive = false;
        }
    }

    public boolean isDeliveryActive() {
        return this.deliveryActive;
    }

    @Override
    public AllowedMethodsInformation getAllowedMethodsInformation() {
        return this.isBeanManagedTransaction() ? MessageDrivenAllowedMethodsInformation.INSTANCE_BMT : MessageDrivenAllowedMethodsInformation.INSTANCE_CMT;
    }
}

