/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.ejb3.component.stateful.EJBClientContextIdentifierObjectTable;
import org.jboss.as.ejb3.component.stateful.StatefulSessionBeanClassTable;
import org.jboss.as.ejb3.component.stateful.StatefulSessionBeanSerializabilityChecker;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.marshalling.VersionedMarshallingConfiguration;

public class VersionedMarshallingConfigurationService
implements Service<VersionedMarshallingConfiguration>,
VersionedMarshallingConfiguration {
    private static final int CURRENT_VERSION = 1;
    private final Map<Integer, MarshallingConfiguration> configurations = new ConcurrentHashMap<Integer, MarshallingConfiguration>();
    private final Value<ModuleDeployment> deployment;
    private final Value<ModuleLoader> loader;

    public static ServiceName getServiceName(ServiceName deploymentUnitServiceName) {
        return deploymentUnitServiceName.append(new String[]{"marshalling"});
    }

    public VersionedMarshallingConfigurationService(Value<ModuleDeployment> deployment, Value<ModuleLoader> loader) {
        this.deployment = deployment;
        this.loader = loader;
    }

    public void start(StartContext context) {
        MarshallingConfiguration config = new MarshallingConfiguration();
        config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)((ModuleLoader)this.loader.getValue())));
        config.setSerializabilityChecker((SerializabilityChecker)new StatefulSessionBeanSerializabilityChecker((ModuleDeployment)this.deployment.getValue()));
        config.setClassTable((ClassTable)new StatefulSessionBeanClassTable());
        config.setObjectTable((ObjectTable)new EJBClientContextIdentifierObjectTable());
        this.configurations.put(1, config);
    }

    public void stop(StopContext context) {
        this.configurations.clear();
    }

    public VersionedMarshallingConfiguration getValue() {
        return this;
    }

    public int getCurrentMarshallingVersion() {
        return 1;
    }

    public MarshallingConfiguration getMarshallingConfiguration(int version) {
        MarshallingConfiguration configuration = this.configurations.get(version);
        if (configuration == null) {
            throw EjbLogger.ROOT_LOGGER.unsupportedMarshallingVersion(version);
        }
        return configuration;
    }
}

