/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.ejb3.remote.LocalEjbReceiver;
import org.jboss.as.ejb3.remote.RemotingProfileService;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.ejb.client.remoting.ReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Connection;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class DescriptorBasedEJBClientContextService
implements Service<EJBClientContext> {
    public static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "dd-based-ejb-client-context"});
    private static final Logger logger = Logger.getLogger(DescriptorBasedEJBClientContextService.class);
    private static final long DEFAULT_CONNECTION_TIMEOUT = 5000L;
    private final InjectedValue<RemotingProfileService> profileServiceValue = new InjectedValue();
    private final EJBClientConfiguration ejbClientConfiguration;
    private final ClassLoader clientContextClassloader;
    private volatile EJBClientContext ejbClientContext;

    @Deprecated
    public DescriptorBasedEJBClientContextService(EJBClientConfiguration ejbClientConfiguration) {
        this.ejbClientConfiguration = ejbClientConfiguration;
        this.clientContextClassloader = null;
    }

    public DescriptorBasedEJBClientContextService(EJBClientConfiguration ejbClientConfiguration, ClassLoader clientContextClassloader) {
        this.ejbClientConfiguration = ejbClientConfiguration;
        this.clientContextClassloader = clientContextClassloader;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        EJBClientContext context = this.clientContextClassloader != null ? EJBClientContext.create((EJBClientConfiguration)this.ejbClientConfiguration, (ClassLoader)this.clientContextClassloader) : EJBClientContext.create((EJBClientConfiguration)this.ejbClientConfiguration);
        RemotingProfileService profileService = (RemotingProfileService)this.profileServiceValue.getValue();
        LocalEjbReceiver localEjbReceiver = (LocalEjbReceiver)profileService.getLocalEjbReceiverInjector().getOptionalValue();
        if (localEjbReceiver != null) {
            context.registerEJBReceiver((EJBReceiver)localEjbReceiver);
            logger.debugf("Added a local EJB receiver to descriptor based EJB client context named %s", (Object)startContext.getController().getName());
        }
        this.registerRemotingEJBReceivers(startContext, context, profileService);
        this.ejbClientContext = context;
    }

    public synchronized void stop(StopContext context) {
        RemotingProfileService profileService = (RemotingProfileService)this.profileServiceValue.getValue();
        LocalEjbReceiver localEjbReceiver = (LocalEjbReceiver)profileService.getLocalEjbReceiverInjector().getOptionalValue();
        if (localEjbReceiver != null) {
            this.ejbClientContext.unregisterEJBReceiver((EJBReceiver)localEjbReceiver);
            logger.debugf("Removed a local EJB receiver from descriptor based EJB client context named %s", (Object)context.getController().getName());
        }
        if (this.ejbClientContext != null) {
            IoUtils.safeClose((Closeable)this.ejbClientContext);
        }
        this.ejbClientContext = null;
    }

    public EJBClientContext getValue() throws IllegalStateException, IllegalArgumentException {
        return this.ejbClientContext;
    }

    public Injector<RemotingProfileService> getProfileServiceInjector() {
        return this.profileServiceValue;
    }

    private void registerRemotingEJBReceivers(StartContext startContext, EJBClientContext context, RemotingProfileService profileService) {
        Map<ServiceName, InjectedValue<AbstractOutboundConnectionService>> remotingOutboundConnections = profileService.getRemotingConnections();
        Map<String, Long> connectionTimeouts = profileService.getConnectionTimeouts();
        Map<String, OptionMap> channelCreationOpts = profileService.getChannelCreationOpts();
        ServiceContainer serviceRegistry = startContext.getController().getServiceContainer();
        int numRemotingReceivers = 0;
        for (Map.Entry<ServiceName, InjectedValue<AbstractOutboundConnectionService>> entry : remotingOutboundConnections.entrySet()) {
            InjectedValue<AbstractOutboundConnectionService> injectedValue = entry.getValue();
            AbstractOutboundConnectionService outboundConnectionService = (AbstractOutboundConnectionService)injectedValue.getValue();
            String connectionName = outboundConnectionService.getConnectionName();
            logger.debugf("Creating remoting EJB receiver for connection %s", (Object)connectionName);
            long connectionTimeout = connectionTimeouts.get(connectionName) <= 0L ? 5000L : connectionTimeouts.get(connectionName);
            OptionMap options = channelCreationOpts.get(connectionName) == null ? OptionMap.EMPTY : channelCreationOpts.get(connectionName);
            Connection connection = null;
            OutboundConnectionReconnectHandler reconnectHandler = new OutboundConnectionReconnectHandler((ServiceRegistry)serviceRegistry, entry.getKey(), context, connectionTimeout, options);
            try {
                IoFuture futureConnection = outboundConnectionService.connect();
                connection = (Connection)IoFutureHelper.get((IoFuture)futureConnection, (long)connectionTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                logger.debugf((Throwable)e, "Failed to create a connection for %s. A reconnect handler will be added to the client context", (Object)connectionName, (Object)e);
                context.registerReconnectHandler((ReconnectHandler)reconnectHandler);
                continue;
            }
            RemotingConnectionEJBReceiver ejbReceiver = new RemotingConnectionEJBReceiver(connection, (ReconnectHandler)reconnectHandler, options, outboundConnectionService.getProtocol());
            context.registerEJBReceiver((EJBReceiver)ejbReceiver);
            ++numRemotingReceivers;
        }
        logger.debugf("Added %s remoting EJB receivers to descriptor based EJB client context %s", numRemotingReceivers, (Object)startContext.getController().getName());
    }

    private class OutboundConnectionReconnectHandler
    implements ReconnectHandler {
        private final ServiceRegistry serviceRegistry;
        private final ServiceName outboundConnectionServiceName;
        private final EJBClientContext clientContext;
        private volatile int reconnectAttemptCount;
        private final long connectionTimeout;
        private final OptionMap channelCreationOpts;

        OutboundConnectionReconnectHandler(ServiceRegistry serviceRegistry, ServiceName outboundConnectionServiceName, EJBClientContext clientContext, long connectionTimeout, OptionMap channelCreationOpts) {
            this.outboundConnectionServiceName = outboundConnectionServiceName;
            this.serviceRegistry = serviceRegistry;
            this.clientContext = clientContext;
            this.connectionTimeout = connectionTimeout;
            this.channelCreationOpts = channelCreationOpts;
        }

        public void reconnect() throws IOException {
            ++this.reconnectAttemptCount;
            ServiceController serviceController = this.serviceRegistry.getService(this.outboundConnectionServiceName);
            if (serviceController == null) {
                logger.debugf("Unregistering %s since %s is no longer available", (Object)this, (Object)this.outboundConnectionServiceName);
                this.clientContext.unregisterReconnectHandler((ReconnectHandler)this);
                return;
            }
            AbstractOutboundConnectionService outboundConnectionService = (AbstractOutboundConnectionService)serviceController.getValue();
            try {
                IoFuture futureConnection = outboundConnectionService.connect();
                Connection connection = (Connection)IoFutureHelper.get((IoFuture)futureConnection, (long)this.connectionTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
                logger.debugf("Successful reconnect attempt#%s to outbound connection %s", this.reconnectAttemptCount, (Object)this.outboundConnectionServiceName);
                this.clientContext.unregisterReconnectHandler((ReconnectHandler)this);
                RemotingConnectionEJBReceiver receiver = new RemotingConnectionEJBReceiver(connection, (ReconnectHandler)this, this.channelCreationOpts, outboundConnectionService.getProtocol());
                this.clientContext.registerEJBReceiver((EJBReceiver)receiver);
            }
            catch (Exception e) {
                logger.debugf((Throwable)e, "Reconnect attempt#%s failed for outbound connection %s", this.reconnectAttemptCount, (Object)this.outboundConnectionServiceName);
            }
        }
    }
}

