/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.server.HttpHandler;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.httpclient.common.HTTPTestServer;
import org.wildfly.httpclient.common.HostPool;
import org.wildfly.httpclient.common.HttpConnectionPool;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.OptionMap;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSourceChannel;

@RunWith(value=HTTPTestServer.class)
public class ConnectionPoolTestCase {
    static final int THREADS = 20;
    static final int MAX_CONNECTION_COUNT = 3;
    static final int CONNECTION_IDLE_TIMEOUT = 1000;
    static String MAX_CONNECTIONS_PATH = "/max-connections-test";
    static String IDLE_TIMEOUT_PATH = "/idle-timeout-path";
    private static final List<ServerConnection> connections = new CopyOnWriteArrayList<ServerConnection>();
    private static volatile long currentRequests;
    private static volatile long maxActiveRequests;

    @Test
    public void testIdleTimeout() throws Exception {
        HTTPTestServer.registerPathHandler(IDLE_TIMEOUT_PATH, exchange -> connections.add(exchange.getConnection()));
        HttpConnectionPool pool = new HttpConnectionPool(1, 1, HTTPTestServer.getWorker(), HTTPTestServer.getBufferPool(), OptionMap.EMPTY, new HostPool(new URI(HTTPTestServer.getDefaultRootServerURL())), 1000L);
        AtomicReference<Throwable> failed = new AtomicReference<Throwable>();
        CountDownLatch latch = new CountDownLatch(2);
        this.doInvocation(IDLE_TIMEOUT_PATH, pool, latch, failed);
        this.doInvocation(IDLE_TIMEOUT_PATH, pool, latch, failed);
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        this.checkFailed(failed);
        Assert.assertEquals((long)2L, (long)connections.size());
        Assert.assertEquals((Object)connections.get(0), (Object)connections.get(1));
        connections.clear();
        latch = new CountDownLatch(2);
        this.doInvocation(IDLE_TIMEOUT_PATH, pool, latch, failed);
        Thread.sleep(2000L);
        this.doInvocation(IDLE_TIMEOUT_PATH, pool, latch, failed);
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        this.checkFailed(failed);
        Assert.assertEquals((long)2L, (long)connections.size());
        Assert.assertNotEquals((Object)connections.get(0), (Object)connections.get(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxConnections() throws Exception {
        HTTPTestServer.registerPathHandler(MAX_CONNECTIONS_PATH, (HttpHandler)new BlockingHandler(exchange -> {
            Class<ConnectionPoolTestCase> clazz = ConnectionPoolTestCase.class;
            synchronized (ConnectionPoolTestCase.class) {
                if (++currentRequests > maxActiveRequests) {
                    maxActiveRequests = currentRequests;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                Thread.sleep(200L);
                clazz = ConnectionPoolTestCase.class;
                synchronized (ConnectionPoolTestCase.class) {
                    --currentRequests;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }));
        HttpConnectionPool pool = new HttpConnectionPool(3, 1, HTTPTestServer.getWorker(), HTTPTestServer.getBufferPool(), OptionMap.EMPTY, new HostPool(new URI(HTTPTestServer.getDefaultRootServerURL())), -1L);
        ExecutorService executor = Executors.newFixedThreadPool(20);
        ArrayList<CountDownLatch> results = new ArrayList<CountDownLatch>();
        AtomicReference<Throwable> failed = new AtomicReference<Throwable>();
        try {
            for (int i = 0; i < 40; ++i) {
                CountDownLatch latch = new CountDownLatch(1);
                results.add(latch);
                this.doInvocation(MAX_CONNECTIONS_PATH, pool, latch, failed);
            }
            for (CountDownLatch i : results) {
                Assert.assertTrue((boolean)i.await(10L, TimeUnit.SECONDS));
            }
            this.checkFailed(failed);
            Assert.assertEquals((long)3L, (long)maxActiveRequests);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void doInvocation(String path, HttpConnectionPool pool, final CountDownLatch latch, final AtomicReference<Throwable> failed) {
        pool.getConnection(connectionHandle -> {
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(path);
            this.setupBasicAuth(request, connectionHandle.getUri());
            request.getRequestHeaders().add(Headers.HOST, HTTPTestServer.getHostAddress());
            connectionHandle.getConnection().sendRequest(request, (ClientCallback)new ClientCallback<ClientExchange>(){

                public void completed(ClientExchange result) {
                    result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                        public void completed(ClientExchange result) {
                            try {
                                Channels.drain((StreamSourceChannel)result.getResponseChannel(), (long)Long.MAX_VALUE);
                                connectionHandle.done(false);
                                latch.countDown();
                            }
                            catch (IOException e) {
                                failed.set(e);
                                latch.countDown();
                            }
                        }

                        public void failed(IOException e) {
                            failed.set(e);
                            latch.countDown();
                            connectionHandle.done(true);
                        }
                    });
                }

                public void failed(IOException e) {
                    failed.set(e);
                    latch.countDown();
                    connectionHandle.done(true);
                }
            });
        }, error -> {
            failed.set(error);
            latch.countDown();
        }, false, null);
    }

    private void checkFailed(AtomicReference<Throwable> failed) {
        Throwable failure = failed.get();
        if (failure != null) {
            throw new RuntimeException(failure);
        }
    }

    private void setupBasicAuth(ClientRequest request, URI uri) {
        AuthenticationContext context = AuthenticationContext.captureCurrent();
        AuthenticationConfiguration config = new AuthenticationContextConfigurationClient().getAuthenticationConfiguration(uri, context);
        Principal principal = new AuthenticationContextConfigurationClient().getPrincipal(config);
        PasswordCallback callback = new PasswordCallback("password", false);
        try {
            new AuthenticationContextConfigurationClient().getCallbackHandler(config).handle(new Callback[]{callback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            return;
        }
        char[] password = callback.getPassword();
        String challenge = principal.getName() + ":" + new String(password);
        request.getRequestHeaders().put(Headers.AUTHORIZATION, "basic " + FlexBase64.encodeString((byte[])challenge.getBytes(StandardCharsets.UTF_8), (boolean)false));
    }
}

