/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.conduits.GzipStreamSourceConduit;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.AllowedMethodsHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.server.handlers.encoding.RequestEncodingHandler;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.CancelHandle;
import org.wildfly.httpclient.ejb.HttpCancelHandler;
import org.wildfly.httpclient.ejb.HttpDiscoveryHandler;
import org.wildfly.httpclient.ejb.HttpInvocationHandler;
import org.wildfly.httpclient.ejb.HttpSessionOpenHandler;
import org.wildfly.httpclient.ejb.InvocationIdentifier;
import org.wildfly.transaction.client.LocalTransactionContext;

public class EjbHttpService {
    private final Association association;
    private final ExecutorService executorService;
    private final LocalTransactionContext localTransactionContext;
    private final Function<String, Boolean> classResolverFilter;
    private final Map<InvocationIdentifier, CancelHandle> cancellationFlags = new ConcurrentHashMap<InvocationIdentifier, CancelHandle>();

    public EjbHttpService(Association association, ExecutorService executorService, LocalTransactionContext localTransactionContext) {
        this(association, executorService, localTransactionContext, null);
    }

    public EjbHttpService(Association association, ExecutorService executorService, LocalTransactionContext localTransactionContext, Function<String, Boolean> classResolverFilter) {
        this.association = association;
        this.executorService = executorService;
        this.localTransactionContext = localTransactionContext;
        this.classResolverFilter = classResolverFilter;
    }

    public HttpHandler createHttpHandler() {
        PathHandler pathHandler = new PathHandler();
        pathHandler.addPrefixPath("/v1/invoke", (HttpHandler)new AllowedMethodsHandler((HttpHandler)new HttpInvocationHandler(this.association, this.executorService, this.localTransactionContext, this.cancellationFlags, this.classResolverFilter), new HttpString[]{Methods.POST})).addPrefixPath("/v1/open", (HttpHandler)new AllowedMethodsHandler((HttpHandler)new HttpSessionOpenHandler(this.association, this.executorService, this.localTransactionContext), new HttpString[]{Methods.POST})).addPrefixPath("/v1/cancel", (HttpHandler)new AllowedMethodsHandler((HttpHandler)new HttpCancelHandler(this.association, this.executorService, this.localTransactionContext, this.cancellationFlags), new HttpString[]{Methods.DELETE})).addPrefixPath("/v1/discover", (HttpHandler)new AllowedMethodsHandler((HttpHandler)new HttpDiscoveryHandler(this.executorService, this.association), new HttpString[]{Methods.GET}));
        EncodingHandler encodingHandler = new EncodingHandler((HttpHandler)pathHandler, new ContentEncodingRepository().addEncodingHandler(Headers.GZIP.toString(), (ContentEncodingProvider)new GzipEncodingProvider(), 1));
        RequestEncodingHandler requestEncodingHandler = new RequestEncodingHandler((HttpHandler)encodingHandler);
        requestEncodingHandler.addEncoding(Headers.GZIP.toString(), GzipStreamSourceConduit.WRAPPER);
        return requestEncodingHandler;
    }
}

