/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.iiop.openjdk.IIOPRootDefinition;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;

public class ConfigValidator {
    private ConfigValidator() {
    }

    public static List<String> validateConfig(OperationContext context, ModelNode resourceModel) throws OperationFailedException {
        LinkedList<String> warnings = new LinkedList<String>();
        ConfigValidator.validateSocketBindings(context, resourceModel);
        boolean supportSSL = IIOPRootDefinition.SUPPORT_SSL.resolveModelAttribute(context, resourceModel).asBoolean();
        boolean serverRequiresSsl = IIOPRootDefinition.SERVER_REQUIRES_SSL.resolveModelAttribute(context, resourceModel).asBoolean();
        boolean clientRequiresSsl = IIOPRootDefinition.CLIENT_REQUIRES_SSL.resolveModelAttribute(context, resourceModel).asBoolean();
        boolean sslConfigured = ConfigValidator.isSSLConfigured(context, resourceModel);
        ConfigValidator.validateSSLConfig(supportSSL, sslConfigured, serverRequiresSsl, clientRequiresSsl);
        ConfigValidator.validateSSLSocketBinding(context, resourceModel, sslConfigured, warnings);
        ConfigValidator.validateIORTransportConfig(context, resourceModel, supportSSL, serverRequiresSsl, warnings);
        ConfigValidator.validateORBInitializerConfig(context, resourceModel);
        return warnings;
    }

    private static void validateSocketBindings(OperationContext context, ModelNode resourceModel) throws OperationFailedException {
        ModelNode socketBinding = IIOPRootDefinition.SOCKET_BINDING.resolveModelAttribute(context, resourceModel);
        ModelNode sslSocketBinding = IIOPRootDefinition.SSL_SOCKET_BINDING.resolveModelAttribute(context, resourceModel);
        if (!socketBinding.isDefined() && !sslSocketBinding.isDefined()) {
            throw IIOPLogger.ROOT_LOGGER.noSocketBindingsConfigured();
        }
    }

    private static boolean isSSLConfigured(OperationContext context, ModelNode resourceModel) throws OperationFailedException {
        ModelNode securityDomainNode = IIOPRootDefinition.SECURITY_DOMAIN.resolveModelAttribute(context, resourceModel);
        ModelNode serverSSLContextNode = IIOPRootDefinition.SERVER_SSL_CONTEXT.resolveModelAttribute(context, resourceModel);
        ModelNode clientSSLContextNode = IIOPRootDefinition.CLIENT_SSL_CONTEXT.resolveModelAttribute(context, resourceModel);
        return securityDomainNode.isDefined() || serverSSLContextNode.isDefined() && clientSSLContextNode.isDefined();
    }

    private static void validateSSLConfig(boolean supportSSL, boolean sslConfigured, boolean serverRequiresSsl, boolean clientRequiresSsl) throws OperationFailedException {
        if (supportSSL) {
            if (!sslConfigured) {
                throw IIOPLogger.ROOT_LOGGER.noSecurityDomainOrSSLContextsSpecified();
            }
        } else if (serverRequiresSsl || clientRequiresSsl) {
            throw IIOPLogger.ROOT_LOGGER.sslNotConfigured();
        }
    }

    private static void validateSSLSocketBinding(OperationContext context, ModelNode resourceModel, boolean sslConfigured, List<String> warnings) throws OperationFailedException {
        ModelNode sslSocketBinding = IIOPRootDefinition.SSL_SOCKET_BINDING.resolveModelAttribute(context, resourceModel);
        if (sslSocketBinding.isDefined() && !sslConfigured) {
            String warning = IIOPLogger.ROOT_LOGGER.sslPortWithoutSslConfiguration();
            IIOPLogger.ROOT_LOGGER.warn(warning);
            warnings.add(warning);
        }
    }

    private static void validateIORTransportConfig(OperationContext context, ModelNode resourceModel, boolean sslConfigured, boolean serverRequiresSsl, List<String> warnings) throws OperationFailedException {
        ConfigValidator.validateSSLAttribute(context, resourceModel, sslConfigured, serverRequiresSsl, IIOPRootDefinition.INTEGRITY, warnings);
        ConfigValidator.validateSSLAttribute(context, resourceModel, sslConfigured, serverRequiresSsl, IIOPRootDefinition.CONFIDENTIALITY, warnings);
        ConfigValidator.validateSSLAttribute(context, resourceModel, sslConfigured, serverRequiresSsl, IIOPRootDefinition.TRUST_IN_CLIENT, warnings);
        ConfigValidator.validateTrustInTarget(context, resourceModel, sslConfigured, warnings);
        ConfigValidator.validateSupportedAttribute(context, resourceModel, IIOPRootDefinition.DETECT_MISORDERING, warnings);
        ConfigValidator.validateSupportedAttribute(context, resourceModel, IIOPRootDefinition.DETECT_REPLAY, warnings);
    }

    private static void validateSSLAttribute(OperationContext context, ModelNode resourceModel, boolean sslConfigured, boolean serverRequiresSsl, AttributeDefinition attributeDefinition, List<String> warnings) throws OperationFailedException {
        ModelNode attributeNode = attributeDefinition.resolveModelAttribute(context, resourceModel);
        if (attributeNode.isDefined()) {
            String attribute = attributeNode.asString();
            if (sslConfigured) {
                String warning;
                if (attribute.equals("none")) {
                    warning = IIOPLogger.ROOT_LOGGER.inconsistentSupportedTransportConfig(attributeDefinition.getName(), serverRequiresSsl ? "required" : "supported");
                    IIOPLogger.ROOT_LOGGER.warn(warning);
                    warnings.add(warning);
                }
                if (serverRequiresSsl && attribute.equals("supported")) {
                    warning = IIOPLogger.ROOT_LOGGER.inconsistentRequiredTransportConfig("server-requires-ssl", attributeDefinition.getName());
                    IIOPLogger.ROOT_LOGGER.warn(warning);
                    warnings.add(warning);
                }
            } else if (!attribute.equals("none")) {
                String warning = IIOPLogger.ROOT_LOGGER.inconsistentUnsupportedTransportConfig(attributeDefinition.getName());
                IIOPLogger.ROOT_LOGGER.warn(warning);
                warnings.add(warning);
            }
        }
    }

    private static void validateTrustInTarget(OperationContext context, ModelNode resourceModel, boolean sslConfigured, List<String> warnings) throws OperationFailedException {
        ModelNode establishTrustInTargetNode = IIOPRootDefinition.TRUST_IN_TARGET.resolveModelAttribute(context, resourceModel);
        if (establishTrustInTargetNode.isDefined()) {
            String establishTrustInTarget = establishTrustInTargetNode.asString();
            if (sslConfigured && establishTrustInTarget.equals("none")) {
                String warning = IIOPLogger.ROOT_LOGGER.inconsistentSupportedTransportConfig("trust-in-target", "supported");
                IIOPLogger.ROOT_LOGGER.warn(warning);
                warnings.add(warning);
            }
        }
    }

    private static void validateSupportedAttribute(OperationContext context, ModelNode resourceModel, AttributeDefinition attributeDefinition, List<String> warnings) throws OperationFailedException {
        ModelNode attributeNode = attributeDefinition.resolveModelAttribute(context, resourceModel);
        if (attributeNode.isDefined() && !attributeNode.asString().equals("supported")) {
            String warning = IIOPLogger.ROOT_LOGGER.inconsistentSupportedTransportConfig(attributeDefinition.getName(), "supported");
            IIOPLogger.ROOT_LOGGER.warn(warning);
            warnings.add(warning);
        }
    }

    private static void validateORBInitializerConfig(OperationContext context, ModelNode resourceModel) throws OperationFailedException {
        ModelNode securityInitializerNode = IIOPRootDefinition.SECURITY.resolveModelAttribute(context, resourceModel);
        ModelNode authContextNode = IIOPRootDefinition.AUTHENTICATION_CONTEXT.resolveModelAttribute(context, resourceModel);
        if (!(securityInitializerNode.isDefined() && securityInitializerNode.asString().equalsIgnoreCase("elytron") || !authContextNode.isDefined())) {
            throw IIOPLogger.ROOT_LOGGER.ineffectiveAuthenticationContextConfiguration();
        }
    }
}

