/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jaxrs.DeploymentRestResourcesDefintion;
import org.jboss.as.jaxrs.JaxrsDeploymentDefinition;
import org.jboss.as.jaxrs.JaxrsSubsystemDefinition;
import org.jboss.as.jaxrs.JaxrsSubsystemParser_1_0;
import org.jboss.as.jaxrs.JaxrsSubsystemParser_2_0;
import org.jboss.as.jaxrs.JaxrsSubsystemParser_3_0;
import org.jboss.as.jaxrs.logging.JaxrsLogger;

public class JaxrsExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jaxrs";
    static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)4, (int)0, (int)0);
    private static final String RESOURCE_NAME = JaxrsExtension.class.getPackage().getName() + ".LocalDescriptions";
    static PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"jaxrs");

    static ResourceDescriptionResolver getResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, JaxrsExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        JaxrsLogger.JAXRS_LOGGER.debug("Activating Jakarta RESTful Web Services Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new JaxrsSubsystemDefinition());
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        ManagementResourceRegistration jaxrsResReg = subsystem.registerDeploymentModel((ResourceDefinition)new JaxrsDeploymentDefinition());
        jaxrsResReg.registerSubModel((ResourceDefinition)new DeploymentRestResourcesDefintion());
        subsystem.registerXMLElementWriter(JaxrsSubsystemParser_3_0::new);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:jboss:domain:jaxrs:1.0", JaxrsSubsystemParser_1_0::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:jboss:domain:jaxrs:2.0", JaxrsSubsystemParser_2_0::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:jboss:domain:jaxrs:3.0", JaxrsSubsystemParser_3_0::new);
    }
}

