/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq.BroadcastGroupAdd;
import org.wildfly.extension.messaging.activemq.BroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.GroupBindingService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.SocketBroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class SocketBroadcastGroupAdd
extends AbstractAddStepHandler {
    public static final SocketBroadcastGroupAdd INSTANCE = new SocketBroadcastGroupAdd(true);
    public static final SocketBroadcastGroupAdd LEGACY_INSTANCE = new SocketBroadcastGroupAdd(false);
    private final boolean needLegacyCall;

    private SocketBroadcastGroupAdd(boolean needLegacyCall) {
        super(SocketBroadcastGroupDefinition.ATTRIBUTES);
        this.needLegacyCall = needLegacyCall;
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        final ModelNode connectorRefs = resource.getModel().require(BroadcastGroupDefinition.CONNECTOR_REFS.getName());
        if (connectorRefs.isDefined()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    BroadcastGroupDefinition.validateConnectors(context, operation, connectorRefs);
                }
            }, OperationContext.Stage.MODEL);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (this.needLegacyCall) {
            PathAddress target = context.getCurrentAddress().getParent().append("broadcast-group", context.getCurrentAddressValue());
            ModelNode op = operation.clone();
            op.get("address").set(target.toModelNode());
            context.addStep(op, (OperationStepHandler)BroadcastGroupAdd.LEGACY_INSTANCE, OperationContext.Stage.MODEL, true);
        }
        super.execute(context, operation);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName serviceName;
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceController service = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (service != null) {
            context.reloadRequired();
        } else {
            String name = context.getCurrentAddressValue();
            ServiceTarget target = context.getServiceTarget();
            ServiceBuilder builder = target.addService(GroupBindingService.getBroadcastBaseServiceName(serviceName).append(new String[]{name}));
            builder.setInstance((Service)new GroupBindingService(builder.requires(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{model.get("socket-binding").asString()}))));
            builder.install();
        }
    }

    static void addBroadcastGroupConfigs(OperationContext context, List<BroadcastGroupConfiguration> configs, Set<String> connectors, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("socket-broadcast-group")) {
            for (Property prop : model.get("socket-broadcast-group").asPropertyList()) {
                configs.add(SocketBroadcastGroupAdd.createBroadcastGroupConfiguration(context, connectors, prop.getName(), prop.getValue()));
            }
        }
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(OperationContext context, Set<String> connectors, String name, ModelNode model) throws OperationFailedException {
        long broadcastPeriod = BroadcastGroupDefinition.BROADCAST_PERIOD.resolveModelAttribute(context, model).asLong();
        ArrayList<String> connectorRefs = new ArrayList<String>();
        if (model.hasDefined("connectors")) {
            for (ModelNode ref : model.get("connectors").asList()) {
                String refName = ref.asString();
                if (!connectors.contains(refName)) {
                    throw MessagingLogger.ROOT_LOGGER.wrongConnectorRefInBroadCastGroup(name, refName, connectors);
                }
                connectorRefs.add(refName);
            }
        }
        return new BroadcastGroupConfiguration().setName(name).setBroadcastPeriod(broadcastPeriod).setConnectorInfos(connectorRefs);
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(String name, BroadcastGroupConfiguration config, SocketBinding socketBinding) throws Exception {
        String localAddress = socketBinding.getAddress().getHostAddress();
        if (socketBinding.getMulticastAddress() == null) {
            throw MessagingLogger.ROOT_LOGGER.socketBindingMulticastNotSet("socket-broadcast-group", name, socketBinding.getName());
        }
        String groupAddress = socketBinding.getMulticastAddress().getHostAddress();
        int localPort = socketBinding.getPort();
        int groupPort = socketBinding.getMulticastPort();
        long broadcastPeriod = config.getBroadcastPeriod();
        List connectorRefs = config.getConnectorInfos();
        UDPBroadcastEndpointFactory endpointFactory = new UDPBroadcastEndpointFactory().setGroupAddress(groupAddress).setGroupPort(groupPort).setLocalBindAddress(localAddress).setLocalBindPort(localPort);
        return new BroadcastGroupConfiguration().setName(name).setBroadcastPeriod(broadcastPeriod).setConnectorInfos(connectorRefs).setEndpointFactory((BroadcastEndpointFactory)endpointFactory);
    }
}

