/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.Unmanaged;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.wildfly.extension.microprofile.health.HealthReporter;
import org.wildfly.extension.microprofile.health._private.MicroProfileHealthLogger;

public class CDIExtension
implements Extension {
    private final HealthReporter reporter;
    private List<AnnotatedType<? extends HealthCheck>> healthDelegates = new ArrayList<AnnotatedType<? extends HealthCheck>>();
    private Collection<Unmanaged.UnmanagedInstance<HealthCheck>> healthInstances = new ArrayList<Unmanaged.UnmanagedInstance<HealthCheck>>();
    private List<AnnotatedType<? extends HealthCheck>> livenessDelegates = new ArrayList<AnnotatedType<? extends HealthCheck>>();
    private Collection<Unmanaged.UnmanagedInstance<HealthCheck>> livenessInstances = new ArrayList<Unmanaged.UnmanagedInstance<HealthCheck>>();
    private List<AnnotatedType<? extends HealthCheck>> readinessDelegates = new ArrayList<AnnotatedType<? extends HealthCheck>>();
    private Collection<Unmanaged.UnmanagedInstance<HealthCheck>> readinessInstances = new ArrayList<Unmanaged.UnmanagedInstance<HealthCheck>>();

    public CDIExtension(HealthReporter healthReporter) {
        this.reporter = healthReporter;
    }

    public void observeResources(@Observes ProcessAnnotatedType<? extends HealthCheck> event) {
        Class javaClass = event.getAnnotatedType().getJavaClass();
        if (event.getAnnotatedType().isAnnotationPresent(Health.class)) {
            MicroProfileHealthLogger.LOGGER.debugf("Discovered health check procedure %s", javaClass);
            this.healthDelegates.add((AnnotatedType<? extends HealthCheck>)event.getAnnotatedType());
        } else if (event.getAnnotatedType().isAnnotationPresent(Liveness.class)) {
            MicroProfileHealthLogger.LOGGER.debugf("Discovered liveness check procedure %s", javaClass);
            this.livenessDelegates.add((AnnotatedType<? extends HealthCheck>)event.getAnnotatedType());
        } else if (event.getAnnotatedType().isAnnotationPresent(Readiness.class)) {
            MicroProfileHealthLogger.LOGGER.debugf("Discovered liveness check procedure %s", javaClass);
            this.readinessDelegates.add((AnnotatedType<? extends HealthCheck>)event.getAnnotatedType());
        }
    }

    private void afterDeploymentValidation(@Observes AfterDeploymentValidation avd, BeanManager bm) {
        this.addHealthCheck(bm, this.healthDelegates, this.healthInstances, this.reporter::addHealthCheck);
        this.addHealthCheck(bm, this.readinessDelegates, this.readinessInstances, this.reporter::addReadinessCheck);
        this.addHealthCheck(bm, this.livenessDelegates, this.livenessInstances, this.reporter::addLivenessCheck);
    }

    private void addHealthCheck(BeanManager bm, List<AnnotatedType<? extends HealthCheck>> delegates, Collection<Unmanaged.UnmanagedInstance<HealthCheck>> instances, Consumer<HealthCheck> healthFunction) {
        for (AnnotatedType<? extends HealthCheck> delegate : delegates) {
            try {
                Unmanaged unmanagedHealthCheck = new Unmanaged(bm, delegate.getJavaClass());
                Unmanaged.UnmanagedInstance healthCheckInstance = unmanagedHealthCheck.newInstance();
                HealthCheck healthCheck = (HealthCheck)healthCheckInstance.produce().inject().postConstruct().get();
                instances.add((Unmanaged.UnmanagedInstance<HealthCheck>)healthCheckInstance);
                healthFunction.accept(healthCheck);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to register health bean", e);
            }
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown bs) {
        this.removeHealthCheck(this.healthInstances, this.reporter::removeHealthCheck);
        this.removeHealthCheck(this.readinessInstances, this.reporter::removeReadinessCheck);
        this.removeHealthCheck(this.livenessInstances, this.reporter::removeLivenessCheck);
    }

    private void removeHealthCheck(Collection<Unmanaged.UnmanagedInstance<HealthCheck>> instances, Consumer<HealthCheck> healthFunction) {
        instances.forEach(healthCheck -> {
            healthFunction.accept((HealthCheck)healthCheck.get());
            healthCheck.preDestroy().dispose();
        });
        instances.clear();
    }
}

