/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.utils.ObjectCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class RefCountMessage {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean REF_DEBUG = System.getProperty("ARTEMIS_REF_DEBUG") != null;
    private DebugState debugStatus;
    private static final AtomicIntegerFieldUpdater<RefCountMessage> DURABLE_REF_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RefCountMessage.class, "durableRefCount");
    private static final AtomicIntegerFieldUpdater<RefCountMessage> REF_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RefCountMessage.class, "refCount");
    private static final AtomicIntegerFieldUpdater<RefCountMessage> REF_USAGE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RefCountMessage.class, "usageCount");
    private volatile Map userContext;
    private volatile int durableRefCount = 0;
    private volatile int refCount = 0;
    private volatile int usageCount = 0;
    private volatile boolean released = false;
    private volatile boolean errorCheck = true;
    private volatile RefCountMessage parentRef;

    public static boolean isRefDebugEnabled() {
        return REF_DEBUG && logger.isDebugEnabled();
    }

    public static boolean isRefTraceEnabled() {
        return REF_DEBUG && logger.isTraceEnabled();
    }

    protected void registerDebug() {
        if (this.debugStatus == null) {
            this.debugStatus = new DebugState(this.toString());
            ObjectCleaner.register(this, this.debugStatus);
        }
    }

    public boolean isReleased() {
        return this.released;
    }

    public String debugLocations() {
        if (this.debugStatus != null) {
            return this.debugStatus.debugLocations();
        }
        return "";
    }

    public static void deferredDebug(Message message, String debugMessage, Object ... args) {
        if (message instanceof RefCountMessage) {
            RefCountMessage countMessage = (RefCountMessage)((Object)message);
            if (RefCountMessage.isRefDebugEnabled()) {
                RefCountMessage.deferredDebug(countMessage, debugMessage, args);
            }
        }
    }

    public static void deferredDebug(RefCountMessage message, String debugMessage, Object ... args) {
        String formattedDebug = MessageFormatter.arrayFormat(debugMessage, args).getMessage();
        message.deferredDebug(formattedDebug);
    }

    public void deferredDebug(String message) {
        if (this.parentRef != null) {
            this.parentRef.deferredDebug(message);
        }
        if (this.debugStatus != null) {
            this.debugStatus.addDebug(message);
        }
    }

    public int getRefCount() {
        return REF_COUNT_UPDATER.get(this);
    }

    public int getUsage() {
        return REF_USAGE_UPDATER.get(this);
    }

    public int getDurableCount() {
        return DURABLE_REF_COUNT_UPDATER.get(this);
    }

    public RefCountMessage getParentRef() {
        return this.parentRef;
    }

    protected void onUp() {
        if (this.debugStatus != null) {
            this.debugStatus.up(this.counterString());
        }
    }

    protected void released() {
        this.released = true;
        this.disableErrorCheck();
    }

    void runOnLeak(Runnable run) {
        if (this.debugStatus != null) {
            this.debugStatus.runWhenLeaked = run;
        }
    }

    public void disableErrorCheck() {
        this.errorCheck = false;
        if (this.debugStatus != null) {
            this.debugStatus.accountedFor();
        }
    }

    protected void onDown() {
        if (this.debugStatus != null) {
            this.debugStatus.down(this.counterString());
        }
        if (this.getRefCount() <= 0 && this.getUsage() <= 0 && this.getDurableCount() <= 0 && !this.released) {
            this.released();
            this.releaseComplete();
        }
    }

    protected String counterString() {
        return "refCount=" + this.getRefCount() + ", durableRefCount=" + this.getDurableCount() + ", usageCount=" + this.getUsage() + ", parentRef=" + String.valueOf(this.parentRef);
    }

    public void setParentRef(RefCountMessage origin) {
        this.parentRef = origin.getParentRef() != null ? origin.getParentRef() : origin;
    }

    protected void releaseComplete() {
    }

    public int usageUp() {
        if (this.parentRef != null) {
            return this.parentRef.usageUp();
        }
        int count = REF_USAGE_UPDATER.incrementAndGet(this);
        this.onUp();
        return count;
    }

    public int usageDown() {
        if (this.parentRef != null) {
            return this.parentRef.usageDown();
        }
        int count = REF_USAGE_UPDATER.decrementAndGet(this);
        this.onDown();
        return count;
    }

    public int durableUp() {
        if (this.parentRef != null) {
            return this.parentRef.durableUp();
        }
        int count = DURABLE_REF_COUNT_UPDATER.incrementAndGet(this);
        this.onUp();
        return count;
    }

    public int durableDown() {
        if (this.parentRef != null) {
            return this.parentRef.durableDown();
        }
        int count = DURABLE_REF_COUNT_UPDATER.decrementAndGet(this);
        if (this.errorCheck && count < 0) {
            this.reportNegativeCount();
        }
        this.onDown();
        return count;
    }

    private void reportNegativeCount() {
        if (this.debugStatus != null) {
            this.debugStatus.addDebug("Negative counter " + this.counterString());
        }
        ActiveMQClientLogger.LOGGER.negativeRefCount(String.valueOf(this), this.counterString(), this.debugLocations());
    }

    public int refDown() {
        if (this.parentRef != null) {
            return this.parentRef.refDown();
        }
        int count = REF_COUNT_UPDATER.decrementAndGet(this);
        if (this.errorCheck && count < 0) {
            this.reportNegativeCount();
        }
        this.onDown();
        return count;
    }

    public int refUp() {
        if (this.parentRef != null) {
            return this.parentRef.refUp();
        }
        int count = REF_COUNT_UPDATER.incrementAndGet(this);
        this.onUp();
        return count;
    }

    public Object getUserContext(Object key) {
        if (this.userContext == null) {
            return null;
        }
        return this.userContext.get(key);
    }

    public void setUserContext(Object key, Object value) {
        if (this.userContext == null) {
            this.userContext = new HashMap();
        }
        this.userContext.put(key, value);
    }

    private static class DebugState
    implements Runnable {
        private final List<Exception> debugCrumbs = new ArrayList<Exception>();
        volatile boolean accounted;
        volatile boolean referenced;
        String description;
        Runnable runWhenLeaked;

        DebugState(String description) {
            this.description = description;
            this.addDebug("registered");
        }

        void accountedFor() {
            this.accounted = true;
        }

        static String getTime() {
            return Instant.now().toString();
        }

        void addDebug(String event) {
            this.debugCrumbs.add(new Exception(event + " at " + DebugState.getTime()));
            if (this.accounted) {
                logger.debug("Message Previously Released {}, {}, \n{}", this.description, event, this.debugLocations());
            }
        }

        void up(String description) {
            this.referenced = true;
            this.debugCrumbs.add(new Exception("up:" + description + " at " + DebugState.getTime()));
        }

        void down(String description) {
            this.debugCrumbs.add(new Exception("down:" + description + " at " + DebugState.getTime()));
        }

        @Override
        public void run() {
            if (!this.accounted && this.referenced) {
                this.runWhenLeaked.run();
                logger.debug("Message Leaked reference counting{}\n{}", (Object)this.description, (Object)this.debugLocations());
            }
        }

        String debugLocations() {
            StringWriter writer = new StringWriter();
            PrintWriter outWriter = new PrintWriter(writer);
            outWriter.println("Locations:");
            this.debugCrumbs.forEach(e -> e.printStackTrace(outWriter));
            return writer.toString();
        }
    }
}

