/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.client.ClientRequest;
import jakarta.ejb.Asynchronous;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.EJBReceiverSessionCreationContext;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.common.WildflyHttpContext;
import org.wildfly.httpclient.ejb.ClientHandlers;
import org.wildfly.httpclient.ejb.Constants;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.HttpProtocolV1ObjectResolver;
import org.wildfly.httpclient.ejb.HttpProtocolV1ObjectTable;
import org.wildfly.httpclient.ejb.RequestBuilder;
import org.wildfly.httpclient.ejb.RequestType;
import org.wildfly.httpclient.ejb.TransactionInfo;
import org.wildfly.httpclient.transaction.XidProvider;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.RemoteTransaction;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.XAOutflowHandle;

class HttpEJBReceiver
extends EJBReceiver {
    private static final AuthenticationContextConfigurationClient AUTH_CONTEXT_CLIENT = AccessController.doPrivileged(() -> new AuthenticationContextConfigurationClient());
    private final io.undertow.util.AttachmentKey<EjbContextData> EJB_CONTEXT_DATA = io.undertow.util.AttachmentKey.create(EjbContextData.class);
    private final AttachmentKey<String> INVOCATION_ID = new AttachmentKey();
    private final RemoteTransactionContext transactionContext = System.getSecurityManager() == null ? RemoteTransactionContext.getInstance() : AccessController.doPrivileged(new PrivilegedAction<RemoteTransactionContext>(){

        @Override
        public RemoteTransactionContext run() {
            return RemoteTransactionContext.getInstance();
        }
    });
    private static final AtomicLong invocationIdGenerator = new AtomicLong();
    private static final AuthenticationContextConfigurationClient CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);

    HttpEJBReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processInvocation(EJBReceiverInvocationContext receiverContext) throws Exception {
        EJBClientInvocationContext clientInvocationContext = receiverContext.getClientInvocationContext();
        EJBLocator<?> locator = clientInvocationContext.getLocator();
        URI uri = clientInvocationContext.getDestination();
        WildflyHttpContext current = WildflyHttpContext.getCurrent();
        HttpTargetContext targetContext = current.getTargetContext(uri);
        if (targetContext == null) {
            throw EjbHttpClientMessages.MESSAGES.couldNotResolveTargetForLocator(locator);
        }
        if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
            HttpEJBReceiver httpEJBReceiver = this;
            synchronized (httpEJBReceiver) {
                if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
                    targetContext.putAttachment(this.EJB_CONTEXT_DATA, new EjbContextData());
                }
            }
        }
        targetContext.awaitSessionId(false, AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(targetContext.getUri(), receiverContext.getAuthenticationContext()));
        EjbContextData ejbData = targetContext.getAttachment(this.EJB_CONTEXT_DATA);
        boolean compressResponse = receiverContext.getClientInvocationContext().isCompressResponse();
        boolean compressRequest = receiverContext.getClientInvocationContext().isCompressRequest();
        RequestBuilder builder = new RequestBuilder().setCompressRequest(compressRequest).setCompressResponse(compressResponse).setRequestType(RequestType.INVOKE).setLocator(locator).setMethod(clientInvocationContext.getInvokedMethod()).setView(clientInvocationContext.getViewClass().getName()).setVersion(targetContext.getProtocolVersion());
        if (locator instanceof StatefulEJBLocator) {
            builder.setBeanId(Base64.getUrlEncoder().encodeToString(locator.asStateful().getSessionId().getEncodedForm()));
        }
        if (clientInvocationContext.getInvokedMethod().getReturnType() == Future.class) {
            receiverContext.proceedAsynchronously();
            if (targetContext.getSessionId() != null) {
                long invocationId = invocationIdGenerator.incrementAndGet();
                String invocationIdString = Long.toString(invocationId);
                builder.setInvocationId(invocationIdString);
                clientInvocationContext.putAttachment(this.INVOCATION_ID, invocationIdString);
            }
        } else if (clientInvocationContext.getInvokedMethod().getReturnType() == Void.TYPE) {
            if (clientInvocationContext.getInvokedMethod().isAnnotationPresent(Asynchronous.class)) {
                receiverContext.proceedAsynchronously();
            } else if (ejbData.asyncMethods.contains(clientInvocationContext.getInvokedMethod())) {
                receiverContext.proceedAsynchronously();
            }
        }
        ClientRequest request = builder.createRequest(targetContext.getUri().getPath());
        AuthenticationContext context = receiverContext.getAuthenticationContext();
        AuthenticationContextConfigurationClient client = CLIENT;
        int defaultPort = uri.getScheme().equals("https") ? 443 : 80;
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(uri, context, defaultPort, "jndi", "jboss");
        SSLContext sslContext = client.getSSLContext(uri, context, "jndi", "jboss");
        Marshaller marshaller = this.createMarshaller(targetContext.getUri(), targetContext.getHttpMarshallerFactory(request));
        TransactionInfo transactionInfo = this.getTransactionInfo(clientInvocationContext.getTransaction(), targetContext.getUri());
        Object[] parameters = clientInvocationContext.getParameters();
        Map<String, Object> contextData = clientInvocationContext.getContextData();
        Unmarshaller unmarshaller = this.createUnmarshaller(targetContext.getUri(), targetContext.getHttpMarshallerFactory(request));
        targetContext.sendRequest(request, sslContext, authenticationConfiguration, ClientHandlers.invokeHttpMarshaller(marshaller, transactionInfo, parameters, contextData), ClientHandlers.invokeHttpResultHandler(unmarshaller, receiverContext, clientInvocationContext), e -> receiverContext.requestFailed(e instanceof Exception ? (Exception)e : new RuntimeException(e)), Constants.EJB_RESPONSE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SessionID createSession(EJBReceiverSessionCreationContext receiverContext) throws Exception {
        EJBLocator<?> locator = receiverContext.getClientInvocationContext().getLocator();
        URI uri = receiverContext.getClientInvocationContext().getDestination();
        AuthenticationContext context = receiverContext.getAuthenticationContext();
        AuthenticationContextConfigurationClient client = CLIENT;
        int defaultPort = uri.getScheme().equals("https") ? 443 : 80;
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(uri, context, defaultPort, "jndi", "jboss");
        SSLContext sslContext = client.getSSLContext(uri, context, "jndi", "jboss");
        WildflyHttpContext current = WildflyHttpContext.getCurrent();
        HttpTargetContext targetContext = current.getTargetContext(uri);
        if (targetContext == null) {
            throw EjbHttpClientMessages.MESSAGES.couldNotResolveTargetForLocator(locator);
        }
        if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
            HttpEJBReceiver httpEJBReceiver = this;
            synchronized (httpEJBReceiver) {
                if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
                    targetContext.putAttachment(this.EJB_CONTEXT_DATA, new EjbContextData());
                }
            }
        }
        targetContext.awaitSessionId(true, authenticationConfiguration);
        CompletableFuture result = new CompletableFuture();
        RequestBuilder builder = new RequestBuilder().setRequestType(RequestType.CREATE_SESSION).setLocator(locator).setView(locator.getViewType().getName()).setVersion(targetContext.getProtocolVersion());
        ClientRequest request = builder.createRequest(targetContext.getUri().getPath());
        TransactionInfo transactionInfo = this.getTransactionInfo(ContextTransactionManager.getInstance().getTransaction(), targetContext.getUri());
        Marshaller marshaller = this.createMarshaller(targetContext.getUri(), targetContext.getHttpMarshallerFactory(request));
        targetContext.sendRequest(request, sslContext, authenticationConfiguration, ClientHandlers.createSessionHttpMarshaller(marshaller, transactionInfo), ClientHandlers.emptyHttpResultHandler(result, ClientHandlers.createSessionResponseFunction()), result::completeExceptionally, Constants.EJB_RESPONSE_NEW_SESSION, null);
        return (SessionID)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cancelInvocation(EJBReceiverInvocationContext receiverContext, boolean cancelIfRunning) {
        SSLContext sslContext;
        EJBClientInvocationContext clientInvocationContext = receiverContext.getClientInvocationContext();
        EJBLocator<?> locator = clientInvocationContext.getLocator();
        Affinity affinity = locator.getAffinity();
        URI uri = clientInvocationContext.getDestination();
        AuthenticationContext context = receiverContext.getAuthenticationContext();
        AuthenticationContextConfigurationClient client = CLIENT;
        int defaultPort = uri.getScheme().equals("https") ? 443 : 80;
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(uri, context, defaultPort, "jndi", "jboss");
        try {
            sslContext = client.getSSLContext(uri, context, "jndi", "jboss");
        }
        catch (GeneralSecurityException e) {
            return false;
        }
        WildflyHttpContext current = WildflyHttpContext.getCurrent();
        HttpTargetContext targetContext = current.getTargetContext(uri);
        if (targetContext == null) {
            throw EjbHttpClientMessages.MESSAGES.couldNotResolveTargetForLocator(locator);
        }
        if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
            HttpEJBReceiver httpEJBReceiver = this;
            synchronized (httpEJBReceiver) {
                if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
                    targetContext.putAttachment(this.EJB_CONTEXT_DATA, new EjbContextData());
                }
            }
        }
        targetContext.awaitSessionId(false, authenticationConfiguration);
        RequestBuilder builder = new RequestBuilder().setRequestType(RequestType.CANCEL).setLocator(locator).setCancelIfRunning(cancelIfRunning).setInvocationId(receiverContext.getClientInvocationContext().getAttachment(this.INVOCATION_ID)).setVersion(targetContext.getProtocolVersion());
        CompletableFuture result = new CompletableFuture();
        ClientRequest request = builder.createRequest(targetContext.getUri().getPath());
        targetContext.sendRequest(request, sslContext, authenticationConfiguration, null, ClientHandlers.emptyHttpResultHandler(result, ClientHandlers.cancelInvocationResponseFunction()), result::completeExceptionally, null, null);
        try {
            return (Boolean)result.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
    }

    private Marshaller createMarshaller(URI uri, HttpMarshallerFactory httpMarshallerFactory) throws IOException {
        return httpMarshallerFactory.createMarshaller((ObjectResolver)new HttpProtocolV1ObjectResolver(uri), (ObjectTable)HttpProtocolV1ObjectTable.INSTANCE);
    }

    private Unmarshaller createUnmarshaller(URI uri, HttpMarshallerFactory httpMarshallerFactory) throws IOException {
        return httpMarshallerFactory.createUnmarshaller((ObjectResolver)new HttpProtocolV1ObjectResolver(uri), (ObjectTable)HttpProtocolV1ObjectTable.INSTANCE);
    }

    private TransactionInfo getTransactionInfo(Transaction transaction, URI uri) throws RollbackException, SystemException {
        if (transaction == null) {
            return TransactionInfo.nullTransaction();
        }
        if (transaction instanceof RemoteTransaction) {
            RemoteTransaction remoteTransaction = (RemoteTransaction)transaction;
            remoteTransaction.setLocation(uri);
            XidProvider xidProvider = remoteTransaction.getProviderInterface(XidProvider.class);
            if (xidProvider == null) {
                throw EjbHttpClientMessages.MESSAGES.cannotEnlistTx();
            }
            return TransactionInfo.remoteTransaction(xidProvider.getXid());
        }
        if (transaction instanceof LocalTransaction) {
            LocalTransaction localTransaction = (LocalTransaction)transaction;
            XAOutflowHandle outflowHandle = this.transactionContext.outflowTransaction(uri, localTransaction);
            return TransactionInfo.localTransaction(outflowHandle.getXid(), outflowHandle.getRemainingTime());
        }
        throw EjbHttpClientMessages.MESSAGES.cannotEnlistTx();
    }

    private static class EjbContextData {
        final Set<Method> asyncMethods = Collections.newSetFromMap(new ConcurrentHashMap());

        private EjbContextData() {
        }
    }
}

