/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import jakarta.resource.spi.XATerminator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public interface XARecoverable {
    default public Xid[] recover(int flag) throws XAException {
        return this.recover(flag, null);
    }

    public Xid[] recover(int var1, String var2) throws XAException;

    public void commit(Xid var1, boolean var2) throws XAException;

    public void forget(Xid var1) throws XAException;

    public static XARecoverable from(final XATerminator xaTerminator) {
        return xaTerminator instanceof XARecoverable ? (XARecoverable)((Object)xaTerminator) : new XARecoverable(){

            @Override
            public Xid[] recover(int flag, String parentName) throws XAException {
                return xaTerminator.recover(flag);
            }

            @Override
            public void commit(Xid xid, boolean onePhase) throws XAException {
                xaTerminator.commit(xid, onePhase);
            }

            @Override
            public void forget(Xid xid) throws XAException {
                xaTerminator.forget(xid);
            }
        };
    }

    public static XARecoverable from(final XAResource xaResource) {
        return xaResource instanceof XARecoverable ? (XARecoverable)((Object)xaResource) : new XARecoverable(){

            @Override
            public Xid[] recover(int flag, String parentName) throws XAException {
                return xaResource.recover(flag);
            }

            @Override
            public void commit(Xid xid, boolean onePhase) throws XAException {
                xaResource.commit(xid, onePhase);
            }

            @Override
            public void forget(Xid xid) throws XAException {
                xaResource.forget(xid);
            }
        };
    }
}

