/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import org.jboss.resteasy.core.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.core.interception.LegacyPrecedence;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.MessageBodyWriterContext;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;

public class WriterInterceptorRegistry
extends JaxrsInterceptorRegistry<WriterInterceptor> {
    protected LegacyPrecedence precedence;

    public WriterInterceptorRegistry(ResteasyProviderFactory providerFactory, LegacyPrecedence precedence) {
        super(providerFactory, WriterInterceptor.class);
        this.precedence = precedence;
    }

    public WriterInterceptorRegistry clone(ResteasyProviderFactory factory) {
        WriterInterceptorRegistry clone = new WriterInterceptorRegistry(factory, this.precedence);
        clone.interceptors.addAll(this.interceptors);
        return clone;
    }

    public void registerLegacy(Class<? extends MessageBodyWriterInterceptor> decl) {
        this.register(new JaxrsInterceptorRegistry.LegacyPerMethodInterceptorFactory(decl, this.precedence){

            @Override
            public JaxrsInterceptorRegistry.Match postMatch(Class declaring, AccessibleObject target) {
                Object obj = this.getLegacyMatch(declaring, target);
                if (obj == null) {
                    return null;
                }
                MessageBodyWriterInterceptor interceptor = (MessageBodyWriterInterceptor)obj;
                return new JaxrsInterceptorRegistry.Match(new WriterInterceptorFacade(interceptor), this.order);
            }
        });
    }

    public void registerLegacy(MessageBodyWriterInterceptor interceptor) {
        this.register(new JaxrsInterceptorRegistry.LegacySingletonInterceptorFactory(interceptor.getClass(), (Object)interceptor, this.precedence){

            @Override
            public JaxrsInterceptorRegistry.Match postMatch(Class declaring, AccessibleObject target) {
                Object obj = this.getLegacyMatch(declaring, target);
                if (obj == null) {
                    return null;
                }
                MessageBodyWriterInterceptor interceptor = (MessageBodyWriterInterceptor)obj;
                return new JaxrsInterceptorRegistry.Match(new WriterInterceptorFacade(interceptor), this.order);
            }
        });
    }

    public static class WriterInterceptorFacade
    implements WriterInterceptor {
        protected final MessageBodyWriterInterceptor interceptor;

        public WriterInterceptorFacade(MessageBodyWriterInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        public MessageBodyWriterInterceptor getInterceptor() {
            return this.interceptor;
        }

        public void aroundWriteTo(WriterInterceptorContext writerInterceptorContext) throws IOException, WebApplicationException {
            MessageBodyWriterContextFacade facade = new MessageBodyWriterContextFacade(writerInterceptorContext);
            this.interceptor.write(facade);
        }
    }

    private static class MessageBodyWriterContextFacade
    implements MessageBodyWriterContext {
        protected final WriterInterceptorContext writerInterceptorContext;

        private MessageBodyWriterContextFacade(WriterInterceptorContext writerInterceptorContext) {
            this.writerInterceptorContext = writerInterceptorContext;
        }

        @Override
        public Class getType() {
            return this.writerInterceptorContext.getType();
        }

        @Override
        public void setType(Class type) {
            this.writerInterceptorContext.setType(type);
        }

        @Override
        public Type getGenericType() {
            return this.writerInterceptorContext.getGenericType();
        }

        @Override
        public void setGenericType(Type genericType) {
            this.writerInterceptorContext.setGenericType(genericType);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.writerInterceptorContext.getAnnotations();
        }

        @Override
        public void setAnnotations(Annotation[] annotations) {
            this.writerInterceptorContext.setAnnotations(annotations);
        }

        @Override
        public MediaType getMediaType() {
            return this.writerInterceptorContext.getMediaType();
        }

        @Override
        public void setMediaType(MediaType mediaType) {
            this.writerInterceptorContext.setMediaType(mediaType);
        }

        @Override
        public MultivaluedMap<String, Object> getHeaders() {
            return this.writerInterceptorContext.getHeaders();
        }

        @Override
        public Object getAttribute(String attribute) {
            return this.writerInterceptorContext.getProperty(attribute);
        }

        @Override
        public void setAttribute(String name, Object value) {
            this.writerInterceptorContext.setProperty(name, value);
        }

        @Override
        public void removeAttribute(String name) {
            this.writerInterceptorContext.removeProperty(name);
        }

        @Override
        public Object getEntity() {
            return this.writerInterceptorContext.getEntity();
        }

        @Override
        public void setEntity(Object entity) {
            this.writerInterceptorContext.setEntity(entity);
        }

        @Override
        public OutputStream getOutputStream() {
            return this.writerInterceptorContext.getOutputStream();
        }

        @Override
        public void setOutputStream(OutputStream os) {
            this.writerInterceptorContext.setOutputStream(os);
        }

        @Override
        public void proceed() throws IOException, WebApplicationException {
            this.writerInterceptorContext.proceed();
        }
    }
}

