/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import jakarta.batch.operations.JobStartException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.AbstractJobElement;
import org.jberet.job.model.InheritableJobElement;
import org.jberet.job.model.Job;
import org.jberet.job.model.Listeners;
import org.jberet.job.model.Properties;
import org.jberet.job.model.PropertiesHolder;
import org.jberet.job.model.RefArtifact;
import org.jberet.spi.JobXmlResolver;

abstract class AbstractMerger<T extends AbstractJobElement> {
    T parent;
    T child;
    Job currentJob;
    ClassLoader classLoader;
    List<Job> loadedJobs;
    final JobXmlResolver jobXmlResolver;
    private List<T> inheritingElements;

    AbstractMerger(Job currentJob, ClassLoader classLoader, List<Job> loadedJobs, JobXmlResolver jobXmlResolver) {
        this.currentJob = currentJob;
        this.classLoader = classLoader;
        this.loadedJobs = loadedJobs;
        this.jobXmlResolver = jobXmlResolver;
    }

    void checkInheritingElements(T element, String elementId) throws JobStartException {
        if (this.inheritingElements != null && this.inheritingElements.contains(element)) {
            StringBuilder sb = new StringBuilder();
            for (AbstractJobElement e : this.inheritingElements) {
                sb.append(e.id).append(" -> ");
            }
            sb.append(elementId);
            throw BatchMessages.MESSAGES.cycleInheritance(sb.toString());
        }
    }

    void recordInheritingElements(AbstractMerger<T> nextMerger) {
        nextMerger.inheritingElements = this.inheritingElements != null ? this.inheritingElements : new ArrayList<T>();
        if (!nextMerger.inheritingElements.contains(this.child)) {
            nextMerger.inheritingElements.add(this.child);
        }
        nextMerger.inheritingElements.add(this.parent);
    }

    static void mergeProperties(PropertiesHolder parent, PropertiesHolder child) {
        if (parent.getProperties() != null) {
            Properties childProps = child.getProperties();
            Properties parentProps = parent.getProperties();
            if (childProps == null) {
                child.setProperties(parentProps.clone());
            } else if (childProps.isMerge()) {
                for (Map.Entry<String, String> e : parentProps.getPropertiesMapping().entrySet()) {
                    childProps.addIfAbsent(e.getKey(), e.getValue());
                }
            }
        }
    }

    static void mergeListeners(InheritableJobElement parent, InheritableJobElement child) {
        if (parent.getListeners() != null && !parent.getListeners().getListeners().isEmpty()) {
            Listeners childListeners = child.getListeners();
            List<RefArtifact> parentListenerList = parent.getListeners().getListeners();
            if (childListeners == null) {
                Listeners newListeners = new Listeners();
                newListeners.getListeners().addAll(parentListenerList);
                child.setListeners(newListeners);
            } else if (childListeners.isMerge()) {
                List<RefArtifact> childListenerList = childListeners.getListeners();
                for (RefArtifact l : parentListenerList) {
                    String pr = l.getRef();
                    boolean existsInChild = false;
                    for (RefArtifact cr : childListenerList) {
                        if (!cr.getRef().equals(pr)) continue;
                        existsInChild = true;
                        break;
                    }
                    if (existsInChild) continue;
                    childListenerList.add(l);
                }
            }
        }
    }
}

