/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.InvocationHelper;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractSegmentedStoreConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.DataConversion;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.TransactionalStoreInterceptor;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.async.AsyncNonBlockingStore;
import org.infinispan.persistence.internal.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.LocalOnlyCacheLoader;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.StoreUnavailableException;
import org.infinispan.persistence.support.ComposedSegmentedLoadWriteStore;
import org.infinispan.persistence.support.DelegatingNonBlockingStore;
import org.infinispan.persistence.support.NonBlockingStoreAdapter;
import org.infinispan.persistence.support.SegmentPublisherWrapper;
import org.infinispan.persistence.support.SingleSegmentPublisher;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class PersistenceManagerImpl
implements PersistenceManager {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    Configuration configuration;
    @Inject
    GlobalConfiguration globalConfiguration;
    @Inject
    ComponentRef<AdvancedCache<Object, Object>> cache;
    @Inject
    KeyPartitioner keyPartitioner;
    @Inject
    TimeService timeService;
    @Inject
    TransactionManager transactionManager;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.persistence")
    PersistenceMarshaller persistenceMarshaller;
    @Inject
    ByteBufferFactory byteBufferFactory;
    @Inject
    CacheNotifier<Object, Object> cacheNotifier;
    @Inject
    InternalEntryFactory internalEntryFactory;
    @Inject
    MarshallableEntryFactory<?, ?> marshallableEntryFactory;
    @Inject
    ComponentRef<CommandsFactory> commandsFactory;
    @ComponentName(value="org.infinispan.executors.non-blocking")
    @Inject
    Executor nonBlockingExecutor;
    @Inject
    BlockingManager blockingManager;
    @Inject
    NonBlockingManager nonBlockingManager;
    @Inject
    ComponentRef<InvocationHelper> invocationHelper;
    @Inject
    ComponentRef<InternalExpirationManager<Object, Object>> expirationManager;
    @Inject
    DistributionManager distributionManager;
    private final StampedLock lock = new StampedLock();
    private volatile boolean enabled;
    private volatile boolean preloaded;
    private volatile boolean clearOnStop;
    private volatile AutoCloseable availabilityTask;
    private volatile String unavailableExceptionMessage;
    private boolean isInvalidationCache;
    private boolean allSegmentedOrShared;
    private int segmentCount;
    @GuardedBy(value="lock")
    private final List<StoreStatus> stores = new ArrayList<StoreStatus>(4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> NonBlockingStore<K, V> getStore(Predicate<StoreStatus> predicate) {
        long stamp = this.lock.tryOptimisticRead();
        NonBlockingStore<K, V> store = this.getStoreLocked(predicate);
        if (!this.lock.validate(stamp)) {
            stamp = this.acquireReadLock();
            try {
                store = this.getStoreLocked(predicate);
            }
            finally {
                this.releaseReadLock(stamp);
            }
        }
        return store;
    }

    @GuardedBy(value="lock#readLock")
    private <K, V> NonBlockingStore<K, V> getStoreLocked(Predicate<StoreStatus> predicate) {
        for (StoreStatus storeStatus : this.stores) {
            if (!predicate.test(storeStatus)) continue;
            return storeStatus.store();
        }
        return null;
    }

    @Start
    public void start() {
        this.enabled = this.configuration.persistence().usingStores();
        if (!this.enabled) {
            return;
        }
        this.preloaded = false;
        this.segmentCount = this.configuration.clustering().hash().numSegments();
        this.isInvalidationCache = this.configuration.clustering().cacheMode().isInvalidation();
        long stamp = this.lock.writeLock();
        try {
            Completable storeStartup = Flowable.fromIterable(this.configuration.persistence().stores()).concatMapSingle(storeConfiguration -> {
                NonBlockingStore<?, ?> actualStore = this.storeFromConfiguration((StoreConfiguration)storeConfiguration);
                NonBlockingStore<?, ?> nonBlockingStore = storeConfiguration.async().enabled() ? new AsyncNonBlockingStore(actualStore) : actualStore;
                InitializationContextImpl ctx = new InitializationContextImpl((StoreConfiguration)storeConfiguration, this.cache.wired(), this.keyPartitioner, this.persistenceMarshaller, this.timeService, this.byteBufferFactory, this.marshallableEntryFactory, this.nonBlockingExecutor, this.globalConfiguration, this.blockingManager);
                CompletionStage<Void> stage = nonBlockingStore.start(ctx).whenComplete((ignore, t) -> {
                    if (t != null) {
                        this.stores.add(new StoreStatus(nonBlockingStore, null, null));
                    }
                });
                return Completable.fromCompletionStage(stage).toSingle(() -> new StoreStatus(nonBlockingStore, (StoreConfiguration)storeConfiguration, this.updateCharacteristics(nonBlockingStore, nonBlockingStore.characteristics(), (StoreConfiguration)storeConfiguration)));
            }).doOnNext(this.stores::add).delay(status -> {
                if (status.config.purgeOnStartup()) {
                    return Flowable.fromCompletable((CompletableSource)Completable.fromCompletionStage(status.store.clear()));
                }
                return Flowable.empty();
            }).ignoreElements();
            long interval = this.configuration.persistence().availabilityInterval();
            if (interval > 0L) {
                storeStartup = storeStartup.doOnComplete(() -> {
                    this.availabilityTask = this.nonBlockingManager.scheduleWithFixedDelay(this::pollStoreAvailability, interval, interval, TimeUnit.MILLISECONDS);
                });
            }
            storeStartup.blockingAwait();
            this.allSegmentedOrShared = this.allStoresSegmentedOrShared();
        }
        catch (Throwable t) {
            log.debug("PersistenceManagerImpl encountered an exception during startup of stores", t);
            throw t;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @GuardedBy(value="lock")
    private boolean allStoresSegmentedOrShared() {
        return this.getStoreLocked(storeStatus -> !storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.SEGMENTABLE) || !storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.SHAREABLE)) != null;
    }

    private Set<NonBlockingStore.Characteristic> updateCharacteristics(NonBlockingStore store, Set<NonBlockingStore.Characteristic> characteristics, StoreConfiguration storeConfiguration) {
        if (storeConfiguration.ignoreModifications()) {
            if (characteristics.contains((Object)NonBlockingStore.Characteristic.WRITE_ONLY)) {
                throw log.storeConfiguredHasBothReadAndWriteOnly(store.getClass().getName(), NonBlockingStore.Characteristic.WRITE_ONLY, NonBlockingStore.Characteristic.READ_ONLY);
            }
            characteristics.add(NonBlockingStore.Characteristic.READ_ONLY);
            characteristics.remove((Object)NonBlockingStore.Characteristic.TRANSACTIONAL);
        }
        if (storeConfiguration.writeOnly()) {
            if (characteristics.contains((Object)NonBlockingStore.Characteristic.READ_ONLY)) {
                throw log.storeConfiguredHasBothReadAndWriteOnly(store.getClass().getName(), NonBlockingStore.Characteristic.READ_ONLY, NonBlockingStore.Characteristic.WRITE_ONLY);
            }
            characteristics.add(NonBlockingStore.Characteristic.WRITE_ONLY);
            characteristics.remove((Object)NonBlockingStore.Characteristic.BULK_READ);
        }
        if (!storeConfiguration.segmented()) {
            characteristics.remove((Object)NonBlockingStore.Characteristic.SEGMENTABLE);
        }
        if (storeConfiguration.transactional()) {
            if (!characteristics.contains((Object)NonBlockingStore.Characteristic.TRANSACTIONAL)) {
                throw log.storeConfiguredTransactionalButCharacteristicNotPresent(store.getClass().getName());
            }
        } else {
            characteristics.remove((Object)NonBlockingStore.Characteristic.TRANSACTIONAL);
        }
        if (storeConfiguration.shared()) {
            if (!characteristics.contains((Object)NonBlockingStore.Characteristic.SHAREABLE)) {
                throw log.storeConfiguredSharedButCharacteristicNotPresent(store.getClass().getName());
            }
        } else {
            characteristics.remove((Object)NonBlockingStore.Characteristic.SHAREABLE);
        }
        return characteristics;
    }

    protected CompletionStage<Void> pollStoreAvailability() {
        if (trace) {
            log.trace("Polling Store availability");
        }
        Maybe allAvailableMaybe = Maybe.defer(() -> {
            if (this.unavailableExceptionMessage != null) {
                this.unavailableExceptionMessage = null;
                return Maybe.fromCompletionStage(this.cacheNotifier.notifyPersistenceAvailabilityChanged(true).thenApply(CompletableFutures.toNullFunction()));
            }
            return Maybe.empty();
        });
        return Completable.using(this::acquireReadLock, ignore -> Flowable.fromIterable(this.stores).flatMapMaybe(storeStatus -> {
            CompletionStage<Boolean> availableStage = storeStatus.store.isAvailable();
            return Maybe.fromCompletionStage(availableStage.thenApply(isAvailable -> {
                storeStatus.availability = isAvailable;
                if (!isAvailable.booleanValue()) {
                    return storeStatus.store();
                }
                return null;
            }));
        }).firstElement().switchIfEmpty((MaybeSource)allAvailableMaybe).concatMapCompletable(unavailableStore -> {
            if (this.unavailableExceptionMessage == null) {
                log.debugf("Store %s is unavailable!", unavailableStore);
                this.unavailableExceptionMessage = "Store " + unavailableStore + " is unavailable";
                return Completable.fromCompletionStage(this.cacheNotifier.notifyPersistenceAvailabilityChanged(false));
            }
            return Completable.complete();
        }), this::releaseReadLock).toCompletionStage(null);
    }

    private NonBlockingStore<?, ?> storeFromConfiguration(StoreConfiguration cfg) {
        Object bareInstance = cfg.segmented() && cfg instanceof AbstractSegmentedStoreConfiguration ? new ComposedSegmentedLoadWriteStore((AbstractSegmentedStoreConfiguration)cfg) : PersistenceUtil.createStoreInstance(cfg);
        if (!(bareInstance instanceof NonBlockingStore)) {
            return new NonBlockingStoreAdapter((Lifecycle)bareInstance);
        }
        return (NonBlockingStore)bareInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Stop
    public void stop() {
        long stamp = this.lock.writeLock();
        try {
            this.stopAvailabilityTask();
            Flowable flowable = Flowable.fromIterable(this.stores).map(StoreStatus::store);
            if (this.clearOnStop) {
                flowable = flowable.delay(store -> Completable.fromCompletionStage(store.clear()).toFlowable());
            }
            flowable = flowable.delay(store -> Completable.fromCompletionStage(store.stop()).toFlowable());
            this.blockingSubscribe(flowable);
            this.stores.clear();
            this.preloaded = false;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private void stopAvailabilityTask() {
        AutoCloseable taskToClose = this.availabilityTask;
        if (taskToClose != null) {
            try {
                taskToClose.close();
            }
            catch (Exception e) {
                log.warn("There was a problem stopping availability task", e);
            }
        }
    }

    private void blockingSubscribe(Flowable<?> flowable) {
        flowable.blockingSubscribe();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isReadOnly() {
        return this.getStore(storeStatus -> !storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.READ_ONLY)) == null;
    }

    @Override
    public boolean hasWriter() {
        return this.getStore(storeStatus -> !storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.READ_ONLY)) != null;
    }

    @Override
    public boolean isPreloaded() {
        return this.preloaded;
    }

    @Override
    public CompletionStage<Void> preload() {
        long stamp = this.acquireReadLock();
        NonBlockingStore nonBlockingStore = this.getStoreLocked(status -> status.config.preload());
        if (nonBlockingStore == null) {
            this.releaseReadLock(stamp);
            return CompletableFutures.completedNull();
        }
        Publisher publisher = nonBlockingStore.publishEntries(IntSets.immutableRangeSet((int)this.segmentCount), null, true);
        long start = this.timeService.time();
        long maxEntries = this.getMaxEntries();
        long flags = this.getFlagsForStateInsertion();
        AdvancedCache<Object, Object> tmpCache = this.cache.wired().withStorageMediaType();
        DataConversion keyDataConversion = tmpCache.getKeyDataConversion();
        DataConversion valueDataConversion = tmpCache.getValueDataConversion();
        return Flowable.fromPublisher(publisher).doFinally(() -> this.releaseReadLock(stamp)).take(maxEntries).concatMapSingle(me -> this.preloadEntry(flags, (MarshallableEntry<Object, Object>)me, keyDataConversion, valueDataConversion)).count().toCompletionStage().thenAccept(insertAmount -> {
            this.preloaded = insertAmount < maxEntries;
            log.debugf("Preloaded %d keys in %s", insertAmount, Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
        });
    }

    private Single<Object> preloadEntry(long flags, MarshallableEntry<Object, Object> me, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        CompletionStage<Object> stage;
        InternalMetadataImpl metadata = new InternalMetadataImpl(me.getMetadata(), me.created(), me.lastUsed());
        Object key = keyDataConversion.toStorage(me.getKey());
        Object value = valueDataConversion.toStorage(me.getValue());
        PutKeyValueCommand cmd = this.commandsFactory.wired().buildPutKeyValueCommand(key, value, this.keyPartitioner.getSegment(key), metadata, flags);
        cmd.setInternalMetadata(me.getInternalMetadata());
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            CompletionStage putStage;
            Transaction transaction = this.suspendIfNeeded();
            try {
                this.beginIfNeeded();
                putStage = this.invocationHelper.wired().invokeAsync(cmd, 1).thenApply(ignore -> {
                    try {
                        return this.transactionManager.suspend();
                    }
                    catch (SystemException e) {
                        throw new PersistenceException("Unable to preload!", e);
                    }
                });
            }
            catch (Exception e) {
                throw new PersistenceException("Unable to preload!", e);
            }
            stage = this.blockingManager.whenCompleteBlocking(putStage, (pendingTransaction, t) -> {
                try {
                    this.transactionManager.resume(pendingTransaction);
                    this.commitIfNeeded(t == null);
                }
                catch (InvalidTransactionException | SystemException e) {
                    throw new PersistenceException("Unable to preload!", e);
                }
                finally {
                    this.resumeIfNeeded(transaction);
                }
            }, me.getKey());
        } else {
            stage = this.invocationHelper.wired().invokeAsync(cmd, 1);
        }
        return Maybe.fromCompletionStage(stage).defaultIfEmpty(me);
    }

    private void resumeIfNeeded(Transaction transaction) {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null && transaction != null) {
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    private Transaction suspendIfNeeded() {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            try {
                return this.transactionManager.suspend();
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
        return null;
    }

    private void beginIfNeeded() throws SystemException, NotSupportedException {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            this.transactionManager.begin();
        }
    }

    private void commitIfNeeded(boolean success) {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            try {
                if (success) {
                    this.transactionManager.commit();
                } else {
                    this.transactionManager.rollback();
                }
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    private long getMaxEntries() {
        long maxCount;
        if (this.configuration.memory().isEvictionEnabled() && (maxCount = this.configuration.memory().maxCount()) > 0L) {
            return maxCount;
        }
        return Long.MAX_VALUE;
    }

    @GuardedBy(value="lock#readLock")
    private long getFlagsForStateInsertion() {
        boolean hasSharedStore;
        long flags = FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_OWNERSHIP_CHECK | FlagBitSets.IGNORE_RETURN_VALUES | FlagBitSets.SKIP_CACHE_STORE | FlagBitSets.SKIP_LOCKING | FlagBitSets.SKIP_XSITE_BACKUP | FlagBitSets.IRAC_STATE;
        boolean bl = hasSharedStore = this.getStoreLocked(storeStatus -> storeStatus.config.shared()) != null;
        if (!hasSharedStore || !this.configuration.indexing().isVolatile()) {
            flags = EnumUtil.mergeBitSets((long)flags, (long)FlagBitSets.SKIP_INDEXING);
        }
        return flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> disableStore(String storeType) {
        if (!this.enabled) {
            return CompletableFutures.completedNull();
        }
        boolean stillHasAStore = false;
        AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        long stamp = this.lock.writeLock();
        try {
            boolean allAvailable = true;
            Iterator<StoreStatus> statusIterator = this.stores.iterator();
            while (statusIterator.hasNext()) {
                StoreStatus status = statusIterator.next();
                NonBlockingStore nonBlockingStore = this.unwrapStore(status.store());
                if (nonBlockingStore.getClass().getName().equals(storeType) || this.containedInAdapter(nonBlockingStore, storeType)) {
                    statusIterator.remove();
                    aggregateCompletionStage.dependsOn(nonBlockingStore.stop().whenComplete((v, t) -> {
                        if (t != null) {
                            log.warn("There was an error stopping the store", (Throwable)t);
                        }
                    }));
                    continue;
                }
                stillHasAStore = true;
                allAvailable = allAvailable && status.availability;
            }
            if (!stillHasAStore) {
                this.unavailableExceptionMessage = null;
                this.enabled = false;
                this.stopAvailabilityTask();
            } else if (allAvailable) {
                this.unavailableExceptionMessage = null;
            }
            this.allSegmentedOrShared = this.allStoresSegmentedOrShared();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
        if (!stillHasAStore) {
            AsyncInterceptorChain chain = this.cache.wired().getAsyncInterceptorChain();
            CacheLoaderInterceptor loaderInterceptor = chain.findInterceptorExtending(CacheLoaderInterceptor.class);
            if (loaderInterceptor == null) {
                Log.PERSISTENCE.persistenceWithoutCacheLoaderInterceptor();
            } else {
                chain.removeInterceptor(loaderInterceptor.getClass());
            }
            DDAsyncInterceptor writerInterceptor = chain.findInterceptorExtending(CacheWriterInterceptor.class);
            if (writerInterceptor == null) {
                writerInterceptor = chain.findInterceptorWithClass(TransactionalStoreInterceptor.class);
                if (writerInterceptor == null) {
                    Log.PERSISTENCE.persistenceWithoutCacheWriteInterceptor();
                } else {
                    chain.removeInterceptor(writerInterceptor.getClass());
                }
            } else {
                chain.removeInterceptor(writerInterceptor.getClass());
            }
        }
        return aggregateCompletionStage.freeze();
    }

    private <K, V> NonBlockingStore<K, V> unwrapStore(NonBlockingStore<K, V> store) {
        if (store instanceof DelegatingNonBlockingStore) {
            return ((DelegatingNonBlockingStore)store).delegate();
        }
        return store;
    }

    private Object unwrapOldSPI(NonBlockingStore<?, ?> store) {
        if (store instanceof NonBlockingStoreAdapter) {
            return ((NonBlockingStoreAdapter)store).getActualStore();
        }
        return store;
    }

    private boolean containedInAdapter(NonBlockingStore nonBlockingStore, String adaptedClassName) {
        return nonBlockingStore instanceof NonBlockingStoreAdapter && ((NonBlockingStoreAdapter)nonBlockingStore).getActualStore().getClass().getName().equals(adaptedClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Set<T> getStores(Class<T> storeClass) {
        long stamp = this.acquireReadLock();
        try {
            Set set = this.stores.stream().map(StoreStatus::store).map(this::unwrapStore).map(this::unwrapOldSPI).filter(storeClass::isInstance).map(storeClass::cast).collect(Collectors.toCollection(HashSet::new));
            return set;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getStoresAsString() {
        long stamp = this.acquireReadLock();
        try {
            Collection collection = this.stores.stream().map(storeStatus -> storeStatus.store.getClass().getName()).collect(Collectors.toCollection(ArrayList::new));
            return collection;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    @Override
    public CompletionStage<Void> purgeExpired() {
        long stamp = this.acquireReadLock();
        try {
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Purging entries from stores", new Object[0]);
            }
            AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            for (StoreStatus storeStatus : this.stores) {
                if (!storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.EXPIRATION)) continue;
                Flowable flowable = Flowable.fromPublisher(storeStatus.store().purgeExpired());
                Completable completable = flowable.concatMapCompletable(me -> Completable.fromCompletionStage(this.expirationManager.running().handleInStoreExpirationInternal((MarshallableEntry<Object, Object>)me)));
                aggregateCompletionStage.dependsOn(completable.toCompletionStage(null));
            }
            return aggregateCompletionStage.freeze().whenComplete((v, t) -> this.releaseReadLock(stamp));
        }
        catch (Throwable t2) {
            this.releaseReadLock(stamp);
            throw t2;
        }
    }

    @Override
    public CompletionStage<Void> clearAllStores(Predicate<? super StoreConfiguration> predicate) {
        return Completable.using(this::acquireReadLock, ignore -> {
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Clearing all stores", new Object[0]);
            }
            return Flowable.fromIterable(this.stores).filter(storeStatus -> !storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.READ_ONLY) && predicate.test(storeStatus.config)).flatMapCompletable(storeStatus -> Completable.fromCompletionStage(storeStatus.store.clear()));
        }, this::releaseReadLock).toCompletionStage(null);
    }

    @Override
    public CompletionStage<Boolean> deleteFromAllStores(Object key, int segment, Predicate<? super StoreConfiguration> predicate) {
        return Single.using(this::acquireReadLock, ignore -> {
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Deleting entry for key %s from stores", key);
            }
            return Flowable.fromIterable(this.stores).filter(storeStatus -> !storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.READ_ONLY) && predicate.test(storeStatus.config)).flatMapSingle(storeStatus -> Single.fromCompletionStage(storeStatus.store.delete(segment, key))).reduce((Object)Boolean.FALSE, (removed1, removed2) -> removed1 != false || removed2 != false);
        }, this::releaseReadLock).toCompletionStage();
    }

    @Override
    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(boolean fetchValue, boolean fetchMetadata) {
        return this.publishEntries(k -> true, fetchValue, fetchMetadata, k -> true);
    }

    @Override
    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, Predicate<? super StoreConfiguration> predicate) {
        return this.publishEntries(IntSets.immutableRangeSet((int)this.segmentCount), filter, fetchValue, fetchMetadata, predicate);
    }

    @Override
    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, Predicate<? super StoreConfiguration> predicate) {
        return Flowable.using(this::acquireReadLock, ignore -> {
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Publishing entries for segments %s", segments);
            }
            for (StoreStatus storeStatus : this.stores) {
                Set<NonBlockingStore.Characteristic> characteristics = storeStatus.characteristics;
                if (!characteristics.contains((Object)NonBlockingStore.Characteristic.BULK_READ) || !predicate.test(storeStatus.config)) continue;
                Predicate filterToUse = !characteristics.contains((Object)NonBlockingStore.Characteristic.SEGMENTABLE) ? PersistenceUtil.combinePredicate(segments, this.keyPartitioner, filter) : filter;
                return storeStatus.store().publishEntries(segments, filterToUse, fetchValue);
            }
            return Flowable.empty();
        }, this::releaseReadLock);
    }

    @Override
    public <K> Publisher<K> publishKeys(Predicate<? super K> filter, Predicate<? super StoreConfiguration> predicate) {
        return this.publishKeys(IntSets.immutableRangeSet((int)this.segmentCount), filter, predicate);
    }

    @Override
    public <K> Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter, Predicate<? super StoreConfiguration> predicate) {
        return Flowable.using(this::acquireReadLock, ignore -> {
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Publishing keys for segments %s", segments);
            }
            for (StoreStatus storeStatus : this.stores) {
                Set<NonBlockingStore.Characteristic> characteristics = storeStatus.characteristics;
                if (!characteristics.contains((Object)NonBlockingStore.Characteristic.BULK_READ) || !predicate.test(storeStatus.config)) continue;
                Predicate filterToUse = !characteristics.contains((Object)NonBlockingStore.Characteristic.SEGMENTABLE) ? PersistenceUtil.combinePredicate(segments, this.keyPartitioner, filter) : filter;
                return storeStatus.store().publishKeys(segments, filterToUse);
            }
            return Flowable.empty();
        }, this::releaseReadLock);
    }

    @Override
    public <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromAllStores(Object key, boolean localInvocation, boolean includeStores) {
        return this.loadFromAllStores(key, this.keyPartitioner.getSegment(key), localInvocation, includeStores);
    }

    @Override
    public <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromAllStores(Object key, int segment, boolean localInvocation, boolean includeStores) {
        return Maybe.using(this::acquireReadLock, ignore -> {
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Loading entry for key %s with segment %d", key, segment);
            }
            return Flowable.fromIterable(this.stores).filter(storeStatus -> this.allowLoad((StoreStatus)storeStatus, localInvocation, includeStores)).concatMapMaybe(storeStatus -> Maybe.fromCompletionStage(storeStatus.store().load(this.segmentOrZero((StoreStatus)storeStatus, segment), key)), 1).firstElement();
        }, this::releaseReadLock).toCompletionStage(null);
    }

    private boolean allowLoad(StoreStatus storeStatus, boolean localInvocation, boolean includeStores) {
        return !(storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.WRITE_ONLY) || !localInvocation && this.isLocalOnlyLoader(storeStatus.store) || !includeStores && !storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.READ_ONLY) && !storeStatus.config.ignoreModifications());
    }

    private boolean isLocalOnlyLoader(NonBlockingStore store) {
        if (store instanceof LocalOnlyCacheLoader) {
            return true;
        }
        NonBlockingStore unwrappedStore = store instanceof DelegatingNonBlockingStore ? ((DelegatingNonBlockingStore)store).delegate() : store;
        if (unwrappedStore instanceof LocalOnlyCacheLoader) {
            return true;
        }
        if (unwrappedStore instanceof NonBlockingStoreAdapter) {
            return ((NonBlockingStoreAdapter)unwrappedStore).getActualStore() instanceof LocalOnlyCacheLoader;
        }
        return false;
    }

    @Override
    public CompletionStage<Long> size(Predicate<? super StoreConfiguration> predicate) {
        long stamp = this.acquireReadLock();
        try {
            NonBlockingStore nonBlockingStore;
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Obtaining size from stores", new Object[0]);
            }
            if ((nonBlockingStore = this.getStoreLocked(storeStatus -> storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.BULK_READ) && predicate.test(storeStatus.config))) == null) {
                this.releaseReadLock(stamp);
                return CompletableFuture.completedFuture(-1L);
            }
            return nonBlockingStore.size(IntSets.immutableRangeSet((int)this.segmentCount)).whenComplete((ignore, ignoreT) -> this.releaseReadLock(stamp));
        }
        catch (Throwable t) {
            this.releaseReadLock(stamp);
            throw t;
        }
    }

    @Override
    public CompletionStage<Long> size(IntSet segments) {
        long stamp = this.acquireReadLock();
        try {
            NonBlockingStore nonBlockingStore;
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Obtaining size from stores for segments %s", segments);
            }
            if ((nonBlockingStore = this.getStoreLocked(storeStatus -> storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.BULK_READ))) == null) {
                this.releaseReadLock(stamp);
                return CompletableFuture.completedFuture(-1L);
            }
            return nonBlockingStore.size(segments).whenComplete((ignore, ignoreT) -> this.releaseReadLock(stamp));
        }
        catch (Throwable t) {
            this.releaseReadLock(stamp);
            throw t;
        }
    }

    @Override
    public void setClearOnStop(boolean clearOnStop) {
        this.clearOnStop = clearOnStop;
    }

    @Override
    public CompletionStage<Void> writeToAllNonTxStores(MarshallableEntry marshalledEntry, int segment, Predicate<? super StoreConfiguration> predicate, long flags) {
        return Completable.using(this::acquireReadLock, ignore -> {
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Writing entry %s for with segment: %d", marshalledEntry, segment);
            }
            return Flowable.fromIterable(this.stores).filter(storeStatus -> this.shouldWrite((StoreStatus)storeStatus, predicate, flags)).flatMapCompletable(storeStatus -> Completable.fromCompletionStage(storeStatus.store.write(this.segmentOrZero((StoreStatus)storeStatus, segment), marshalledEntry)));
        }, this::releaseReadLock).toCompletionStage(null);
    }

    private int segmentOrZero(StoreStatus storeStatus, int segment) {
        return storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.SEGMENTABLE) ? segment : 0;
    }

    private boolean shouldWrite(StoreStatus storeStatus, Predicate<? super StoreConfiguration> userPredicate) {
        return !storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.READ_ONLY) && userPredicate.test(storeStatus.config);
    }

    private boolean shouldWrite(StoreStatus storeStatus, Predicate<? super StoreConfiguration> userPredicate, long flags) {
        return this.shouldWrite(storeStatus, userPredicate) && !storeStatus.store.ignoreCommandWithFlags(flags);
    }

    @Override
    public CompletionStage<Void> prepareAllTxStores(TxInvocationContext<AbstractCacheTransaction> txInvocationContext, Predicate<? super StoreConfiguration> predicate) throws PersistenceException {
        Flowable mvccEntryFlowable = this.toMvccEntryFlowable(txInvocationContext, null);
        return this.batchOperation(mvccEntryFlowable, txInvocationContext, (stores, segmentCount, removeFlowable, putFlowable) -> stores.prepareWithModifications(txInvocationContext.getTransaction(), segmentCount, (Publisher<NonBlockingStore.SegmentedPublisher<Object>>)removeFlowable, putFlowable)).thenApply(CompletableFutures.toNullFunction());
    }

    @Override
    public CompletionStage<Void> commitAllTxStores(TxInvocationContext<AbstractCacheTransaction> txInvocationContext, Predicate<? super StoreConfiguration> predicate) {
        return Completable.using(this::acquireReadLock, ignore -> {
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Committing transaction %s to stores", txInvocationContext);
            }
            return Flowable.fromIterable(this.stores).filter(storeStatus -> this.shouldPerformTransactionOperation((StoreStatus)storeStatus, predicate)).flatMapCompletable(storeStatus -> Completable.fromCompletionStage(storeStatus.store.commit(txInvocationContext.getTransaction())));
        }, this::releaseReadLock).toCompletionStage(null);
    }

    @Override
    public CompletionStage<Void> rollbackAllTxStores(TxInvocationContext<AbstractCacheTransaction> txInvocationContext, Predicate<? super StoreConfiguration> predicate) {
        return Completable.using(this::acquireReadLock, ignore -> {
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Rolling back transaction %s for stores", txInvocationContext);
            }
            return Flowable.fromIterable(this.stores).filter(storeStatus -> this.shouldPerformTransactionOperation((StoreStatus)storeStatus, predicate)).flatMapCompletable(storeStatus -> Completable.fromCompletionStage(storeStatus.store.rollback(txInvocationContext.getTransaction())));
        }, this::releaseReadLock).toCompletionStage(null);
    }

    private boolean shouldPerformTransactionOperation(StoreStatus storeStatus, Predicate<? super StoreConfiguration> predicate) {
        return storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.TRANSACTIONAL) && predicate.test(storeStatus.config);
    }

    @Override
    public <K, V> CompletionStage<Void> writeEntries(Iterable<MarshallableEntry<K, V>> iterable, Predicate<? super StoreConfiguration> predicate) {
        return Completable.using(this::acquireReadLock, ignore -> {
            this.checkStoreAvailability();
            if (trace) {
                log.trace("Writing entries to stores");
            }
            return Flowable.fromIterable(this.stores).filter(storeStatus -> this.shouldWrite((StoreStatus)storeStatus, predicate) && !storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.TRANSACTIONAL)).flatMapCompletable(storeStatus -> {
                boolean segmented = storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.SEGMENTABLE);
                Flowable flowable = segmented ? Flowable.fromIterable((Iterable)iterable).groupBy(this.groupingFunction(MarshallableEntry::getKey)).map(SegmentPublisherWrapper::wrap) : Flowable.just(SingleSegmentPublisher.singleSegment(Flowable.fromIterable((Iterable)iterable)));
                return Completable.fromCompletionStage(storeStatus.store().batch(this.segmentCount(segmented), (Publisher<NonBlockingStore.SegmentedPublisher<Object>>)Flowable.empty(), flowable));
            });
        }, this::releaseReadLock).toCompletionStage(null);
    }

    @Override
    public CompletionStage<Long> writeMapCommand(PutMapCommand putMapCommand, InvocationContext ctx, BiPredicate<? super PutMapCommand, Object> commandKeyPredicate) {
        Flowable mvccEntryFlowable = this.entriesFromCommand(putMapCommand, ctx, commandKeyPredicate);
        return this.batchOperation(mvccEntryFlowable, ctx, NonBlockingStore::batch);
    }

    @Override
    public CompletionStage<Long> performBatch(TxInvocationContext<AbstractCacheTransaction> ctx, BiPredicate<? super WriteCommand, Object> commandKeyPredicate) {
        Flowable mvccEntryFlowable = this.toMvccEntryFlowable(ctx, commandKeyPredicate);
        return this.batchOperation(mvccEntryFlowable, ctx, NonBlockingStore::batch);
    }

    private <K, V> CompletionStage<Long> batchOperation(Flowable<MVCCEntry<K, V>> mvccEntryFlowable, InvocationContext ctx, HandleFlowables<K, V> flowableHandler) {
        return Single.using(this::acquireReadLock, ignore -> {
            this.checkStoreAvailability();
            if (trace) {
                log.trace("Writing batch to stores");
            }
            return Flowable.fromIterable(this.stores).filter(storeStatus -> !storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.READ_ONLY)).flatMapSingle(storeStatus -> {
                Flowable flowableToUse;
                boolean shared = storeStatus.config.shared();
                if (shared) {
                    if (trace) {
                        log.tracef("Store %s is shared, checking skip shared stores and ignoring entries not primarily owned by this node", storeStatus.store);
                    }
                    flowableToUse = mvccEntryFlowable.filter(mvccEntry -> !mvccEntry.isSkipSharedStore());
                } else {
                    flowableToUse = mvccEntryFlowable;
                }
                boolean segmented = storeStatus.config.segmented();
                flowableToUse = flowableToUse.publish().autoConnect(2);
                Flowable<NonBlockingStore.SegmentedPublisher<Object>> removeFlowable = this.createRemoveFlowable((Flowable)flowableToUse, shared, segmented, (StoreStatus)storeStatus);
                ByRef.Long writeCount = new ByRef.Long(0);
                Flowable writeFlowable = this.createWriteFlowable((Flowable)flowableToUse, ctx, shared, segmented, writeCount, (StoreStatus)storeStatus);
                CompletionStage<Void> storeBatchStage = flowableHandler.handleFlowables(storeStatus.store(), this.segmentCount(segmented), removeFlowable, writeFlowable);
                return Single.fromCompletionStage(storeBatchStage.thenApply(ignore2 -> writeCount.get()));
            }).last((Object)0L);
        }, this::releaseReadLock).toCompletionStage();
    }

    private <K, V> Flowable<NonBlockingStore.SegmentedPublisher<Object>> createRemoveFlowable(Flowable<MVCCEntry<K, V>> flowableToUse, boolean shared, boolean segmented, StoreStatus storeStatus) {
        Flowable flowable;
        Flowable keyRemoveFlowable = flowableToUse.filter(CacheEntry::isRemoved).map(CacheEntry::getKey);
        if (segmented) {
            flowable = keyRemoveFlowable.groupBy(this.keyPartitioner::getSegment).map(SegmentPublisherWrapper::wrap);
            flowable = this.filterSharedSegments(flowable, null, shared);
        } else {
            if (shared && !this.isInvalidationCache) {
                keyRemoveFlowable = keyRemoveFlowable.filter(k -> this.distributionManager.getCacheTopology().getDistribution(k).isPrimary());
            }
            flowable = Flowable.just(SingleSegmentPublisher.singleSegment(keyRemoveFlowable));
        }
        if (trace) {
            flowable = flowable.doOnSubscribe(sub -> log.tracef("Store %s has subscribed to remove batch", storeStatus.store));
            flowable = flowable.map(sp -> {
                int segment = sp.getSegment();
                return SingleSegmentPublisher.singleSegment(segment, Flowable.fromPublisher((Publisher)sp).doOnNext(keyToRemove -> log.tracef("Emitting key %s for removal from segment %s", keyToRemove, segment)));
            });
        }
        return flowable;
    }

    private <K, V> Flowable<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> createWriteFlowable(Flowable<MVCCEntry<K, V>> flowableToUse, InvocationContext ctx, boolean shared, boolean segmented, ByRef.Long writeCount, StoreStatus storeStatus) {
        Flowable flowable;
        Flowable entryWriteFlowable = flowableToUse.filter(mvccEntry -> !mvccEntry.isRemoved()).map(mvcEntry -> {
            Object key = mvcEntry.getKey();
            InternalCacheValue sv = this.internalEntryFactory.getValueFromCtx(key, ctx);
            return this.marshallableEntryFactory.create(key, sv);
        });
        if (segmented) {
            entryWriteFlowable = entryWriteFlowable.doOnNext(obj -> writeCount.inc());
            flowable = entryWriteFlowable.groupBy(me -> this.keyPartitioner.getSegment(me.getKey())).map(SegmentPublisherWrapper::wrap);
            flowable = this.filterSharedSegments(flowable, writeCount, shared);
        } else {
            if (shared && !this.isInvalidationCache) {
                entryWriteFlowable = entryWriteFlowable.filter(me -> this.distributionManager.getCacheTopology().getDistribution(me.getKey()).isPrimary());
            }
            entryWriteFlowable = entryWriteFlowable.doOnNext(obj -> writeCount.inc());
            flowable = Flowable.just(SingleSegmentPublisher.singleSegment(entryWriteFlowable));
        }
        if (trace) {
            flowable = flowable.doOnSubscribe(sub -> log.tracef("Store %s has subscribed to write batch", storeStatus.store));
            flowable = flowable.map(sp -> {
                int segment = sp.getSegment();
                return SingleSegmentPublisher.singleSegment(segment, Flowable.fromPublisher((Publisher)sp).doOnNext(me -> log.tracef("Emitting entry %s for write to segment %s", me, segment)));
            });
        }
        return flowable;
    }

    private <I> Flowable<NonBlockingStore.SegmentedPublisher<I>> filterSharedSegments(Flowable<NonBlockingStore.SegmentedPublisher<I>> flowable, ByRef.Long writeCount, boolean shared) {
        if (!shared || this.isInvalidationCache) {
            return flowable;
        }
        return flowable.map(sp -> {
            if (this.distributionManager.getCacheTopology().getSegmentDistribution(sp.getSegment()).isPrimary()) {
                return sp;
            }
            Flowable emptyFlowable = Flowable.fromPublisher((Publisher)sp);
            emptyFlowable = writeCount != null ? emptyFlowable.doOnNext(ignore -> writeCount.dec()).ignoreElements().toFlowable() : emptyFlowable.take(0L);
            return SingleSegmentPublisher.singleSegment(sp.getSegment(), emptyFlowable);
        });
    }

    private <K, V> Flowable<MVCCEntry<K, V>> toMvccEntryFlowable(TxInvocationContext<AbstractCacheTransaction> ctx, BiPredicate<? super WriteCommand, Object> commandKeyPredicate) {
        return Flowable.fromIterable(ctx.getCacheTransaction().getAllModifications()).filter(writeCommand -> !writeCommand.hasAnyFlag(FlagBitSets.SKIP_CACHE_STORE)).concatMap(writeCommand -> this.entriesFromCommand((WriteCommand)writeCommand, ctx, (BiPredicate)commandKeyPredicate));
    }

    private <K, V, WCT extends WriteCommand> Flowable<MVCCEntry<K, V>> entriesFromCommand(WCT writeCommand, InvocationContext ctx, BiPredicate<? super WCT, Object> commandKeyPredicate) {
        if (writeCommand instanceof DataWriteCommand) {
            Object key2 = ((DataWriteCommand)writeCommand).getKey();
            MVCCEntry<K, V> entry = this.acquireKeyFromContext(ctx, writeCommand, key2, commandKeyPredicate);
            return entry != null ? Flowable.just(entry) : Flowable.empty();
        }
        if (writeCommand instanceof InvalidateCommand) {
            return Flowable.empty();
        }
        return Flowable.fromIterable(writeCommand.getAffectedKeys()).concatMapMaybe(key -> {
            MVCCEntry entry = this.acquireKeyFromContext(ctx, writeCommand, key, commandKeyPredicate);
            return entry != null ? Maybe.just(entry) : Maybe.empty();
        });
    }

    private <K, V, WCT extends WriteCommand> MVCCEntry<K, V> acquireKeyFromContext(InvocationContext ctx, WCT command, Object key, BiPredicate<? super WCT, Object> commandKeyPredicate) {
        MVCCEntry entry;
        if ((commandKeyPredicate == null || commandKeyPredicate.test(command, key)) && (entry = (MVCCEntry)ctx.lookupEntry(key)).isChanged()) {
            return entry;
        }
        return null;
    }

    private <E> Function<E, Integer> groupingFunction(Function<E, Object> toKeyFunction) {
        return value -> this.keyPartitioner.getSegment(toKeyFunction.apply(value));
    }

    private int segmentCount(boolean segmented) {
        return segmented ? this.segmentCount : 1;
    }

    @Override
    public boolean isAvailable() {
        return this.unavailableExceptionMessage == null;
    }

    @Override
    public CompletionStage<Boolean> addSegments(IntSet segments) {
        return Completable.using(this::acquireReadLock, ignore -> {
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Adding segments %s to stores", segments);
            }
            return Flowable.fromIterable(this.stores).filter(PersistenceManagerImpl::shouldInvokeSegmentMethods).flatMapCompletable(storeStatus -> Completable.fromCompletionStage(storeStatus.store.addSegments(segments)));
        }, this::releaseReadLock).toCompletionStage((Object)this.allSegmentedOrShared);
    }

    @Override
    public CompletionStage<Boolean> removeSegments(IntSet segments) {
        return Completable.using(this::acquireReadLock, ignore -> {
            this.checkStoreAvailability();
            if (trace) {
                log.tracef("Removing segments %s from stores", segments);
            }
            return Flowable.fromIterable(this.stores).filter(PersistenceManagerImpl::shouldInvokeSegmentMethods).flatMapCompletable(storeStatus -> Completable.fromCompletionStage(storeStatus.store.removeSegments(segments)));
        }, this::releaseReadLock).toCompletionStage((Object)this.allSegmentedOrShared);
    }

    private static boolean shouldInvokeSegmentMethods(StoreStatus storeStatus) {
        return storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.SEGMENTABLE) && !storeStatus.characteristics.contains((Object)NonBlockingStore.Characteristic.SHAREABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> List<NonBlockingStore<K, V>> getAllStores(Predicate<Set<NonBlockingStore.Characteristic>> predicate) {
        long stamp = this.acquireReadLock();
        try {
            List list = this.stores.stream().filter(storeStatus -> predicate.test(storeStatus.characteristics)).map(StoreStatus::store).collect(Collectors.toCollection(ArrayList::new));
            return list;
        }
        finally {
            this.releaseReadLock(stamp);
        }
    }

    private long acquireReadLock() {
        return this.lock.readLock();
    }

    private void releaseReadLock(long stamp) {
        this.lock.unlockRead(stamp);
    }

    private void checkStoreAvailability() {
        if (!this.enabled) {
            return;
        }
        String message = this.unavailableExceptionMessage;
        if (message != null) {
            throw new StoreUnavailableException(message);
        }
    }

    boolean anyLocksHeld() {
        return this.lock.isReadLocked() || this.lock.isWriteLocked();
    }

    static class StoreStatus {
        final NonBlockingStore<?, ?> store;
        final StoreConfiguration config;
        final Set<NonBlockingStore.Characteristic> characteristics;
        boolean availability = true;

        StoreStatus(NonBlockingStore<?, ?> store, StoreConfiguration config, Set<NonBlockingStore.Characteristic> characteristics) {
            this.store = store;
            this.config = config;
            this.characteristics = characteristics;
        }

        <K, V> NonBlockingStore<K, V> store() {
            return this.store;
        }
    }

    static interface HandleFlowables<K, V> {
        public CompletionStage<Void> handleFlowables(NonBlockingStore<K, V> var1, int var2, Flowable<NonBlockingStore.SegmentedPublisher<Object>> var3, Flowable<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> var4);
    }
}

