/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.elementdesc.adapter.cdi.CDIBeanInfoAdapter;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import io.smallrye.metrics.interceptors.MetricResolver;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.jboss.logging.Logger;

@ConcurrentGauge
@Interceptor
@Priority(value=1010)
public class ConcurrentGaugeInterceptor {
    private static final Logger log = Logger.getLogger(ConcurrentGaugeInterceptor.class);
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    ConcurrentGaugeInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = new MetricResolver();
    }

    @AroundConstruct
    Object countedConstructor(InvocationContext context) throws Exception {
        return this.concurrentCallable(context, context.getConstructor());
    }

    @AroundInvoke
    Object countedMethod(InvocationContext context) throws Exception {
        return this.concurrentCallable(context, context.getMethod());
    }

    @AroundTimeout
    Object countedTimeout(InvocationContext context) throws Exception {
        return this.concurrentCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Member & AnnotatedElement> Object concurrentCallable(InvocationContext context, E element) throws Exception {
        CDIBeanInfoAdapter beanInfoAdapter = new CDIBeanInfoAdapter();
        CDIMemberInfoAdapter<E> memberInfoAdapter = new CDIMemberInfoAdapter<E>();
        MetricResolver.Of<ConcurrentGauge> concurrentGaugeResolver = this.resolver.concurrentGauge(this.bean != null ? beanInfoAdapter.convert(this.bean.getBeanClass()) : beanInfoAdapter.convert(element.getDeclaringClass()), memberInfoAdapter.convert(element));
        String name = concurrentGaugeResolver.metricName();
        Tag[] tags = concurrentGaugeResolver.tags();
        MetricID metricID = new MetricID(name, tags);
        org.eclipse.microprofile.metrics.ConcurrentGauge concurrentGauge = (org.eclipse.microprofile.metrics.ConcurrentGauge)this.registry.getConcurrentGauges().get(metricID);
        if (concurrentGauge == null) {
            throw new IllegalStateException("No concurrent gauge with metricID [" + metricID + "] found in registry [" + this.registry + "]");
        }
        log.tracef("Increment concurrent gauge [metricId: %s]", (Object)metricID);
        concurrentGauge.inc();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            log.tracef("Decrement concurrent gauge [metricID: %s]", (Object)metricID);
            concurrentGauge.dec();
        }
    }
}

