/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.fallback;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.fallback.FallbackContext;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.util.CompletionStages;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class CompletionStageFallback<V>
extends Fallback<CompletionStage<V>> {
    public CompletionStageFallback(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, FallbackFunction<CompletionStage<V>> fallback, SetOfThrowables applyOn, SetOfThrowables skipOn, Fallback.MetricsRecorder metricsRecorder) {
        super(delegate, description, fallback, applyOn, skipOn, metricsRecorder);
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        CompletionStage<Object> originalResult;
        CompletableFuture result = new CompletableFuture();
        try {
            originalResult = this.delegate.apply(ctx);
        }
        catch (Exception e) {
            originalResult = CompletionStages.failedStage(e);
        }
        originalResult.whenComplete((value, exception) -> {
            if (value != null) {
                result.complete(value);
                return;
            }
            if (exception instanceof InterruptedException || Thread.interrupted()) {
                result.completeExceptionally(new InterruptedException());
                return;
            }
            if (this.shouldSkipFallback((Throwable)exception)) {
                result.completeExceptionally((Throwable)exception);
                return;
            }
            try {
                this.metricsRecorder.fallbackCalled();
                FallbackContext fallbackContext = new FallbackContext((Throwable)exception, ctx);
                CompletionStages.propagateCompletion((CompletionStage)this.fallback.call(fallbackContext), result);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }
}

