/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timeout.TimeoutExecution;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatch;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import io.smallrye.faulttolerance.core.util.CompletionStages;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class CompletionStageTimeout<V>
extends Timeout<CompletionStage<V>> {
    private final ExecutorService originalExecutor;
    private final boolean interruptCurrentThread;

    public CompletionStageTimeout(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, long timeoutInMillis, TimeoutWatcher watcher, ExecutorService originalExecutor, Timeout.MetricsRecorder metricsRecorder) {
        super(delegate, description, timeoutInMillis, watcher, metricsRecorder);
        this.originalExecutor = Preconditions.checkNotNull(originalExecutor, "original executor must be set");
        this.interruptCurrentThread = false;
    }

    CompletionStageTimeout(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, long timeoutInMillis, TimeoutWatcher watcher, ExecutorService originalExecutor, Timeout.MetricsRecorder metricsRecorder, boolean interruptCurrentThread) {
        super(delegate, description, timeoutInMillis, watcher, metricsRecorder);
        this.originalExecutor = originalExecutor;
        this.interruptCurrentThread = interruptCurrentThread;
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        CompletionStage<Object> originalResult;
        CompletableFuture result = new CompletableFuture();
        long start = System.nanoTime();
        AtomicBoolean completedWithTimeout = new AtomicBoolean(false);
        AtomicReference<CompletionStage<Object>> runningTaskRef = new AtomicReference<CompletionStage<Object>>();
        Thread threadToInterrupt = this.interruptCurrentThread ? Thread.currentThread() : null;
        TimeoutExecution timeoutExecution = new TimeoutExecution(threadToInterrupt, this.timeoutInMillis, () -> {
            if (completedWithTimeout.compareAndSet(false, true)) {
                this.originalExecutor.submit(() -> {
                    long end = System.nanoTime();
                    this.metricsRecorder.timeoutTimedOut(end - start);
                    CompletionStage runningTask = (CompletionStage)runningTaskRef.get();
                    if (runningTask != null) {
                        runningTask.toCompletableFuture().cancel(true);
                    }
                    result.completeExceptionally((Throwable)CompletionStageTimeout.timeoutException(this.description));
                });
            }
        });
        TimeoutWatch watch = this.watcher.schedule(timeoutExecution);
        try {
            originalResult = this.delegate.apply(ctx);
            if (!this.interruptCurrentThread) {
                runningTaskRef.set(originalResult);
            }
        }
        catch (Exception e) {
            originalResult = CompletionStages.failedStage(e);
        }
        originalResult.whenComplete((value, exception) -> {
            timeoutExecution.finish(watch::cancel);
            long end = System.nanoTime();
            if (timeoutExecution.hasTimedOut()) {
                if (completedWithTimeout.compareAndSet(false, true)) {
                    this.metricsRecorder.timeoutTimedOut(end - start);
                    result.completeExceptionally((Throwable)CompletionStageTimeout.timeoutException(this.description));
                }
            } else if (exception != null) {
                this.metricsRecorder.timeoutFailed(end - start);
                result.completeExceptionally((Throwable)exception);
            } else {
                this.metricsRecorder.timeoutSucceeded(end - start);
                result.complete(value);
            }
        });
        return result;
    }
}

