/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.util;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class NamedFutureTask<T>
extends FutureTask<T> {
    protected final String name;

    public NamedFutureTask(String name, Callable<T> callable) {
        super(callable);
        this.name = name;
    }

    @Override
    public void run() {
        String oldName = Thread.currentThread().getName();
        String newName = this.name + "{" + oldName + "}";
        Thread.currentThread().setName(newName);
        try {
            super.run();
        }
        finally {
            Thread.currentThread().setName(oldName);
        }
    }
}

