/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.async;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.SyncInvoker;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.jboss.resteasy.client.jaxrs.internal.CompletionStageRxInvokerImpl;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.microprofile.client.ExceptionMapping;
import org.jboss.resteasy.microprofile.client.async.AsyncInvocationInterceptorHandler;

public class AsyncInterceptorRxInvoker
extends CompletionStageRxInvokerImpl {
    private Method method;

    public AsyncInterceptorRxInvoker(SyncInvoker builder, ExecutorService executor) {
        super(builder, executor);
        this.setupMethod(builder);
    }

    public AsyncInterceptorRxInvoker(SyncInvoker builder) {
        super(builder);
        this.setupMethod(builder);
    }

    private void setupMethod(SyncInvoker builder) {
        this.method = ((ClientInvocationBuilder)builder).getClientInvocation().getClientInvoker().getMethod();
    }

    private static <T> CompletionStage<T> whenComplete(CompletionStage<T> stage, Method method) {
        Collection<AsyncInvocationInterceptor> asyncInvocationInterceptors = AsyncInvocationInterceptorHandler.threadBoundInterceptors.get();
        AsyncInvocationInterceptorHandler.threadBoundInterceptors.remove();
        return stage.handle((ret, t) -> {
            if (t != null) {
                if (t instanceof CompletionException) {
                    t = t.getCause();
                }
                if (t instanceof ExceptionMapping.HandlerException) {
                    try {
                        ((ExceptionMapping.HandlerException)((Object)((Object)t))).mapException(method);
                    }
                    catch (Exception e) {
                        SynchronousDispatcher.rethrow((Throwable)e);
                    }
                }
                SynchronousDispatcher.rethrow((Throwable)t);
            }
            return ret;
        }).whenComplete((o, throwable) -> {
            if (asyncInvocationInterceptors != null) {
                asyncInvocationInterceptors.forEach(AsyncInvocationInterceptor::removeContext);
            }
        });
    }

    public CompletionStage<Response> get() {
        return AsyncInterceptorRxInvoker.whenComplete(super.get(), this.method);
    }

    public <T> CompletionStage<T> get(Class<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.get(responseType), this.method);
    }

    public <T> CompletionStage<T> get(GenericType<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.get(responseType), this.method);
    }

    public CompletionStage<Response> put(Entity<?> entity) {
        return AsyncInterceptorRxInvoker.whenComplete(super.put(entity), this.method);
    }

    public <T> CompletionStage<T> put(Entity<?> entity, Class<T> clazz) {
        return AsyncInterceptorRxInvoker.whenComplete(super.put(entity, clazz), this.method);
    }

    public <T> CompletionStage<T> put(Entity<?> entity, GenericType<T> type) {
        return AsyncInterceptorRxInvoker.whenComplete(super.put(entity, type), this.method);
    }

    public CompletionStage<Response> post(Entity<?> entity) {
        return AsyncInterceptorRxInvoker.whenComplete(super.post(entity), this.method);
    }

    public <T> CompletionStage<T> post(Entity<?> entity, Class<T> clazz) {
        return AsyncInterceptorRxInvoker.whenComplete(super.post(entity, clazz), this.method);
    }

    public <T> CompletionStage<T> post(Entity<?> entity, GenericType<T> type) {
        return AsyncInterceptorRxInvoker.whenComplete(super.post(entity, type), this.method);
    }

    public CompletionStage<Response> delete() {
        return AsyncInterceptorRxInvoker.whenComplete(super.delete(), this.method);
    }

    public <T> CompletionStage<T> delete(Class<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.delete(responseType), this.method);
    }

    public <T> CompletionStage<T> delete(GenericType<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.delete(responseType), this.method);
    }

    public CompletionStage<Response> head() {
        return AsyncInterceptorRxInvoker.whenComplete(super.head(), this.method);
    }

    public CompletionStage<Response> options() {
        return AsyncInterceptorRxInvoker.whenComplete(super.options(), this.method);
    }

    public <T> CompletionStage<T> options(Class<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.options(responseType), this.method);
    }

    public <T> CompletionStage<T> options(GenericType<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.options(responseType), this.method);
    }

    public CompletionStage<Response> trace() {
        return AsyncInterceptorRxInvoker.whenComplete(super.trace(), this.method);
    }

    public <T> CompletionStage<T> trace(Class<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.trace(responseType), this.method);
    }

    public <T> CompletionStage<T> trace(GenericType<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.trace(responseType), this.method);
    }

    public CompletionStage<Response> method(String name) {
        return AsyncInterceptorRxInvoker.whenComplete(super.method(name), this.method);
    }

    public <T> CompletionStage<T> method(String name, Class<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.method(name, responseType), this.method);
    }

    public <T> CompletionStage<T> method(String name, GenericType<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.method(name, responseType), this.method);
    }

    public CompletionStage<Response> method(String name, Entity<?> entity) {
        return AsyncInterceptorRxInvoker.whenComplete(super.method(name, entity), this.method);
    }

    public <T> CompletionStage<T> method(String name, Entity<?> entity, Class<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.method(name, entity, responseType), this.method);
    }

    public <T> CompletionStage<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.method(name, entity, responseType), this.method);
    }

    public CompletionStage<Response> patch(Entity<?> entity) {
        return AsyncInterceptorRxInvoker.whenComplete(super.patch(entity), this.method);
    }

    public <T> CompletionStage<T> patch(Entity<?> entity, Class<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.patch(entity, responseType), this.method);
    }

    public <T> CompletionStage<T> patch(Entity<?> entity, GenericType<T> responseType) {
        return AsyncInterceptorRxInvoker.whenComplete(super.patch(entity, responseType), this.method);
    }
}

