/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.MessageHandler;
import org.hornetq.jms.client.HornetQConnection;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.HornetQSession;
import org.hornetq.jms.client.JMSExceptionHelper;
import org.hornetq.jms.client.JMSMessageListenerWrapper;

public final class HornetQMessageConsumer
implements QueueReceiver,
TopicSubscriber {
    private final ClientConsumer consumer;
    private MessageListener listener;
    private MessageHandler coreListener;
    private final HornetQConnection connection;
    private final HornetQSession session;
    private final int ackMode;
    private final boolean noLocal;
    private final HornetQDestination destination;
    private final String selector;
    private final SimpleString autoDeleteQueueName;

    protected HornetQMessageConsumer(HornetQConnection connection, HornetQSession session, ClientConsumer consumer, boolean noLocal, HornetQDestination destination, String selector, SimpleString autoDeleteQueueName) throws JMSException {
        this.connection = connection;
        this.session = session;
        this.consumer = consumer;
        this.ackMode = session.getAcknowledgeMode();
        this.noLocal = noLocal;
        this.destination = destination;
        this.selector = selector;
        this.autoDeleteQueueName = autoDeleteQueueName;
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.listener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.listener = listener;
        this.coreListener = listener == null ? null : new JMSMessageListenerWrapper(this.connection, this.session, this.consumer, listener, this.ackMode);
        try {
            this.consumer.setMessageHandler(this.coreListener);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public Message receive() throws JMSException {
        return this.getMessage(0L, false);
    }

    public Message receive(long timeout) throws JMSException {
        return this.getMessage(timeout, false);
    }

    public Message receiveNoWait() throws JMSException {
        return this.getMessage(0L, true);
    }

    public void close() throws JMSException {
        try {
            this.consumer.close();
            if (this.autoDeleteQueueName != null) {
                this.session.deleteQueue(this.autoDeleteQueueName);
            }
            this.session.removeConsumer(this);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public Queue getQueue() throws JMSException {
        this.checkClosed();
        return (Queue)this.destination;
    }

    public Topic getTopic() throws JMSException {
        this.checkClosed();
        return (Topic)this.destination;
    }

    public boolean getNoLocal() throws JMSException {
        this.checkClosed();
        return this.noLocal;
    }

    public String toString() {
        return "HornetQMessageConsumer[" + this.consumer + "]";
    }

    public boolean isClosed() {
        return this.consumer.isClosed();
    }

    private void checkClosed() throws JMSException {
        if (this.consumer.isClosed() || this.session.getCoreSession().isClosed()) {
            throw new IllegalStateException("Consumer is closed");
        }
    }

    private HornetQMessage getMessage(long timeout, boolean noWait) throws JMSException {
        try {
            ClientMessage coreMessage = noWait ? this.consumer.receiveImmediate() : this.consumer.receive(timeout);
            HornetQMessage jmsMsg = null;
            if (coreMessage != null) {
                boolean needSession = this.ackMode == 2 || this.ackMode == 101;
                jmsMsg = HornetQMessage.createMessage(coreMessage, needSession ? this.session.getCoreSession() : null);
                jmsMsg.doBeforeReceive();
                if (this.session.getAcknowledgeMode() == 101) {
                    jmsMsg.setIndividualAcknowledge();
                } else {
                    coreMessage.acknowledge();
                }
            }
            return jmsMsg;
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }
}

