/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jws;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.jboss.resteasy.jose.i18n.Messages;
import org.jboss.resteasy.jose.jws.JWSHeader;
import org.jboss.resteasy.jose.jws.JWSInputException;
import org.jboss.resteasy.jose.jws.util.Base64Url;
import org.jboss.resteasy.jose.jws.util.JsonSerialization;

public class JWSInput {
    String wireString;
    String encodedHeader;
    String encodedContent;
    String encodedSignature;
    String encodedSignatureInput;
    JWSHeader header;
    Providers providers;
    byte[] content;
    byte[] signature;

    public JWSInput(String wire) {
        this(wire, null);
    }

    public JWSInput(String wire, Providers providers) {
        try {
            this.providers = providers;
            this.wireString = wire;
            String[] parts = wire.split("\\.");
            if (parts.length < 2 || parts.length > 3) {
                throw new IllegalArgumentException("Parsing error");
            }
            this.encodedHeader = parts[0];
            this.encodedContent = parts[1];
            this.encodedSignatureInput = this.encodedHeader + '.' + this.encodedContent;
            this.content = Base64Url.decode(this.encodedContent);
            if (parts.length > 2) {
                this.encodedSignature = parts[2];
                this.signature = Base64Url.decode(this.encodedSignature);
            }
            byte[] headerBytes = Base64Url.decode(this.encodedHeader);
            this.header = JsonSerialization.readValue(headerBytes, JWSHeader.class);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String getWireString() {
        return this.wireString;
    }

    public String getEncodedHeader() {
        return this.encodedHeader;
    }

    public String getEncodedContent() {
        return this.encodedContent;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public String getEncodedSignatureInput() {
        return this.encodedSignatureInput;
    }

    public JWSHeader getHeader() {
        return this.header;
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public boolean verify(String key) {
        if (this.header.getAlgorithm().getProvider() == null) {
            throw new RuntimeException("signing algorithm not supported");
        }
        return this.header.getAlgorithm().getProvider().verify(this, key);
    }

    public <T> T readJsonContent(Class<T> type) throws JWSInputException {
        try {
            return JsonSerialization.readValue(this.content, type);
        }
        catch (IOException e) {
            throw new JWSInputException(e);
        }
    }

    public String readContentAsString() {
        return new String(this.content, StandardCharsets.UTF_8);
    }

    public <T> T readContent(Class<T> type) {
        MediaType mediaType = MediaType.WILDCARD_TYPE;
        if (this.header.getContentType() != null) {
            mediaType = MediaType.valueOf((String)this.header.getContentType());
        }
        return (T)this.readContent(type, null, null, mediaType);
    }

    public Object readContent(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MessageBodyReader reader = this.providers.getMessageBodyReader(type, genericType, annotations, mediaType);
        if (reader == null) {
            throw new RuntimeException(Messages.MESSAGES.unableToFindReaderForContentType());
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.content);
            return reader.readFrom(type, genericType, annotations, mediaType, (MultivaluedMap)new MultivaluedHashMap(), (InputStream)bais);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

