/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.ConfigExtension;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigInjectionBean<T>
implements Bean<T>,
PassivationCapable {
    private static final Set<Annotation> QUALIFIERS = new HashSet<Annotation>();
    private final BeanManager bm;
    private final Class clazz;
    private Config _config;

    public ConfigInjectionBean(BeanManager bm, Class clazz) {
        this.bm = bm;
        this.clazz = clazz;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Class<?> getBeanClass() {
        return ConfigInjectionBean.class;
    }

    public boolean isNullable() {
        return false;
    }

    public T create(CreationalContext<T> context) {
        InjectionPoint ip = (InjectionPoint)this.bm.getInjectableReference((InjectionPoint)new InjectionPointMetadataInjectionPoint(), context);
        Annotated annotated = ip.getAnnotated();
        ConfigProperty configProperty = (ConfigProperty)annotated.getAnnotation(ConfigProperty.class);
        String key = ConfigExtension.getConfigKey(ip, configProperty);
        String defaultValue = configProperty.defaultValue();
        if (annotated.getBaseType() instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)annotated.getBaseType();
            Type rawType = paramType.getRawType();
            if (rawType instanceof Class && (((Class)rawType).isAssignableFrom(Provider.class) || ((Class)rawType).isAssignableFrom(Instance.class)) && paramType.getActualTypeArguments().length == 1) {
                Class paramTypeClass = (Class)paramType.getActualTypeArguments()[0];
                return (T)this.getConfig().getValue(key, paramTypeClass);
            }
        } else {
            Class annotatedTypeClass = (Class)annotated.getBaseType();
            if (defaultValue == null || defaultValue.length() == 0) {
                return (T)this.getConfig().getValue(key, annotatedTypeClass);
            }
            Config config = this.getConfig();
            Optional optionalValue = config.getOptionalValue(key, annotatedTypeClass);
            if (optionalValue.isPresent()) {
                return optionalValue.get();
            }
            return ((SmallRyeConfig)config).convert(defaultValue, annotatedTypeClass);
        }
        throw new IllegalStateException("unhandled ConfigProperty");
    }

    public Config getConfig() {
        if (this._config == null) {
            this._config = ConfigProvider.getConfig();
        }
        return this._config;
    }

    public void destroy(T instance, CreationalContext<T> context) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.clazz);
    }

    public Set<Annotation> getQualifiers() {
        return QUALIFIERS;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return "ConfigInjectionBean_" + this.clazz;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String getId() {
        return "ConfigInjectionBean_" + this.clazz;
    }

    static {
        QUALIFIERS.add((Annotation)((Object)new ConfigPropertyLiteral()));
    }

    private static class InjectionPointMetadataInjectionPoint
    implements InjectionPoint {
        private InjectionPointMetadataInjectionPoint() {
        }

        public Type getType() {
            return InjectionPoint.class;
        }

        public Set<Annotation> getQualifiers() {
            return Collections.singleton(new AnnotationLiteral<Default>(){});
        }

        public Bean<?> getBean() {
            return null;
        }

        public Member getMember() {
            return null;
        }

        public Annotated getAnnotated() {
            return null;
        }

        public boolean isDelegate() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }
    }

    private static class ConfigPropertyLiteral
    extends AnnotationLiteral<ConfigProperty>
    implements ConfigProperty {
        private ConfigPropertyLiteral() {
        }

        public String name() {
            return "";
        }

        public String defaultValue() {
            return "";
        }
    }
}

