/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.jaxrs;

import io.smallrye.jwt.auth.AbstractBearerTokenExtractor;
import io.smallrye.jwt.auth.cdi.PrincipalProducer;
import io.smallrye.jwt.auth.jaxrs.JWTSecurityContext;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.JWTParser;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.security.Principal;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

@PreMatching
@Priority(value=1000)
public class JWTAuthenticationFilter
implements ContainerRequestFilter {
    private static Logger logger = Logger.getLogger(JWTAuthenticationFilter.class);
    @Inject
    private JWTAuthContextInfo authContextInfo;
    @Inject
    private JWTParser jwtParser;
    @Inject
    private PrincipalProducer producer;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        BearerTokenExtractor extractor;
        String bearerToken;
        SecurityContext securityContext = requestContext.getSecurityContext();
        Principal principal = securityContext.getUserPrincipal();
        if (!(principal instanceof JsonWebToken) && (bearerToken = (extractor = new BearerTokenExtractor(requestContext, this.authContextInfo)).getBearerToken()) != null) {
            try {
                JsonWebToken jwtPrincipal = this.jwtParser.parse(bearerToken);
                this.producer.setJsonWebToken(jwtPrincipal);
                JWTSecurityContext jwtSecurityContext = new JWTSecurityContext(securityContext, jwtPrincipal);
                requestContext.setSecurityContext((SecurityContext)jwtSecurityContext);
                logger.debugf("Success", new Object[0]);
            }
            catch (Exception e) {
                logger.debug((Object)"Unable to parse/validate JWT", (Throwable)e);
            }
        }
    }

    private static class BearerTokenExtractor
    extends AbstractBearerTokenExtractor {
        private final ContainerRequestContext requestContext;

        BearerTokenExtractor(ContainerRequestContext requestContext, JWTAuthContextInfo authContextInfo) {
            super(authContextInfo);
            this.requestContext = requestContext;
        }

        @Override
        protected String getHeaderValue(String headerName) {
            return this.requestContext.getHeaderString(headerName);
        }

        @Override
        protected String getCookieValue(String cookieName) {
            Cookie tokenCookie = (Cookie)this.requestContext.getCookies().get(cookieName);
            if (tokenCookie != null) {
                return tokenCookie.getValue();
            }
            return null;
        }
    }
}

