/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.jaxrs;

import io.smallrye.openapi.api.constants.OpenApiConstants;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.util.ListUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.jaxrs.JaxRsConstants;
import io.smallrye.openapi.jaxrs.JaxRsLogging;
import io.smallrye.openapi.jaxrs.JaxRsParameter;
import io.smallrye.openapi.jaxrs.JaxRsSubResourceLocator;
import io.smallrye.openapi.jaxrs.ParameterProcessor;
import io.smallrye.openapi.jaxrs.RestEasyConstants;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.parameter.ParameterReader;
import io.smallrye.openapi.runtime.io.response.ResponseReader;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.processor.JavaSecurityProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AbstractAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class JaxRsAnnotationScanner
extends AbstractAnnotationScanner {
    private static final String JAXRS_PACKAGE = "jakarta.ws.rs";
    private final Deque<JaxRsSubResourceLocator> subResourceStack = new LinkedList<JaxRsSubResourceLocator>();

    public String getName() {
        return "JAX-RS";
    }

    public boolean isAsyncResponse(MethodInfo method) {
        return method.parameters().stream().map(Type::name).anyMatch(arg_0 -> ((DotName)JaxRsConstants.ASYNC_RESPONSE).equals(arg_0));
    }

    public boolean isPostMethod(MethodInfo method) {
        return method.hasAnnotation(JaxRsConstants.POST);
    }

    public boolean isDeleteMethod(MethodInfo method) {
        return method.hasAnnotation(JaxRsConstants.DELETE);
    }

    public boolean isScannerInternalResponse(Type returnType) {
        return returnType.name().equals((Object)JaxRsConstants.RESPONSE);
    }

    public boolean isMultipartOutput(Type returnType) {
        return RestEasyConstants.MULTIPART_OUTPUTS.contains(returnType.name());
    }

    public boolean isMultipartInput(Type inputType) {
        return RestEasyConstants.MULTIPART_INPUTS.contains(inputType.name());
    }

    public boolean containsScannerAnnotations(List<AnnotationInstance> instances, List<AnnotationScannerExtension> extensions) {
        for (AnnotationInstance instance : instances) {
            if (JaxRsParameter.isParameter(instance.name())) {
                return true;
            }
            if (instance.name().toString().startsWith(JAXRS_PACKAGE)) {
                return true;
            }
            for (AnnotationScannerExtension extension : extensions) {
                if (!extension.isScannerAnnotationExtension(instance)) continue;
                return true;
            }
        }
        return false;
    }

    public OpenAPI scan(AnnotationScannerContext context, OpenAPI openApi) {
        this.processApplicationClasses(context, openApi);
        boolean tagsDefined = openApi.getTags() != null && !openApi.getTags().isEmpty();
        this.processResourceClasses(context, openApi);
        this.sortTags(openApi, tagsDefined);
        this.sortPaths(openApi);
        return openApi;
    }

    private void processApplicationClasses(AnnotationScannerContext context, OpenAPI openApi) {
        Collection applications = context.getIndex().getAllKnownSubclasses(JaxRsConstants.APPLICATION);
        this.processScannerExtensions(context, applications);
        for (ClassInfo classInfo : applications) {
            OpenAPI applicationOpenApi = this.processApplicationClass(context, classInfo);
            openApi = MergeUtil.merge((OpenAPI)openApi, (OpenAPI)applicationOpenApi);
        }
    }

    private OpenAPI processApplicationClass(AnnotationScannerContext context, ClassInfo applicationClass) {
        OpenAPIImpl openApi = new OpenAPIImpl();
        openApi.setOpenapi("3.0.3");
        AnnotationInstance applicationPathAnnotation = JandexUtil.getClassAnnotation((ClassInfo)applicationClass, (DotName)JaxRsConstants.APPLICATION_PATH);
        if (applicationPathAnnotation == null || context.getConfig().applicationPathDisable()) {
            applicationPathAnnotation = JandexUtil.getClassAnnotation((ClassInfo)applicationClass, (DotName)JaxRsConstants.PATH);
        }
        this.currentAppPath = applicationPathAnnotation != null ? applicationPathAnnotation.value().asString() : "/";
        this.processDefinitionAnnotation(context, applicationClass, (OpenAPI)openApi);
        this.processSecuritySchemeAnnotation(applicationClass, (OpenAPI)openApi);
        this.processServerAnnotation(applicationClass, (OpenAPI)openApi);
        return openApi;
    }

    private void processResourceClasses(AnnotationScannerContext context, OpenAPI openApi) {
        Collection<ClassInfo> resourceClasses = this.getJaxRsResourceClasses((IndexView)context.getIndex());
        for (ClassInfo resourceClass : resourceClasses) {
            this.processResourceClass(context, openApi, resourceClass, null);
        }
    }

    private void processResourceClass(AnnotationScannerContext context, OpenAPI openApi, ClassInfo resourceClass, List<Parameter> locatorPathParameters) {
        JaxRsLogging.log.processingClass(resourceClass.simpleName());
        this.processSecuritySchemeAnnotation(resourceClass, openApi);
        this.processJavaSecurity(resourceClass, openApi);
        this.processResourceMethods(context, resourceClass, openApi, locatorPathParameters);
    }

    private void processResourceMethods(AnnotationScannerContext context, ClassInfo resourceClass, OpenAPI openApi, List<Parameter> locatorPathParameters) {
        Set tagRefs = this.processTags((AnnotationTarget)resourceClass, openApi, false);
        Map<DotName, AnnotationInstance> exceptionAnnotationMap = this.processExceptionMappers(context);
        for (MethodInfo methodInfo : this.getResourceMethods(context, resourceClass)) {
            AtomicInteger resourceCount = new AtomicInteger(0);
            JaxRsConstants.HTTP_METHODS.stream().filter(arg_0 -> ((MethodInfo)methodInfo).hasAnnotation(arg_0)).map(DotName::withoutPackagePrefix).map(PathItem.HttpMethod::valueOf).forEach(httpMethod -> {
                resourceCount.incrementAndGet();
                this.processResourceMethod(context, resourceClass, methodInfo, (PathItem.HttpMethod)httpMethod, openApi, tagRefs, locatorPathParameters, exceptionAnnotationMap);
            });
            if (resourceCount.get() != 0 || !methodInfo.hasAnnotation(JaxRsConstants.PATH)) continue;
            this.processSubResource(context, resourceClass, methodInfo, openApi, locatorPathParameters);
        }
    }

    private Map<DotName, AnnotationInstance> processExceptionMappers(AnnotationScannerContext context) {
        HashMap<DotName, AnnotationInstance> exceptionHandlerMap = new HashMap<DotName, AnnotationInstance>();
        Collection exceptionMappers = context.getIndex().getKnownDirectImplementors(JaxRsConstants.EXCEPTION_MAPPER);
        for (ClassInfo classInfo : exceptionMappers) {
            DotName exceptionDotName = classInfo.interfaceTypes().stream().filter(it -> it.name().equals((Object)JaxRsConstants.EXCEPTION_MAPPER)).filter(it -> it.kind() == Type.Kind.PARAMETERIZED_TYPE).map(Type::asParameterizedType).map(type -> (Type)type.arguments().get(0)).map(Type::name).findFirst().orElse(null);
            if (exceptionDotName == null) continue;
            MethodInfo toResponseMethod = classInfo.method("toResponse", new Type[]{Type.create((DotName)exceptionDotName, (Type.Kind)Type.Kind.CLASS)});
            if (!ResponseReader.hasResponseCodeValue((MethodInfo)toResponseMethod)) continue;
            exceptionHandlerMap.put(exceptionDotName, ResponseReader.getResponseAnnotation((MethodInfo)toResponseMethod));
        }
        return exceptionHandlerMap;
    }

    private void processSubResource(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo method, OpenAPI openApi, List<Parameter> locatorPathParameters) {
        Type methodReturnType = method.returnType();
        if (Type.Kind.VOID.equals((Object)methodReturnType.kind())) {
            return;
        }
        JaxRsSubResourceLocator locator = new JaxRsSubResourceLocator(resourceClass, method);
        ClassInfo subResourceClass = context.getIndex().getClassByName(methodReturnType.name());
        if (subResourceClass != null && !this.subResourceStack.contains(locator)) {
            Function<AnnotationInstance, Parameter> reader = t -> ParameterReader.readParameter((AnnotationScannerContext)context, (AnnotationInstance)t);
            ResourceParameters params = ParameterProcessor.process(context, resourceClass, method, reader, context.getExtensions());
            String originalAppPath = this.currentAppPath;
            String subResourcePath = this.subResourceStack.isEmpty() ? params.getFullOperationPath() : params.getOperationPath();
            this.currentAppPath = JaxRsAnnotationScanner.createPathFromSegments((String[])new String[]{this.currentAppPath, subResourcePath});
            this.subResourceStack.push(locator);
            this.processResourceClass(context, openApi, subResourceClass, ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters(), params.getOperationParameters()}));
            this.subResourceStack.pop();
            this.currentAppPath = originalAppPath;
        }
    }

    private void processResourceMethod(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo method, PathItem.HttpMethod methodType, OpenAPI openApi, Set<String> resourceTags, List<Parameter> locatorPathParameters, Map<DotName, AnnotationInstance> exceptionAnnotationMap) {
        JaxRsLogging.log.processingMethod(method.toString());
        CurrentScannerInfo.setCurrentConsumes((String[])JaxRsAnnotationScanner.getMediaTypes(method, JaxRsConstants.CONSUMES, (String[])context.getConfig().getDefaultConsumes().orElse(OpenApiConstants.DEFAULT_MEDIA_TYPES.get())).orElse(null));
        CurrentScannerInfo.setCurrentProduces((String[])JaxRsAnnotationScanner.getMediaTypes(method, JaxRsConstants.PRODUCES, (String[])context.getConfig().getDefaultProduces().orElse(OpenApiConstants.DEFAULT_MEDIA_TYPES.get())).orElse(null));
        Optional maybeOperation = this.processOperation(context, method);
        if (!maybeOperation.isPresent()) {
            return;
        }
        Operation operation = (Operation)maybeOperation.get();
        this.processOperationTags(method, openApi, resourceTags, operation);
        Function<AnnotationInstance, Parameter> reader = t -> ParameterReader.readParameter((AnnotationScannerContext)context, (AnnotationInstance)t);
        ResourceParameters params = ParameterProcessor.process(context, resourceClass, method, reader, context.getExtensions());
        operation.setParameters(params.getOperationParameters());
        PathItemImpl pathItem = new PathItemImpl();
        pathItem.setParameters(ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters()}));
        RequestBody requestBody = this.processRequestBody(context, method, params);
        if (requestBody != null) {
            operation.setRequestBody(requestBody);
        }
        this.processResponse(context, method, operation, exceptionAnnotationMap);
        this.processSecurityRequirementAnnotation(resourceClass, method, operation);
        this.processCallback(context, method, operation);
        this.processServerAnnotation(method, operation);
        this.processExtensions(context, method, operation);
        JavaSecurityProcessor.processSecurityRoles((MethodInfo)method, (Operation)operation);
        this.setOperationOnPathItem(methodType, (PathItem)pathItem, operation);
        String path = this.subResourceStack.isEmpty() ? super.makePath(params.getFullOperationPath()) : super.makePath(params.getOperationPath());
        PathItem existingPath = ModelUtil.paths((OpenAPI)openApi).getPathItem(path);
        if (existingPath == null) {
            ModelUtil.paths((OpenAPI)openApi).addPathItem(path, (PathItem)pathItem);
        } else {
            MergeUtil.mergeObjects((Object)existingPath, (Object)pathItem);
        }
    }

    static Optional<String[]> getMediaTypes(MethodInfo resourceMethod, DotName annotationName, String[] defaultValue) {
        AnnotationInstance annotation = resourceMethod.annotation(annotationName);
        if (annotation == null) {
            annotation = JandexUtil.getClassAnnotation((ClassInfo)resourceMethod.declaringClass(), (DotName)annotationName);
        }
        if (annotation != null) {
            AnnotationValue annotationValue = annotation.value();
            if (annotationValue != null) {
                return Optional.of(annotationValue.asStringArray());
            }
            return Optional.of(defaultValue);
        }
        return Optional.empty();
    }

    private Collection<ClassInfo> getJaxRsResourceClasses(IndexView index) {
        return index.getAnnotations(JaxRsConstants.PATH).stream().map(AnnotationInstance::target).filter(target -> target.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass).filter(classInfo -> !Modifier.isInterface(classInfo.flags()) || index.getAllKnownImplementors(classInfo.name()).stream().anyMatch(info -> !Modifier.isAbstract(info.flags()))).distinct().collect(Collectors.toList());
    }
}

