/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import jakarta.annotation.Priority;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.plugins.providers.jackson.WhiteListPolymorphicTypeValidatorBuilder;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedTreeMap;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Provider
@Priority(value=0x7FFFFFFF)
public class PatchMethodFilter
implements ContainerRequestFilter {
    private volatile ObjectMapper objectMapper;
    @Context
    protected Providers providers;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (requestContext.getMethod().equals("PATCH") && MediaType.APPLICATION_JSON_PATCH_JSON_TYPE.isCompatible(requestContext.getMediaType())) {
            HttpRequest request = (HttpRequest)ResteasyProviderFactory.getContextData(HttpRequest.class);
            HttpResponse response = (HttpResponse)ResteasyProviderFactory.getContextData(HttpResponse.class);
            request.setHttpMethod("GET");
            Registry methodRegistry = (Registry)ResteasyProviderFactory.getContextData(Registry.class);
            ResourceInvoker resourceInovker = methodRegistry.getResourceInvoker(request);
            if (resourceInovker == null) {
                throw new ProcessingException("Get method not found and patch method failed");
            }
            ResourceMethodInvoker methodInvoker = (ResourceMethodInvoker)resourceInovker;
            try {
                Object object = methodInvoker.invokeDryRun(request, response);
                ByteArrayOutputStream tmpOutputStream = new ByteArrayOutputStream();
                MessageBodyWriter msgBodyWriter = ResteasyProviderFactory.getInstance().getMessageBodyWriter(object.getClass(), object.getClass(), methodInvoker.getMethodAnnotations(), MediaType.APPLICATION_JSON_TYPE);
                if (msgBodyWriter == null) {
                    throw new ProcessingException(Messages.MESSAGES.couldNotFindWriterForContentType(MediaType.APPLICATION_JSON_TYPE, object.getClass().getName()));
                }
                msgBodyWriter.writeTo(object, object.getClass(), object.getClass(), methodInvoker.getMethodAnnotations(), MediaType.APPLICATION_JSON_TYPE, (MultivaluedMap)new MultivaluedTreeMap(), (OutputStream)tmpOutputStream);
                ObjectMapper mapper = this.getObjectMapper();
                PolymorphicTypeValidator ptv = mapper.getPolymorphicTypeValidator();
                if (ptv == null || ptv instanceof LaissezFaireSubTypeValidator) {
                    mapper.setPolymorphicTypeValidator((PolymorphicTypeValidator)new WhiteListPolymorphicTypeValidatorBuilder().build());
                }
                JsonNode targetJson = (JsonNode)mapper.readValue(tmpOutputStream.toByteArray(), JsonNode.class);
                JsonPatch patch = JsonPatch.fromJson((JsonNode)((JsonNode)mapper.readValue(request.getInputStream(), JsonNode.class)));
                JsonNode result = patch.apply(targetJson);
                ByteArrayOutputStream targetOutputStream = new ByteArrayOutputStream();
                mapper.writeValue((OutputStream)targetOutputStream, (Object)result);
                request.setInputStream((InputStream)new ByteArrayInputStream(targetOutputStream.toByteArray()));
                request.setHttpMethod("PATCH");
            }
            catch (ProcessingException pe) {
                Throwable c = pe.getCause();
                if (c != null && c instanceof ApplicationException && (c = c.getCause()) != null && c instanceof NotFoundException) {
                    throw (NotFoundException)c;
                }
                throw pe;
            }
            catch (JsonParseException | JsonMappingException e) {
                throw new BadRequestException(e);
            }
            catch (JsonPatchException e) {
                throw new Failure((Throwable)e, 409);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            PatchMethodFilter patchMethodFilter = this;
            synchronized (patchMethodFilter) {
                if (this.objectMapper == null) {
                    ObjectMapper contextMapper = this.getContextObjectMapper();
                    this.objectMapper = contextMapper == null ? new ObjectMapper() : contextMapper;
                }
            }
        }
        return this.objectMapper;
    }

    private ObjectMapper getContextObjectMapper() {
        ContextResolver resolver = this.providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE);
        if (resolver == null) {
            return null;
        }
        return (ObjectMapper)resolver.getContext(ObjectMapper.class);
    }
}

