/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.jms;

import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.MessageFormatException;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.reader.MapMessageUtil;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;

public final class ServerJMSMapMessage
extends ServerJMSMessage
implements MapMessage {
    public static final byte TYPE = 5;
    private final TypedProperties map = new TypedProperties();

    public ServerJMSMapMessage(ICoreMessage message) {
        super(message);
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.map.putBooleanProperty(new SimpleString(name), value);
    }

    public void setByte(String name, byte value) throws JMSException {
        this.map.putByteProperty(new SimpleString(name), value);
    }

    public void setShort(String name, short value) throws JMSException {
        this.map.putShortProperty(new SimpleString(name), value);
    }

    public void setChar(String name, char value) throws JMSException {
        this.map.putCharProperty(new SimpleString(name), value);
    }

    public void setInt(String name, int value) throws JMSException {
        this.map.putIntProperty(new SimpleString(name), value);
    }

    public void setLong(String name, long value) throws JMSException {
        this.map.putLongProperty(new SimpleString(name), value);
    }

    public void setFloat(String name, float value) throws JMSException {
        this.map.putFloatProperty(new SimpleString(name), value);
    }

    public void setDouble(String name, double value) throws JMSException {
        this.map.putDoubleProperty(new SimpleString(name), value);
    }

    public void setString(String name, String value) throws JMSException {
        this.map.putSimpleStringProperty(new SimpleString(name), value == null ? null : new SimpleString(value));
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.map.putBytesProperty(new SimpleString(name), value);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (offset + length > value.length) {
            throw new JMSException("Invalid offset/length");
        }
        byte[] newBytes = new byte[length];
        System.arraycopy(value, offset, newBytes, 0, length);
        this.map.putBytesProperty(new SimpleString(name), newBytes);
    }

    public void setObject(String name, Object value) throws JMSException {
        try {
            Object val = value;
            if (value instanceof UnsignedInteger) {
                val = ((UnsignedInteger)value).intValue();
            } else if (value instanceof UnsignedShort) {
                val = ((UnsignedShort)value).shortValue();
            } else if (value instanceof UnsignedByte) {
                val = ((UnsignedByte)value).byteValue();
            } else if (value instanceof UnsignedLong) {
                val = ((UnsignedLong)value).longValue();
            }
            TypedProperties.setObjectProperty((SimpleString)new SimpleString(name), (Object)val, (TypedProperties)this.map);
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        try {
            return this.map.getBooleanProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public byte getByte(String name) throws JMSException {
        try {
            return this.map.getByteProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public short getShort(String name) throws JMSException {
        try {
            return this.map.getShortProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public char getChar(String name) throws JMSException {
        try {
            return this.map.getCharProperty(new SimpleString(name)).charValue();
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public int getInt(String name) throws JMSException {
        try {
            return this.map.getIntProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public long getLong(String name) throws JMSException {
        try {
            return this.map.getLongProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public float getFloat(String name) throws JMSException {
        try {
            return this.map.getFloatProperty(new SimpleString(name)).floatValue();
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public double getDouble(String name) throws JMSException {
        try {
            return this.map.getDoubleProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public String getString(String name) throws JMSException {
        try {
            SimpleString str = this.map.getSimpleStringProperty(new SimpleString(name));
            if (str == null) {
                return null;
            }
            return str.toString();
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public byte[] getBytes(String name) throws JMSException {
        try {
            return this.map.getBytesProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public Object getObject(String name) throws JMSException {
        Object val = this.map.getProperty(new SimpleString(name));
        if (val instanceof SimpleString) {
            val = ((SimpleString)val).toString();
        }
        return val;
    }

    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(this.map.getMapNames());
    }

    public boolean itemExists(String name) throws JMSException {
        return this.map.containsProperty(new SimpleString(name));
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.map.clear();
    }

    @Override
    public void encode() throws Exception {
        super.encode();
        MapMessageUtil.writeBodyMap((ActiveMQBuffer)this.getWriteBodyBuffer(), (TypedProperties)this.map);
    }

    @Override
    public void decode() throws Exception {
        super.decode();
        MapMessageUtil.readBodyMap((ActiveMQBuffer)this.getReadBodyBuffer(), (TypedProperties)this.map);
    }
}

