/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.Set;
import org.jboss.as.weld.discovery.AnnotationType;
import org.jboss.jandex.DotName;
import org.jboss.weld.util.collections.ImmutableSet;

public enum CdiAnnotations {
    DECORATOR(Constants.JAVAX_DECORATOR, "Decorator"),
    DELEGATE(Constants.JAVAX_DECORATOR, "Delegate"),
    APP_SCOPED(Constants.JAVAX_ENT_CONTEXT, "ApplicationScoped"),
    CONV_SCOPED(Constants.JAVAX_ENT_CONTEXT, "ConversationScoped"),
    REQ_SCOPED(Constants.JAVAX_ENT_CONTEXT, "RequestScoped"),
    SESS_SCOPED(Constants.JAVAX_ENT_CONTEXT, "SessionScoped"),
    NORM_SCOPE(Constants.JAVAX_ENT_CONTEXT, "NormalScope"),
    DEPENDENT(Constants.JAVAX_ENT_CONTEXT, "Dependent"),
    SINGLETON(Constants.JAVAX_INJ, "Singleton"),
    OBSERVES(Constants.JAVAX_ENT_EVT, "Observes"),
    ALTERNATIVE(Constants.JAVAX_ENT_INJ, "Alternative"),
    ANY(Constants.JAVAX_ENT_INJ, "Any"),
    DEFAULT(Constants.JAVAX_ENT_INJ, "Default"),
    DISPOSES(Constants.JAVAX_ENT_INJ, "Disposes"),
    MODEL(Constants.JAVAX_ENT_INJ, "Model"),
    NEW(Constants.JAVAX_ENT_INJ, "New"),
    PRODUCES(Constants.JAVAX_ENT_INJ, "Produces"),
    SPECIALIZES(Constants.JAVAX_ENT_INJ, "Specializes"),
    STEREOTYPE(Constants.JAVAX_ENT_INJ, "Stereotype"),
    TYPED(Constants.JAVAX_ENT_INJ, "Typed");

    private final String simpleName;
    private final DotName dotName;
    public static final DotName SCOPE;
    public static final Set<DotName> BUILT_IN_SCOPE_NAMES;
    public static final Set<AnnotationType> BUILT_IN_SCOPES;
    public static final Set<AnnotationType> BEAN_DEFINING_ANNOTATIONS;
    public static final Set<AnnotationType> BEAN_DEFINING_META_ANNOTATIONS;

    private CdiAnnotations(DotName prefix, String simpleName) {
        this.simpleName = simpleName;
        this.dotName = DotName.createComponentized((DotName)prefix, (String)simpleName);
    }

    public DotName getDotName() {
        return this.dotName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    private static AnnotationType asAnnotationType(CdiAnnotations annotation) {
        return new AnnotationType(annotation.getDotName(), true);
    }

    private static AnnotationType asAnnotationType(CdiAnnotations annotation, boolean inherited) {
        return new AnnotationType(annotation.getDotName(), inherited);
    }

    static {
        SCOPE = DotName.createComponentized((DotName)Constants.JAVAX_INJ, (String)"Scope");
        BUILT_IN_SCOPE_NAMES = ImmutableSet.of((Object[])new DotName[]{DEPENDENT.getDotName(), REQ_SCOPED.getDotName(), CONV_SCOPED.getDotName(), SESS_SCOPED.getDotName(), APP_SCOPED.getDotName(), SINGLETON.getDotName()});
        BUILT_IN_SCOPES = (Set)BUILT_IN_SCOPE_NAMES.stream().map(dotName -> new AnnotationType((DotName)dotName, true)).collect(ImmutableSet.collector());
        BEAN_DEFINING_ANNOTATIONS = ImmutableSet.of((Object[])new AnnotationType[]{new AnnotationType(DotName.createComponentized((DotName)Constants.JAVAX_INTERCEPTOR, (String)"Interceptor"), false), CdiAnnotations.asAnnotationType(DECORATOR, false), CdiAnnotations.asAnnotationType(DEPENDENT), CdiAnnotations.asAnnotationType(REQ_SCOPED), CdiAnnotations.asAnnotationType(CONV_SCOPED), CdiAnnotations.asAnnotationType(SESS_SCOPED), CdiAnnotations.asAnnotationType(APP_SCOPED)});
        BEAN_DEFINING_META_ANNOTATIONS = ImmutableSet.of((Object[])new AnnotationType[]{CdiAnnotations.asAnnotationType(NORM_SCOPE, false), CdiAnnotations.asAnnotationType(STEREOTYPE, false)});
    }

    private static class Constants {
        public static final DotName JAVAX = DotName.createComponentized(null, (String)"jakarta");
        public static final DotName JAVAX_INTERCEPTOR = DotName.createComponentized((DotName)JAVAX, (String)"interceptor");
        public static final DotName JAVAX_DECORATOR = DotName.createComponentized((DotName)JAVAX, (String)"decorator");
        public static final DotName JAVAX_ENT = DotName.createComponentized((DotName)JAVAX, (String)"enterprise");
        public static final DotName JAVAX_ENT_CONTEXT = DotName.createComponentized((DotName)JAVAX_ENT, (String)"context");
        public static final DotName JAVAX_ENT_EVT = DotName.createComponentized((DotName)JAVAX_ENT, (String)"event");
        public static final DotName JAVAX_ENT_INJ = DotName.createComponentized((DotName)JAVAX_ENT, (String)"inject");
        public static final DotName JAVAX_INJ = DotName.createComponentized((DotName)JAVAX, (String)"inject");

        private Constants() {
        }
    }
}

