/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionAddHandler;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionRegistryType;
import org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class ExtensionRemoveHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "remove";
    private final ExtensionRegistry extensionRegistry;
    private final ExtensionRegistryType extensionRegistryType;
    private final MutableRootResourceRegistrationProvider rootResourceRegistrationProvider;

    public ExtensionRemoveHandler(ExtensionRegistry extensionRegistry, ExtensionRegistryType extensionRegistryType, MutableRootResourceRegistrationProvider rootResourceRegistrationProvider) {
        this.extensionRegistry = extensionRegistry;
        this.extensionRegistryType = extensionRegistryType;
        this.rootResourceRegistrationProvider = rootResourceRegistrationProvider;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String module = context.getCurrentAddressValue();
        if (context.removeResource(PathAddress.EMPTY_ADDRESS) == null) {
            throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(context.getCurrentAddress());
        }
        final ManagementResourceRegistration rootRegistration = this.rootResourceRegistrationProvider.getRootResourceRegistrationForUpdate(context);
        try {
            this.extensionRegistry.removeExtension(context.readResourceFromRoot(rootRegistration.getPathAddress()), module, rootRegistration);
        }
        catch (IllegalStateException isex) {
            throw new OperationFailedException(isex.getMessage());
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                ExtensionAddHandler.initializeExtension(ExtensionRemoveHandler.this.extensionRegistry, module, rootRegistration, ExtensionRemoveHandler.this.extensionRegistryType);
            }
        });
    }
}

