/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management.impl;

import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.management.ArtemisMBeanServerGuard;
import org.apache.activemq.artemis.core.server.management.HawtioSecurityControl;

public class HawtioSecurityControlImpl
extends AbstractControl
implements HawtioSecurityControl {
    static final TabularType CAN_INVOKE_TABULAR_TYPE = SecurityMBeanOpenTypeInitializer.access$000();
    static final CompositeType CAN_INVOKE_RESULT_ROW_TYPE = SecurityMBeanOpenTypeInitializer.access$100();
    static final String[] CAN_INVOKE_RESULT_COLUMNS = SecurityMBeanOpenTypeInitializer.access$200();
    private final ArtemisMBeanServerGuard mBeanServerGuard;

    public HawtioSecurityControlImpl(ArtemisMBeanServerGuard mBeanServerGuard, StorageManager storageManager) throws NotCompliantMBeanException {
        super(HawtioSecurityControl.class, storageManager);
        this.mBeanServerGuard = mBeanServerGuard;
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(HawtioSecurityControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(HawtioSecurityControl.class);
    }

    @Override
    public boolean canInvoke(String objectName) throws Exception {
        return this.mBeanServerGuard == null || this.mBeanServerGuard.canInvoke(objectName, null);
    }

    @Override
    public boolean canInvoke(String objectName, String methodName) throws Exception {
        return this.mBeanServerGuard == null || this.mBeanServerGuard.canInvoke(objectName, methodName);
    }

    @Override
    public boolean canInvoke(String objectName, String methodName, String[] argumentTypes) throws Exception {
        return this.mBeanServerGuard == null || this.mBeanServerGuard.canInvoke(objectName, methodName);
    }

    @Override
    public TabularData canInvoke(Map<String, List<String>> bulkQuery) throws Exception {
        TabularDataSupport table = new TabularDataSupport(CAN_INVOKE_TABULAR_TYPE);
        for (Map.Entry<String, List<String>> entry : bulkQuery.entrySet()) {
            String objectName = entry.getKey();
            List<String> methods = entry.getValue();
            if (methods.size() == 0) {
                boolean res = this.canInvoke(objectName);
                CompositeDataSupport data = new CompositeDataSupport(CAN_INVOKE_RESULT_ROW_TYPE, CAN_INVOKE_RESULT_COLUMNS, new Object[]{objectName, "", true});
                table.put(data);
                continue;
            }
            for (String method : methods) {
                CompositeDataSupport data = new CompositeDataSupport(CAN_INVOKE_RESULT_ROW_TYPE, CAN_INVOKE_RESULT_COLUMNS, new Object[]{objectName, method, true});
                table.put(data);
            }
        }
        return table;
    }

    static class SecurityMBeanOpenTypeInitializer {
        private static final String[] COLUMNS = new String[]{"ObjectName", "Method", "CanInvoke"};
        private static final CompositeType ROW_TYPE;
        private static final TabularType TABULAR_TYPE;

        SecurityMBeanOpenTypeInitializer() {
        }

        static /* synthetic */ TabularType access$000() {
            return TABULAR_TYPE;
        }

        static /* synthetic */ CompositeType access$100() {
            return ROW_TYPE;
        }

        static /* synthetic */ String[] access$200() {
            return COLUMNS;
        }

        static {
            try {
                ROW_TYPE = new CompositeType("CanInvokeRowType", "The rows of a CanInvokeTabularType table.", COLUMNS, new String[]{"The ObjectName of the MBean checked", "The Method to checked. This can either be a bare method name which means 'any method with this name' or a specific overload such as foo(java.lang.String). If an empty String is returned this means 'any' method.", "true if the method or mbean can potentially be invoked by the current user."}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN});
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
            try {
                TABULAR_TYPE = new TabularType("CanInvokeTabularType", "Result of canInvoke() bulk operation", ROW_TYPE, new String[]{"ObjectName", "Method"});
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

