/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.irac.IracMetadataRequestCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.impl.AbstractIracLocalSiteInterceptor;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.remoting.transport.ValidSingleResponseCollector;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.util.IracUtils;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PessimisticTxIracLocalInterceptor
extends AbstractIracLocalSiteInterceptor {
    private static final Log log = LogFactory.getLog(PessimisticTxIracLocalInterceptor.class);
    private static final IracMetadataResponseCollector RESPONSE_COLLECTOR = new IracMetadataResponseCollector();
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    RpcManager rpcManager;

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
        if (ctx.isOriginLocal()) {
            return this.onLocalPrepare(PessimisticTxIracLocalInterceptor.asLocalTxInvocationContext(ctx), command);
        }
        return this.onRemotePrepare(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) {
        return this.invokeNext(ctx, command);
    }

    @Override
    public boolean isTraceEnabled() {
        return log.isTraceEnabled();
    }

    @Override
    public Log getLog() {
        return log;
    }

    private Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) {
        Object key = command.getKey();
        if (PessimisticTxIracLocalInterceptor.isIracState(command)) {
            this.setMetadataToCacheEntry(ctx.lookupEntry(key), command.getInternalMetadata(key).iracMetadata());
            return this.invokeNext(ctx, command);
        }
        return this.skipCommand(ctx, command) ? this.invokeNext(ctx, command) : this.invokeNextThenAccept(ctx, command, this::afterVisitDataWriteCommand);
    }

    private void afterVisitDataWriteCommand(InvocationContext ctx, DataWriteCommand command, Object rv) {
        if (!command.isSuccessful()) {
            return;
        }
        this.setMetadataForWrite(PessimisticTxIracLocalInterceptor.asLocalTxInvocationContext(ctx), command, command.getKey());
    }

    private Object visitWriteCommand(InvocationContext ctx, WriteCommand command) {
        return this.skipCommand(ctx, command) ? this.invokeNext(ctx, command) : this.invokeNextThenAccept(ctx, command, this::afterVisitWriteCommand);
    }

    private void afterVisitWriteCommand(InvocationContext ctx, WriteCommand command, Object rv) {
        if (!command.isSuccessful()) {
            return;
        }
        LocalTxInvocationContext txCtx = PessimisticTxIracLocalInterceptor.asLocalTxInvocationContext(ctx);
        for (Object key : command.getAffectedKeys()) {
            this.setMetadataForWrite(txCtx, command, key);
        }
    }

    private Object onLocalPrepare(LocalTxInvocationContext ctx, PrepareCommand command) {
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] On local prepare for tx %s", command.getGlobalTransaction());
        }
        AggregateCompletionStage<Void> allStages = CompletionStages.aggregateCompletionStage();
        Iterator iterator = this.streamKeysFromModifications(command.getModifications()).iterator();
        while (iterator.hasNext()) {
            AbstractIracLocalSiteInterceptor.StreamData data = (AbstractIracLocalSiteInterceptor.StreamData)iterator.next();
            CompletionStage<IracMetadata> rsp = ctx.getIracMetadata(data.key);
            allStages.dependsOn(rsp.thenAccept(iracMetadata -> this.setMetadataBeforeSendingPrepare(ctx, data, (IracMetadata)iracMetadata)));
        }
        return this.asyncInvokeNext((InvocationContext)ctx, (VisitableCommand)command, allStages.freeze());
    }

    private Object onRemotePrepare(TxInvocationContext<RemoteTransaction> ctx, PrepareCommand command) {
        Iterator iterator = this.streamKeysFromModifications(command.getModifications()).filter(this::isWriteOwner).iterator();
        while (iterator.hasNext()) {
            AbstractIracLocalSiteInterceptor.StreamData data = (AbstractIracLocalSiteInterceptor.StreamData)iterator.next();
            this.setMetadataToCacheEntry(ctx.lookupEntry(data.key), data.command.getInternalMetadata(data.key).iracMetadata());
        }
        return this.invokeNext(ctx, command);
    }

    private void setMetadataBeforeSendingPrepare(LocalTxInvocationContext ctx, AbstractIracLocalSiteInterceptor.StreamData data, IracMetadata metadata) {
        CacheEntry entry = ctx.lookupEntry(data.key);
        assert (entry != null);
        PessimisticTxIracLocalInterceptor.updateCommandMetadata(data.key, data.command, metadata);
        if (this.isWriteOwner(data)) {
            this.setMetadataToCacheEntry(entry, metadata);
        }
    }

    private void setMetadataForWrite(LocalTxInvocationContext ctx, WriteCommand command, Object key) {
        if (ctx.hasIracMetadata(key)) {
            return;
        }
        int segment = this.getSegment(command, key);
        CompletionStage<IracMetadata> metadata = this.requestNewMetadata(segment, ctx.lookupEntry(key));
        ctx.storeIracMetadata(key, metadata);
    }

    private CompletionStage<IracMetadata> requestNewMetadata(int segment, CacheEntry<?, ?> cacheEntry) {
        LocalizedCacheTopology cacheTopology = this.getCacheTopology();
        DistributionInfo dInfo = cacheTopology.getSegmentDistribution(segment);
        if (dInfo.isPrimary()) {
            IracEntryVersion versionSeen = IracUtils.getIracVersionFromCacheEntry(cacheEntry);
            return CompletableFuture.completedFuture(this.iracVersionGenerator.generateNewMetadata(segment, versionSeen));
        }
        return this.requestNewMetadataFromPrimaryOwner(dInfo, cacheTopology.getTopologyId(), cacheEntry);
    }

    private CompletionStage<IracMetadata> requestNewMetadataFromPrimaryOwner(DistributionInfo dInfo, int topologyId, CacheEntry<?, ?> cacheEntry) {
        IracEntryVersion versionSeen = IracUtils.getIracVersionFromCacheEntry(cacheEntry);
        IracMetadataRequestCommand cmd = this.commandsFactory.buildIracMetadataRequestCommand(dInfo.segmentId(), versionSeen);
        cmd.setTopologyId(topologyId);
        RpcOptions rpcOptions = this.rpcManager.getSyncRpcOptions();
        return this.rpcManager.invokeCommand(dInfo.primary(), (ReplicableCommand)cmd, RESPONSE_COLLECTOR, rpcOptions);
    }

    private boolean skipCommand(InvocationContext ctx, FlagAffectedCommand command) {
        return !ctx.isOriginLocal() || command.hasAnyFlag(FlagBitSets.IRAC_UPDATE);
    }

    private static class IracMetadataResponseCollector
    extends ValidSingleResponseCollector<IracMetadata> {
        private IracMetadataResponseCollector() {
        }

        @Override
        protected IracMetadata withValidResponse(Address sender, ValidResponse response) {
            Object rv = response.getResponseValue();
            assert (rv instanceof IracMetadata) : "[IRAC] invalid response! Expects IracMetadata but got " + rv;
            return (IracMetadata)rv;
        }

        @Override
        protected IracMetadata targetNotFound(Address sender) {
            throw ResponseCollectors.remoteNodeSuspected(sender);
        }
    }
}

