/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.GlobalRpcCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TopologyManagementHelper {
    private static final Log log = LogFactory.getLog(TopologyManagementHelper.class);
    private GlobalComponentRegistry gcr;
    private BasicComponentRegistry bcr;

    public TopologyManagementHelper(GlobalComponentRegistry gcr) {
        this.gcr = gcr;
        this.bcr = gcr.getComponent(BasicComponentRegistry.class);
    }

    public <T> CompletionStage<T> executeOnClusterSync(Transport transport, ReplicableCommand command, int timeout, ResponseCollector<T> responseCollector) {
        CompletionStage<Object> localFuture;
        DelegatingResponseCollector<T> delegatingCollector = new DelegatingResponseCollector<T>(responseCollector);
        CompletionStage<Void> remoteFuture = transport.invokeCommandOnAll(command, delegatingCollector, DeliverOrder.NONE, timeout, TimeUnit.MILLISECONDS);
        try {
            if (log.isTraceEnabled()) {
                log.tracef("Attempting to execute command on self: %s", command);
            }
            this.bcr.wireDependencies(command, true);
            localFuture = this.invokeAsync(command);
        }
        catch (Throwable throwable) {
            localFuture = CompletableFutures.completedExceptionFuture(throwable);
        }
        return this.addLocalResult(responseCollector, remoteFuture, localFuture, transport.getAddress());
    }

    public void executeOnClusterAsync(Transport transport, ReplicableCommand command) {
        try {
            DeliverOrder deliverOrder = DeliverOrder.NONE;
            transport.sendToAll(command, deliverOrder);
        }
        catch (Exception e) {
            throw Util.rewrapAsCacheException((Throwable)e);
        }
        try {
            if (log.isTraceEnabled()) {
                log.tracef("Attempting to execute command on self: %s", command);
            }
            this.bcr.wireDependencies(command, true);
            this.invokeAsync(command);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public CompletionStage<Object> executeOnCoordinator(Transport transport, ReplicableCommand command, long timeoutMillis) {
        CompletionStage<Response> responseStage;
        Address coordinator = transport.getCoordinator();
        if (transport.getAddress().equals(coordinator)) {
            try {
                if (log.isTraceEnabled()) {
                    log.tracef("Attempting to execute command on self: %s", command);
                }
                this.bcr.wireDependencies(command, true);
                responseStage = this.invokeAsync(command).thenApply(v -> this.makeResponse(v, null, transport.getAddress()));
            }
            catch (Throwable t) {
                throw CompletableFutures.asCompletionException(t);
            }
        } else {
            responseStage = transport.invokeCommand(coordinator, command, SingleResponseCollector.validOnly(), DeliverOrder.NONE, timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return responseStage.thenApply(response -> {
            if (!(response instanceof SuccessfulResponse)) {
                throw Log.CLUSTER.unexpectedResponse(coordinator, (Response)response);
            }
            return ((SuccessfulResponse)response).getResponseValue();
        });
    }

    public void executeOnCoordinatorAsync(Transport transport, AbstractCacheControlCommand command) throws Exception {
        if (transport.isCoordinator()) {
            if (log.isTraceEnabled()) {
                log.tracef("Attempting to execute command on self: %s", command);
            }
            try {
                this.invokeAsync(command);
            }
            catch (Throwable t) {
                log.errorf(t, "Failed to execute ReplicableCommand %s on coordinator async: %s", command, t.getMessage());
            }
        } else {
            Address coordinator = transport.getCoordinator();
            transport.sendTo(coordinator, command, DeliverOrder.NONE);
        }
    }

    private <T> CompletionStage<T> addLocalResult(ResponseCollector<T> responseCollector, CompletionStage<Void> remoteFuture, CompletionStage<?> localFuture, Address localAddress) {
        return remoteFuture.thenCompose(ignore -> localFuture.handle((v, t) -> {
            Response localResponse = this.makeResponse(v, (Throwable)t, localAddress);
            responseCollector.addResponse(localAddress, localResponse);
            return responseCollector.finish();
        }));
    }

    private Response makeResponse(Object v, Throwable t, Address localAddress) {
        Response localResponse = t != null ? new ExceptionResponse((Exception)((Object)Log.CLUSTER.remoteException(localAddress, CompletableFutures.extractException(t)))) : (v instanceof Response ? (SuccessfulResponse<Object>)v : SuccessfulResponse.create(v));
        return localResponse;
    }

    private CompletionStage<?> invokeAsync(ReplicableCommand command) throws Throwable {
        if (command instanceof GlobalRpcCommand) {
            return ((GlobalRpcCommand)command).invokeAsync(this.gcr);
        }
        return command.invokeAsync();
    }

    private static class DelegatingResponseCollector<T>
    implements ResponseCollector<Void> {
        private final ResponseCollector<T> responseCollector;

        public DelegatingResponseCollector(ResponseCollector<T> responseCollector) {
            this.responseCollector = responseCollector;
        }

        @Override
        public Void addResponse(Address sender, Response response) {
            this.responseCollector.addResponse(sender, response);
            return null;
        }

        @Override
        public Void finish() {
            return null;
        }
    }
}

