/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.ejb._private.Keys;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.AuthenticationContextEJBClientInterceptor;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.ConfigurationBasedEJBClientContextSelector;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.DiscoveryEJBClientInterceptor;
import org.jboss.ejb.client.EJBClientCluster;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInterceptorInformation;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.EJBProxyInterceptorInformation;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBSessionCreationInvocationContext;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.ejb.client.NamingEJBClientInterceptor;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.TransactionInterceptor;
import org.jboss.ejb.client.TransactionPostDiscoveryInterceptor;
import org.jboss.ejb.protocol.remote.RemotingEJBClientInterceptor;
import org.wildfly.common.Assert;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.discovery.Discovery;
import org.wildfly.discovery.ServiceType;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.security.auth.client.AuthenticationContext;

public final class EJBClientContext
extends Attachable
implements Contextual<EJBClientContext> {
    public static final ServiceType EJB_SERVICE_TYPE = ServiceType.of((String)"ejb", (String)"jboss");
    private static final ContextManager<EJBClientContext> CONTEXT_MANAGER = new ContextManager(EJBClientContext.class, "jboss.ejb.client");
    private static final Supplier<Discovery> DISCOVERY_SUPPLIER = AccessController.doPrivileged(() -> ((ContextManager)Discovery.getContextManager()).getPrivilegedSupplier());
    private static final Supplier<EJBClientContext> GETTER = AccessController.doPrivileged(() -> CONTEXT_MANAGER.getPrivilegedSupplier());
    private static final EJBTransportProvider[] NO_TRANSPORT_PROVIDERS = new EJBTransportProvider[0];
    private static final EJBClientInterceptor.Registration[] NO_INTERCEPTORS = new EJBClientInterceptor.Registration[0];
    private static final AtomicReferenceFieldUpdater<EJBClientContext, EJBClientInterceptor.Registration[]> registrationsUpdater = AtomicReferenceFieldUpdater.newUpdater(EJBClientContext.class, EJBClientInterceptor.Registration[].class, "registrations");
    private volatile EJBClientInterceptor.Registration[] registrations = NO_INTERCEPTORS;
    public static final String FILTER_ATTR_EJB_MODULE = "ejb-module";
    public static final String FILTER_ATTR_EJB_MODULE_DISTINCT = "ejb-module-distinct";
    public static final String FILTER_ATTR_NODE = "node";
    public static final String FILTER_ATTR_CLUSTER = "cluster";
    public static final String FILTER_ATTR_SOURCE_IP = "source-ip";
    private static final int MAX_SESSION_RETRIES = 8;
    private static final Logs log = Logs.MAIN;
    private final EJBTransportProvider[] transportProviders;
    private final long invocationTimeout;
    private final EJBReceiverContext receiverContext;
    private final List<EJBClientConnection> configuredConnections;
    private final Map<String, EJBClientCluster> configuredClusters;
    private final ClusterNodeSelector clusterNodeSelector;
    private final DeploymentNodeSelector deploymentNodeSelector;
    private final ClassValue<EJBProxyInterceptorInformation<?>> proxyInfoValue = new ClassValue<EJBProxyInterceptorInformation<?>>(){

        @Override
        protected EJBProxyInterceptorInformation<?> computeValue(Class<?> type) {
            return EJBProxyInterceptorInformation.construct(type, EJBClientContext.this);
        }
    };
    static final InterceptorList defaultInterceptors;
    private final InterceptorList classPathInterceptors;
    private final InterceptorList globalInterceptors;
    private final Map<String, InterceptorList> configuredPerClassInterceptors;
    private final Map<String, Map<EJBMethodLocator, InterceptorList>> configuredPerMethodInterceptors;
    private final int maximumConnectedClusterNodes;
    private final int defaultCompression;

    static EJBClientContext getDefault() {
        return ConfigurationBasedEJBClientContextSelector.get();
    }

    EJBClientContext(Builder builder) {
        log.tracef("Creating new EJBClientContext: %s", this);
        List<EJBTransportProvider> builderTransportProviders = builder.transportProviders;
        if (builderTransportProviders == null || builderTransportProviders.isEmpty()) {
            this.transportProviders = NO_TRANSPORT_PROVIDERS;
            log.tracef("New EJBClientContext %s contains no transport providers", this);
        } else {
            this.transportProviders = builderTransportProviders.toArray(new EJBTransportProvider[builderTransportProviders.size()]);
        }
        this.invocationTimeout = builder.invocationTimeout;
        this.receiverContext = new EJBReceiverContext(this);
        List<EJBClientConnection> clientConnections = builder.clientConnections;
        if (clientConnections == null || clientConnections.isEmpty()) {
            this.configuredConnections = Collections.emptyList();
            log.tracef("New EJBClientContext %s contains no configured connections", this);
        } else if (clientConnections.size() == 1) {
            if (log.isTraceEnabled()) {
                log.tracef("New EJBClientContext %s contains one configured connection: %s", this, clientConnections.get(0));
            }
            this.configuredConnections = Collections.singletonList(clientConnections.get(0));
        } else {
            this.configuredConnections = Collections.unmodifiableList(new ArrayList<EJBClientConnection>(clientConnections));
            if (log.isTraceEnabled()) {
                StringBuffer buffer = new StringBuffer();
                Iterator<EJBClientConnection> iterator = this.configuredConnections.iterator();
                buffer.append(clientConnections.iterator().next());
                while (iterator.hasNext()) {
                    buffer.append(", ").append(iterator.next());
                }
                log.tracef("New EJBClientContext %s contains configured connections: %s", this, buffer);
            }
        }
        List<EJBClientCluster> clientClusters = builder.clientClusters;
        if (clientClusters == null || clientClusters.isEmpty()) {
            this.configuredClusters = Collections.emptyMap();
        } else if (clientClusters.size() == 1) {
            EJBClientCluster clientCluster = clientClusters.get(0);
            this.configuredClusters = Collections.singletonMap(clientCluster.getName(), clientCluster);
            log.tracef("New EJBClientContext %s contains configured cluster: %s", this, clientCluster);
        } else {
            HashMap<String, EJBClientCluster> map = new HashMap<String, EJBClientCluster>();
            for (EJBClientCluster clientCluster : clientClusters) {
                map.put(clientCluster.getName(), clientCluster);
                log.tracef("New EJBClientContext %s contains configured cluster: %s", this, clientCluster);
            }
            this.configuredClusters = Collections.unmodifiableMap(map);
        }
        this.clusterNodeSelector = builder.clusterNodeSelector;
        this.deploymentNodeSelector = builder.deploymentNodeSelector;
        this.maximumConnectedClusterNodes = builder.maximumConnectedClusterNodes;
        this.defaultCompression = builder.defaultCompression;
        log.tracef("New EJBClientContext %s contains cluster configuration: node selector=%s, deployment selector=%s, maximum nodes=%s", new Object[]{this, this.clusterNodeSelector, this.deploymentNodeSelector, this.maximumConnectedClusterNodes});
        List<EJBClientInterceptorInformation> globalInterceptors = builder.globalInterceptors;
        if (globalInterceptors != null) {
            Iterator<EJBClientInterceptorInformation> globalInterceptorsIterator = globalInterceptors.iterator();
            if (globalInterceptorsIterator.hasNext()) {
                EJBClientInterceptorInformation first = globalInterceptorsIterator.next();
                if (globalInterceptorsIterator.hasNext()) {
                    ArrayList<EJBClientInterceptorInformation> arrayList = new ArrayList<EJBClientInterceptorInformation>();
                    arrayList.add(first);
                    do {
                        arrayList.add(globalInterceptorsIterator.next());
                    } while (globalInterceptorsIterator.hasNext());
                    this.globalInterceptors = arrayList.isEmpty() ? InterceptorList.EMPTY : new InterceptorList(arrayList.toArray(EJBClientInterceptorInformation.NO_INTERCEPTORS));
                } else {
                    this.globalInterceptors = first.getSingletonList();
                }
            } else {
                this.globalInterceptors = InterceptorList.EMPTY;
            }
        } else {
            this.globalInterceptors = InterceptorList.EMPTY;
        }
        this.classPathInterceptors = System.getSecurityManager() != null ? AccessController.doPrivileged(EJBClientContext::getClassPathInterceptorList) : EJBClientContext.getClassPathInterceptorList();
        List<ClassInterceptor> classInterceptors = builder.classInterceptors;
        if (classInterceptors != null) {
            Iterator<ClassInterceptor> classInterceptorsIterator = classInterceptors.iterator();
            if (classInterceptorsIterator.hasNext()) {
                HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
                do {
                    ClassInterceptor classInterceptor = classInterceptorsIterator.next();
                    map.computeIfAbsent(classInterceptor.getClassName(), ignored -> new ArrayList()).add(classInterceptor.getInterceptor());
                } while (classInterceptorsIterator.hasNext());
                Iterator iterator = map.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry first = iterator.next();
                    if (iterator.hasNext()) {
                        HashMap<String, InterceptorList> targetMap = new HashMap<String, InterceptorList>(map.size());
                        targetMap.put((String)first.getKey(), InterceptorList.ofList((ArrayList)first.getValue()));
                        do {
                            Map.Entry next = iterator.next();
                            targetMap.put((String)next.getKey(), InterceptorList.ofList((ArrayList)next.getValue()));
                        } while (iterator.hasNext());
                        this.configuredPerClassInterceptors = targetMap;
                    } else {
                        this.configuredPerClassInterceptors = Collections.singletonMap((String)first.getKey(), InterceptorList.ofList((ArrayList)first.getValue()));
                    }
                } else {
                    this.configuredPerClassInterceptors = Collections.emptyMap();
                }
            } else {
                this.configuredPerClassInterceptors = Collections.emptyMap();
            }
        } else {
            this.configuredPerClassInterceptors = Collections.emptyMap();
        }
        List<MethodInterceptor> methodInterceptors = builder.methodInterceptors;
        if (methodInterceptors != null) {
            Iterator<MethodInterceptor> methodInterceptorIterator = methodInterceptors.iterator();
            if (methodInterceptorIterator.hasNext()) {
                HashMap<String, HashMap> hashMap = new HashMap<String, HashMap>();
                do {
                    MethodInterceptor methodInterceptor = methodInterceptorIterator.next();
                    hashMap.computeIfAbsent(methodInterceptor.getClassName(), ignored -> new HashMap()).computeIfAbsent(methodInterceptor.getMethodLocator(), ignored -> new ArrayList()).add(methodInterceptor.getInterceptor());
                } while (methodInterceptorIterator.hasNext());
                Iterator outerIter = hashMap.entrySet().iterator();
                if (outerIter.hasNext()) {
                    Map.Entry first = outerIter.next();
                    if (outerIter.hasNext()) {
                        HashMap<String, Map<EJBMethodLocator, InterceptorList>> targetMap = new HashMap<String, Map<EJBMethodLocator, InterceptorList>>(hashMap.size());
                        targetMap.put((String)first.getKey(), EJBClientContext.calculateMethodInterceptors((HashMap)first.getValue()));
                        do {
                            Map.Entry next = outerIter.next();
                            targetMap.put((String)next.getKey(), EJBClientContext.calculateMethodInterceptors((HashMap)next.getValue()));
                        } while (outerIter.hasNext());
                        this.configuredPerMethodInterceptors = targetMap;
                    } else {
                        this.configuredPerMethodInterceptors = Collections.singletonMap((String)first.getKey(), EJBClientContext.calculateMethodInterceptors((HashMap)first.getValue()));
                    }
                } else {
                    this.configuredPerMethodInterceptors = Collections.emptyMap();
                }
            } else {
                this.configuredPerMethodInterceptors = Collections.emptyMap();
            }
        } else {
            this.configuredPerMethodInterceptors = Collections.emptyMap();
        }
        if (log.isTraceEnabled()) {
            if (globalInterceptors != null) {
                for (EJBClientInterceptorInformation eJBClientInterceptorInformation : globalInterceptors) {
                    log.tracef("New EJBClientContext %s contains global interceptor: %s", this, eJBClientInterceptorInformation);
                }
            }
            if (this.classPathInterceptors != null) {
                for (EJBClientInterceptorInformation ejbClientInterceptorInformation : this.classPathInterceptors.getInformation()) {
                    log.tracef("New EJBClientContext %s contains class path interceptor: %s", this, ejbClientInterceptorInformation);
                }
            }
            if (this.configuredPerClassInterceptors != null) {
                for (Map.Entry entry : this.configuredPerClassInterceptors.entrySet()) {
                    log.tracef("New EJBClientContext %s contains class interceptor: class=%s, intercpetor=%s", this, entry.getKey(), ((InterceptorList)entry.getValue()).getInformation());
                }
            }
            if (this.configuredPerMethodInterceptors != null) {
                for (Map.Entry entry : this.configuredPerMethodInterceptors.entrySet()) {
                    for (Map.Entry methodEntry : ((Map)entry.getValue()).entrySet()) {
                        log.tracef("New EJBClientContext %s contains method interceptor: class=%s, method=%s, interceptor=%s", new Object[]{this, entry.getKey(), methodEntry.getKey(), methodEntry.getValue()});
                    }
                }
            }
        }
        for (EJBTransportProvider transportProvider : this.transportProviders) {
            log.tracef("New EJBClientContext %s notifying transport provider: %s", this, transportProvider);
            transportProvider.notifyRegistered(this.receiverContext);
        }
    }

    private static Map<EJBMethodLocator, InterceptorList> calculateMethodInterceptors(HashMap<EJBMethodLocator, ArrayList<EJBClientInterceptorInformation>> map) {
        Iterator<Map.Entry<EJBMethodLocator, ArrayList<EJBClientInterceptorInformation>>> iterator = map.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<EJBMethodLocator, ArrayList<EJBClientInterceptorInformation>> first = iterator.next();
            if (iterator.hasNext()) {
                HashMap<EJBMethodLocator, InterceptorList> targetMap = new HashMap<EJBMethodLocator, InterceptorList>(map.size());
                targetMap.put(first.getKey(), InterceptorList.ofList(first.getValue()));
                do {
                    Map.Entry<EJBMethodLocator, ArrayList<EJBClientInterceptorInformation>> next = iterator.next();
                    targetMap.put(next.getKey(), InterceptorList.ofList(next.getValue()));
                } while (iterator.hasNext());
                return targetMap;
            }
            return Collections.singletonMap(first.getKey(), InterceptorList.ofList(first.getValue()));
        }
        return Collections.emptyMap();
    }

    static InterceptorList getClassPathInterceptorList() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/services/org.jboss.ejb.client.EJBClientInterceptor");
            if (resources.hasMoreElements()) {
                ArrayList<EJBClientInterceptorInformation> list = new ArrayList<EJBClientInterceptorInformation>();
                do {
                    URL url = resources.nextElement();
                    try (InputStream st = url.openStream();
                         InputStreamReader isr = new InputStreamReader(st, StandardCharsets.UTF_8);
                         BufferedReader r = new BufferedReader(isr);){
                        String line;
                        while ((line = r.readLine()) != null) {
                            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                            try {
                                Class<EJBClientInterceptor> interceptorClass = Class.forName(line, true, classLoader).asSubclass(EJBClientInterceptor.class);
                                list.add(EJBClientInterceptorInformation.forClass(interceptorClass));
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        }
                    }
                } while (resources.hasMoreElements());
                if (list.isEmpty()) {
                    return InterceptorList.EMPTY;
                }
                return new InterceptorList(list.toArray(EJBClientInterceptorInformation.NO_INTERCEPTORS));
            }
            return InterceptorList.EMPTY;
        }
        catch (IOException e) {
            return InterceptorList.EMPTY;
        }
    }

    @Deprecated
    public EJBClientInterceptor.Registration registerInterceptor(int priority, EJBClientInterceptor clientInterceptor) throws IllegalArgumentException {
        Object[] newRegistrations;
        EJBClientInterceptor.Registration[] oldRegistrations;
        Assert.checkNotNullParam((String)"clientInterceptor", (Object)clientInterceptor);
        EJBClientInterceptor.Registration newRegistration = new EJBClientInterceptor.Registration(this, clientInterceptor, priority);
        do {
            for (EJBClientInterceptor.Registration oldRegistration : oldRegistrations = this.registrations) {
                if (oldRegistration.getInterceptor() != clientInterceptor || oldRegistration.compareTo(newRegistration) != 0) continue;
                return oldRegistration;
            }
            int length = oldRegistrations.length;
            newRegistrations = Arrays.copyOf(oldRegistrations, length + 1);
            newRegistrations[length] = newRegistration;
            Arrays.sort(newRegistrations);
        } while (!registrationsUpdater.compareAndSet(this, oldRegistrations, (EJBClientInterceptor.Registration[])newRegistrations));
        return newRegistration;
    }

    @Deprecated
    void removeInterceptor(EJBClientInterceptor.Registration registration) {
        EJBClientInterceptor.Registration[] newRegistrations;
        EJBClientInterceptor.Registration[] oldRegistrations;
        do {
            block5: {
                int newLength;
                int length;
                block4: {
                    oldRegistrations = this.registrations;
                    newRegistrations = null;
                    length = oldRegistrations.length;
                    newLength = length - 1;
                    if (length != 1) break block4;
                    if (oldRegistrations[0] != registration) break block5;
                    newRegistrations = NO_INTERCEPTORS;
                    break block5;
                }
                for (int i = 0; i < length; ++i) {
                    if (oldRegistrations[i] != registration) continue;
                    if (i == newLength) {
                        newRegistrations = Arrays.copyOf(oldRegistrations, newLength);
                        break;
                    }
                    newRegistrations = new EJBClientInterceptor.Registration[newLength];
                    if (i > 0) {
                        System.arraycopy(oldRegistrations, 0, newRegistrations, 0, i);
                    }
                    System.arraycopy(oldRegistrations, i + 1, newRegistrations, i, newLength - i);
                    break;
                }
            }
            if (newRegistrations != null) continue;
            return;
        } while (!registrationsUpdater.compareAndSet(this, oldRegistrations, newRegistrations));
    }

    public ContextManager<EJBClientContext> getInstanceContextManager() {
        return EJBClientContext.getContextManager();
    }

    public static ContextManager<EJBClientContext> getContextManager() {
        return CONTEXT_MANAGER;
    }

    public long getInvocationTimeout() {
        return this.invocationTimeout;
    }

    public List<EJBClientConnection> getConfiguredConnections() {
        return this.configuredConnections;
    }

    public Collection<EJBClientCluster> getInitialConfiguredClusters() {
        return this.configuredClusters.values();
    }

    public int getMaximumConnectedClusterNodes() {
        return this.maximumConnectedClusterNodes;
    }

    public EJBClientContext withAddedInterceptors(EJBClientInterceptor ... interceptors) {
        if (interceptors == null) {
            return this;
        }
        int length = interceptors.length;
        if (length == 0) {
            return this;
        }
        log.tracef("Creating new EJBClientContext from %s with added interceptors including %s", this, interceptors[0]);
        Builder builder = new Builder(this);
        boolean construct = false;
        for (EJBClientInterceptor interceptor : interceptors) {
            if (interceptor == null) continue;
            builder.addInterceptor(interceptor);
            construct = true;
        }
        return construct ? builder.build() : this;
    }

    public EJBClientContext withAddedTransportProviders(EJBTransportProvider ... transportProviders) {
        if (transportProviders == null) {
            return this;
        }
        int length = transportProviders.length;
        if (length == 0) {
            return this;
        }
        log.tracef("Creating new EJBClientContext from %s with added transport providers including %s", this, transportProviders[0]);
        Builder builder = new Builder(this);
        boolean construct = false;
        for (EJBTransportProvider transportProvider : transportProviders) {
            if (transportProvider == null) continue;
            builder.addTransportProvider(transportProvider);
            construct = true;
        }
        return construct ? builder.build() : this;
    }

    EJBReceiver getTransportProvider(String scheme) {
        for (EJBTransportProvider transportProvider : this.transportProviders) {
            if (!transportProvider.supportsProtocol(scheme)) continue;
            return transportProvider.getReceiver(this.receiverContext, scheme);
        }
        return null;
    }

    Discovery getDiscovery() {
        return DISCOVERY_SUPPLIER.get();
    }

    InterceptorList getInterceptors(Class<?> invokedProxy, Method method) {
        return this.proxyInfoValue.get(invokedProxy).getInterceptors(method);
    }

    InterceptorList getInterceptors(Class<?> invokedProxy) {
        return this.proxyInfoValue.get(invokedProxy).getClassInterceptors();
    }

    EJBReceiver resolveReceiver(URI destination, EJBLocator<?> locator) {
        if (destination == null) {
            throw Logs.INVOCATION.noDestinationEstablished(locator);
        }
        String scheme = destination.getScheme();
        for (EJBTransportProvider transportProvider : this.transportProviders) {
            EJBReceiver receiver;
            if (!transportProvider.supportsProtocol(scheme) || (receiver = transportProvider.getReceiver(this.receiverContext, scheme)) == null) continue;
            return receiver;
        }
        throw Logs.INVOCATION.noEJBReceiverAvailable(destination);
    }

    ClusterNodeSelector getClusterNodeSelector() {
        return this.clusterNodeSelector;
    }

    DeploymentNodeSelector getDeploymentNodeSelector() {
        return this.deploymentNodeSelector;
    }

    public void close() {
        for (EJBTransportProvider transportProvider : this.transportProviders) {
            try {
                transportProvider.close(this.receiverContext);
            }
            catch (Exception e) {
                log.exceptionDuringTransportProviderClose(e);
            }
        }
    }

    public static EJBClientContext getCurrent() {
        EJBClientContext clientContext = GETTER.get();
        if (clientContext == null) {
            throw Logs.MAIN.noEJBClientContextAvailable();
        }
        return clientContext;
    }

    public static EJBClientContext requireCurrent() {
        return EJBClientContext.getCurrent();
    }

    <T> StatefulEJBLocator<T> createSession(StatelessEJBLocator<T> statelessLocator, AuthenticationContext authenticationContext, NamingProvider namingProvider) throws Exception {
        EJBSessionCreationInvocationContext context = this.createSessionCreationInvocationContext(statelessLocator, authenticationContext);
        return this.createSession(context, statelessLocator, namingProvider);
    }

    <T> EJBSessionCreationInvocationContext createSessionCreationInvocationContext(StatelessEJBLocator<T> statelessLocator, AuthenticationContext authenticationContext) {
        InterceptorList interceptorList = this.getInterceptors(statelessLocator.getViewType());
        return new EJBSessionCreationInvocationContext(statelessLocator, this, authenticationContext, interceptorList);
    }

    <T> StatefulEJBLocator<T> createSession(EJBSessionCreationInvocationContext context, StatelessEJBLocator<T> statelessLocator, NamingProvider namingProvider) throws Exception {
        if (namingProvider != null) {
            context.putAttachment(Keys.NAMING_PROVIDER_ATTACHMENT_KEY, namingProvider);
        }
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("Calling createSession(locator = %s)", statelessLocator);
        }
        SessionID sessionID = null;
        for (int i = 0; i < 8; ++i) {
            Object t;
            try {
                sessionID = context.proceedInitial();
                break;
            }
            catch (RequestSendFailedException r) {
                if (!r.canBeRetried()) {
                    throw r;
                }
                t = r;
            }
            catch (Error | Exception o) {
                if (!context.shouldRetry()) {
                    throw o;
                }
                t = o;
            }
            catch (Throwable o) {
                if (!context.shouldRetry()) {
                    RequestSendFailedException e = new RequestSendFailedException(o.getClass().getSimpleName() + ": " + o.getMessage(), o.getCause());
                    ((Throwable)((Object)e)).setStackTrace(o.getStackTrace());
                    throw e;
                }
                t = o;
            }
            if (i == 7) {
                throw new RequestSendFailedException(((Throwable)t).getMessage() + " (maximum retries exceeded)", (Throwable)t);
            }
            if (!Logs.INVOCATION.isDebugEnabled()) continue;
            Logs.INVOCATION.debugf("Retrying invocation (attempt %d): %s", i + 1, statelessLocator);
        }
        Affinity affinity = context.getLocator().getAffinity();
        if (Logs.INVOCATION.isDebugEnabled()) {
            Logs.INVOCATION.debugf("Session created: session id: %s , affinity: %s", sessionID, affinity);
        }
        return statelessLocator.withSessionAndAffinity(sessionID, affinity);
    }

    InterceptorList getClassPathInterceptors() {
        return this.classPathInterceptors;
    }

    InterceptorList getGlobalInterceptors() {
        return this.globalInterceptors.combine(this.registeredInterceptors());
    }

    private InterceptorList registeredInterceptors() {
        EJBClientInterceptor.Registration[] currentRegistrations = (EJBClientInterceptor.Registration[])this.registrations.clone();
        ArrayList<EJBClientInterceptorInformation> al = new ArrayList<EJBClientInterceptorInformation>();
        for (EJBClientInterceptor.Registration r : currentRegistrations) {
            al.add(EJBClientInterceptorInformation.forInstance(r.getInterceptor()));
        }
        return InterceptorList.ofList(al);
    }

    Map<String, InterceptorList> getConfiguredPerClassInterceptors() {
        return this.configuredPerClassInterceptors;
    }

    Map<String, Map<EJBMethodLocator, InterceptorList>> getConfiguredPerMethodInterceptors() {
        return this.configuredPerMethodInterceptors;
    }

    public int getDefaultCompression() {
        return this.defaultCompression;
    }

    static <T extends Throwable> T withSuppressed(T original, Collection<Throwable> suppressed) {
        if (suppressed != null) {
            for (Throwable throwable : suppressed) {
                original.addSuppressed(throwable);
            }
        }
        return original;
    }

    static <T extends Throwable> T withSuppressed(T original, Collection<Throwable> suppressed1, Collection<Throwable> suppressed2) {
        if (suppressed1 != null) {
            for (Throwable throwable : suppressed1) {
                original.addSuppressed(throwable);
            }
        }
        if (suppressed2 != null) {
            for (Throwable throwable : suppressed2) {
                original.addSuppressed(throwable);
            }
        }
        return original;
    }

    static {
        CONTEXT_MANAGER.setGlobalDefaultSupplier(EJBClientContext::getDefault);
        defaultInterceptors = new InterceptorList(new EJBClientInterceptorInformation[]{EJBClientInterceptorInformation.forClass(TransactionInterceptor.class), EJBClientInterceptorInformation.forClass(AuthenticationContextEJBClientInterceptor.class), EJBClientInterceptorInformation.forClass(NamingEJBClientInterceptor.class), EJBClientInterceptorInformation.forClass(DiscoveryEJBClientInterceptor.class), EJBClientInterceptorInformation.forClass(TransactionPostDiscoveryInterceptor.class), EJBClientInterceptorInformation.forClass(RemotingEJBClientInterceptor.class)});
    }

    static final class InterceptorList {
        static final InterceptorList EMPTY = new InterceptorList(EJBClientInterceptorInformation.NO_INTERCEPTORS);
        private final EJBClientInterceptorInformation[] information;
        private final int hashCode;

        InterceptorList(EJBClientInterceptorInformation[] information) {
            Arrays.sort(information);
            this.information = information;
            this.hashCode = Arrays.hashCode(information);
        }

        EJBClientInterceptorInformation[] getInformation() {
            return this.information;
        }

        public boolean equals(Object obj) {
            return obj instanceof InterceptorList && Arrays.equals(this.information, ((InterceptorList)obj).information);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static InterceptorList ofList(ArrayList<EJBClientInterceptorInformation> value) {
            if (value.isEmpty()) {
                return EMPTY;
            }
            if (value.size() == 1) {
                return value.get(0).getSingletonList();
            }
            return new InterceptorList(value.toArray(EJBClientInterceptorInformation.NO_INTERCEPTORS));
        }

        InterceptorList combine(InterceptorList other) {
            return this.information.length == 0 ? other : (other.information.length == 0 ? this : new InterceptorList(InterceptorList.concat(this.information, other.information)));
        }

        private static EJBClientInterceptorInformation[] concat(EJBClientInterceptorInformation[] a, EJBClientInterceptorInformation[] b) {
            EJBClientInterceptorInformation[] c = Arrays.copyOf(a, a.length + b.length);
            System.arraycopy(b, 0, c, a.length, b.length);
            return c;
        }
    }

    public static final class Builder {
        List<EJBClientInterceptorInformation> globalInterceptors;
        List<ClassInterceptor> classInterceptors;
        List<MethodInterceptor> methodInterceptors;
        List<EJBTransportProvider> transportProviders;
        List<EJBClientConnection> clientConnections;
        List<EJBClientCluster> clientClusters;
        ClusterNodeSelector clusterNodeSelector = ClusterNodeSelector.DEFAULT_PREFER_LOCAL;
        DeploymentNodeSelector deploymentNodeSelector = DeploymentNodeSelector.RANDOM_PREFER_LOCAL;
        long invocationTimeout;
        int maximumConnectedClusterNodes = 10;
        int defaultCompression = -1;

        public Builder() {
        }

        Builder(EJBClientContext clientContext) {
            String className;
            this.globalInterceptors = Arrays.stream(clientContext.globalInterceptors.getInformation()).collect(Collectors.toCollection(ArrayList::new));
            this.classInterceptors = new ArrayList<ClassInterceptor>();
            for (Map.Entry<String, InterceptorList> entry : clientContext.getConfiguredPerClassInterceptors().entrySet()) {
                className = entry.getKey();
                for (EJBClientInterceptorInformation information : entry.getValue().getInformation()) {
                    this.classInterceptors.add(new ClassInterceptor(className, information));
                }
            }
            this.methodInterceptors = new ArrayList<MethodInterceptor>();
            for (Map.Entry<String, Object> entry : clientContext.getConfiguredPerMethodInterceptors().entrySet()) {
                className = entry.getKey();
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    EJBMethodLocator methodLocator = (EJBMethodLocator)entry2.getKey();
                    for (EJBClientInterceptorInformation information : ((InterceptorList)entry2.getValue()).getInformation()) {
                        this.methodInterceptors.add(new MethodInterceptor(className, methodLocator, information));
                    }
                }
            }
            this.transportProviders = new ArrayList<EJBTransportProvider>();
            Collections.addAll(this.transportProviders, clientContext.transportProviders);
            this.clientConnections = new ArrayList<EJBClientConnection>();
            this.clientConnections.addAll(clientContext.getConfiguredConnections());
            this.clientClusters = new ArrayList<EJBClientCluster>();
            this.clientClusters.addAll(clientContext.configuredClusters.values());
            this.clusterNodeSelector = clientContext.clusterNodeSelector;
            this.deploymentNodeSelector = clientContext.deploymentNodeSelector;
            this.invocationTimeout = clientContext.invocationTimeout;
        }

        public Builder addInterceptor(EJBClientInterceptor interceptor) {
            Assert.checkNotNullParam((String)"interceptor", (Object)interceptor);
            if (this.globalInterceptors == null) {
                this.globalInterceptors = new ArrayList<EJBClientInterceptorInformation>();
            }
            this.globalInterceptors.add(EJBClientInterceptorInformation.forInstance(interceptor));
            return this;
        }

        public Builder addInterceptor(Class<? extends EJBClientInterceptor> interceptorClass) {
            Assert.checkNotNullParam((String)"interceptorClass", interceptorClass);
            if (this.globalInterceptors == null) {
                this.globalInterceptors = new ArrayList<EJBClientInterceptorInformation>();
            }
            this.globalInterceptors.add(EJBClientInterceptorInformation.forClass(interceptorClass));
            return this;
        }

        public Builder addClassInterceptor(String className, EJBClientInterceptor interceptor) {
            Assert.checkNotNullParam((String)"className", (Object)className);
            Assert.checkNotNullParam((String)"interceptor", (Object)interceptor);
            if (this.classInterceptors == null) {
                this.classInterceptors = new ArrayList<ClassInterceptor>();
            }
            this.classInterceptors.add(new ClassInterceptor(className, EJBClientInterceptorInformation.forInstance(interceptor)));
            return this;
        }

        public Builder addClassInterceptor(String className, Class<? extends EJBClientInterceptor> interceptorClass) {
            Assert.checkNotNullParam((String)"className", (Object)className);
            Assert.checkNotNullParam((String)"interceptorClass", interceptorClass);
            if (this.classInterceptors == null) {
                this.classInterceptors = new ArrayList<ClassInterceptor>();
            }
            this.classInterceptors.add(new ClassInterceptor(className, EJBClientInterceptorInformation.forClass(interceptorClass)));
            return this;
        }

        public Builder addMethodInterceptor(String className, EJBMethodLocator methodLocator, EJBClientInterceptor interceptor) {
            Assert.checkNotNullParam((String)"className", (Object)className);
            Assert.checkNotNullParam((String)"methodLocator", (Object)methodLocator);
            Assert.checkNotNullParam((String)"interceptor", (Object)interceptor);
            if (this.methodInterceptors == null) {
                this.methodInterceptors = new ArrayList<MethodInterceptor>();
            }
            this.methodInterceptors.add(new MethodInterceptor(className, methodLocator, EJBClientInterceptorInformation.forInstance(interceptor)));
            return this;
        }

        public Builder addMethodInterceptor(String className, EJBMethodLocator methodLocator, Class<? extends EJBClientInterceptor> interceptorClass) {
            Assert.checkNotNullParam((String)"className", (Object)className);
            Assert.checkNotNullParam((String)"methodLocator", (Object)methodLocator);
            Assert.checkNotNullParam((String)"interceptorClass", interceptorClass);
            if (this.methodInterceptors == null) {
                this.methodInterceptors = new ArrayList<MethodInterceptor>();
            }
            this.methodInterceptors.add(new MethodInterceptor(className, methodLocator, EJBClientInterceptorInformation.forClass(interceptorClass)));
            return this;
        }

        public Builder addTransportProvider(EJBTransportProvider provider) {
            Assert.checkNotNullParam((String)"provider", (Object)provider);
            if (this.transportProviders == null) {
                this.transportProviders = new ArrayList<EJBTransportProvider>();
            }
            this.transportProviders.add(provider);
            return this;
        }

        public Builder addClientConnection(EJBClientConnection connection) {
            Assert.checkNotNullParam((String)"connection", (Object)connection);
            if (this.clientConnections == null) {
                this.clientConnections = new ArrayList<EJBClientConnection>();
            }
            this.clientConnections.add(connection);
            return this;
        }

        public Builder addClientCluster(EJBClientCluster cluster) {
            Assert.checkNotNullParam((String)EJBClientContext.FILTER_ATTR_CLUSTER, (Object)cluster);
            if (this.clientClusters == null) {
                this.clientClusters = new ArrayList<EJBClientCluster>();
            }
            this.clientClusters.add(cluster);
            return this;
        }

        public Builder setClusterNodeSelector(ClusterNodeSelector clusterNodeSelector) {
            Assert.checkNotNullParam((String)"clusterNodeSelector", (Object)clusterNodeSelector);
            this.clusterNodeSelector = clusterNodeSelector;
            return this;
        }

        public Builder setDeploymentNodeSelector(DeploymentNodeSelector deploymentNodeSelector) {
            Assert.checkNotNullParam((String)"deploymentNodeSelector", (Object)deploymentNodeSelector);
            this.deploymentNodeSelector = deploymentNodeSelector;
            return this;
        }

        public Builder setInvocationTimeout(long invocationTimeout) {
            Assert.checkMinimumParameter((String)"invocationTimeout", (long)0L, (long)invocationTimeout);
            this.invocationTimeout = invocationTimeout;
            return this;
        }

        public Builder setMaximumConnectedClusterNodes(int maximumConnectedClusterNodes) {
            Assert.checkMinimumParameter((String)"maximumConnectedClusterNodes", (int)0, (int)maximumConnectedClusterNodes);
            this.maximumConnectedClusterNodes = maximumConnectedClusterNodes;
            return this;
        }

        public void setDefaultCompression(int defaultCompression) {
            Assert.checkMinimumParameter((String)"defaultCompression", (int)-1, (int)defaultCompression);
            Assert.checkMaximumParameter((String)"defaultCompression", (int)9, (int)defaultCompression);
            this.defaultCompression = defaultCompression;
        }

        public EJBClientContext build() {
            return new EJBClientContext(this);
        }
    }

    static final class MethodInterceptor {
        private final String className;
        private final EJBMethodLocator methodLocator;
        private final EJBClientInterceptorInformation interceptor;

        MethodInterceptor(String className, EJBMethodLocator methodLocator, EJBClientInterceptorInformation interceptor) {
            this.className = className;
            this.methodLocator = methodLocator;
            this.interceptor = interceptor;
        }

        String getClassName() {
            return this.className;
        }

        EJBMethodLocator getMethodLocator() {
            return this.methodLocator;
        }

        EJBClientInterceptorInformation getInterceptor() {
            return this.interceptor;
        }
    }

    static final class ClassInterceptor {
        private final String className;
        private final EJBClientInterceptorInformation interceptor;

        ClassInterceptor(String className, EJBClientInterceptorInformation interceptor) {
            this.className = className;
            this.interceptor = interceptor;
        }

        String getClassName() {
            return this.className;
        }

        EJBClientInterceptorInformation getInterceptor() {
            return this.interceptor;
        }
    }
}

