/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import jakarta.annotation.Priority;
import java.util.Map;
import java.util.function.Function;

@Priority(value=3400)
public class FallbackConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = 1472367702046537565L;
    private final Function<String, String> mapping;

    public FallbackConfigSourceInterceptor(Function<String, String> mapping) {
        this.mapping = mapping != null ? mapping : Function.identity();
    }

    public FallbackConfigSourceInterceptor(Map<String, String> mappings) {
        this((String name) -> mappings.getOrDefault(name, (String)name));
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        String map;
        ConfigValue configValue = context.proceed(name);
        if (configValue == null && !name.equals(map = this.mapping.apply(name))) {
            configValue = context.proceed(map);
        }
        return configValue;
    }
}

