/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.cdi;

import com.sun.faces.cdi.CdiProducer;
import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.cdi.ManagedPropertyLiteral;
import com.sun.faces.cdi.ParameterizedTypeImpl;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.annotation.ManagedProperty;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public class ManagedPropertyProducer
extends CdiProducer<Object> {
    private static final long serialVersionUID = 1L;
    private Class<?> expectedClass;

    public ManagedPropertyProducer(Type type, BeanManager beanManager) {
        super.beanClass(ManagedPropertyProducer.class).types(type).qualifiers(new Annotation[]{new ManagedPropertyLiteral()}).addToId(type).create((CreationalContext<T> creationalContext) -> {
            String expression = ((ManagedProperty)CdiUtils.getCurrentInjectionPoint(beanManager, creationalContext).getAnnotated().getAnnotation(ManagedProperty.class)).value();
            return ManagedPropertyProducer.evaluateExpressionGet(beanManager, expression, this.expectedClass);
        });
        this.expectedClass = ManagedPropertyProducer.getExpectedClass(type);
    }

    private static Class<?> getExpectedClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedTypeImpl) {
            return ManagedPropertyProducer.getExpectedClass(((ParameterizedTypeImpl)type).getRawType());
        }
        return Object.class;
    }

    public static <T> T evaluateExpressionGet(BeanManager beanManager, String expression, Class<T> expectedClass) {
        if (expression == null) {
            return null;
        }
        FacesContext context = CdiUtils.getBeanReference(beanManager, FacesContext.class, new Annotation[0]);
        return (T)context.getApplication().evaluateExpressionGet(context, expression, expectedClass);
    }
}

