/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.form;

import java.security.Provider;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.form.ElytronMessages;
import org.wildfly.security.http.form.FormAuthenticationMechanism;

public class FormMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private static final AtomicBoolean ID_CHANGE_LOGGED = new AtomicBoolean(false);

    public FormMechanismFactory() {
    }

    public FormMechanismFactory(Provider provider) {
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        return new String[]{"FORM"};
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        Assert.checkNotNullParam("mechanismName", mechanismName);
        Assert.checkNotNullParam("properties", properties);
        Assert.checkNotNullParam("callbackHandler", callbackHandler);
        if ("FORM".equals(mechanismName)) {
            if (Boolean.valueOf((String)properties.get(HttpConstants.DISABLE_SESSION_ID_CHANGE)).booleanValue() && !ID_CHANGE_LOGGED.getAndSet(true)) {
                ElytronMessages.log.sessionIdChangeDiabled();
            }
            return new FormAuthenticationMechanism(callbackHandler, properties);
        }
        return null;
    }
}

