/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.security.doseta.UnauthorizedSignatureException;
import org.jboss.resteasy.security.doseta.VerificationResults;
import org.jboss.resteasy.security.doseta.Verifier;
import org.jboss.resteasy.security.doseta.i18n.LogMessages;
import org.jboss.resteasy.security.doseta.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.InputStreamToByteArray;

@Provider
@Priority(value=4000)
public class DigitalVerificationInterceptor
implements ReaderInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundReadFrom", this.getClass().getName());
        Verifier verifier = (Verifier)context.getProperty(Verifier.class.getName());
        if (verifier == null) {
            return context.proceed();
        }
        MultivaluedMap headers = context.getHeaders();
        List strings = (List)headers.get((Object)"DKIM-Signature");
        if (strings == null) {
            throw new UnauthorizedSignatureException(Messages.MESSAGES.thereWasNoSignatureHeader("DKIM-Signature"));
        }
        ArrayList<DKIMSignature> signatures = new ArrayList<DKIMSignature>();
        for (String headerVal : strings) {
            try {
                signatures.add(new DKIMSignature(headerVal));
            }
            catch (Exception e) {
                throw new UnauthorizedSignatureException(Messages.MESSAGES.malformedSignatureHeader("DKIM-Signature"));
            }
        }
        InputStream old = context.getInputStream();
        try {
            VerificationResults results;
            InputStreamToByteArray stream = new InputStreamToByteArray(old);
            context.setInputStream((InputStream)stream);
            Object rtn = context.proceed();
            byte[] body = stream.toByteArray();
            if (verifier.getRepository() == null) {
                KeyRepository repository = (KeyRepository)context.getProperty(KeyRepository.class.getName());
                if (repository == null) {
                    repository = (KeyRepository)ResteasyProviderFactory.getContextData(KeyRepository.class);
                }
                verifier.setRepository(repository);
            }
            if (!(results = verifier.verify(signatures, (Map)headers, body)).isVerified()) {
                throw new UnauthorizedSignatureException(results);
            }
            Object object = rtn;
            return object;
        }
        finally {
            context.setInputStream(old);
        }
    }
}

