/*
 * Decompiled with CFR 0.152.
 */
package jakarta.ws.rs.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FactoryFinder {
    private static final Logger LOGGER = Logger.getLogger(FactoryFinder.class.getName());
    private static final String RESTEASY_JAXRS_API_MODULE = "org.jboss.resteasy.resteasy-jaxrs-api";

    private FactoryFinder() {
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(() -> {
            ClassLoader cl = null;
            try {
                cl = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException ex) {
                LOGGER.log(Level.WARNING, "Unable to get context classloader instance.", ex);
            }
            return cl;
        });
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> spiClass;
            if (classLoader == null) {
                spiClass = Class.forName(className);
            } else {
                try {
                    spiClass = Class.forName(className, false, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    LOGGER.log(Level.FINE, "Unable to load provider class " + className + " using custom classloader " + classLoader.getClass().getName() + " trying again with current classloader.", ex);
                    spiClass = Class.forName(className);
                }
            }
            return spiClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ClassNotFoundException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    private static <T> Object loadService(final Class<T> service, final ClassLoader cl) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Iterator<T> iterator = ServiceLoader.load(service, cl).iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Iterator iterator = ServiceLoader.load(service, cl).iterator();
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> Object find(String factoryId, Class<T> service) throws ClassNotFoundException {
        classLoader = FactoryFinder.getContextClassLoader();
        try {
            res = FactoryFinder.loadService(service, classLoader);
            if (res != null) {
                return res;
            }
        }
        catch (Exception | ServiceConfigurationError ex) {
            FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + ".", ex);
        }
        try {
            res = FactoryFinder.loadService(service, FactoryFinder.class.getClassLoader());
            if (res != null) {
                return res;
            }
        }
        catch (Exception | ServiceConfigurationError ex) {
            FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + ".", ex);
        }
        inputStream = null;
        configFile = null;
        try {
            javah = System.getProperty("java.home");
            configFile = javah + File.separator + "lib" + File.separator + "jaxrs.properties";
            f = new File(configFile);
            if (!f.exists()) ** GOTO lbl50
            props = new Properties();
            inputStream = new FileInputStream(f);
            props.load(inputStream);
            factoryClassName = props.getProperty(factoryId);
            var9_18 = FactoryFinder.newInstance(factoryClassName, classLoader);
            if (inputStream == null) return var9_18;
            ** GOTO lbl44
        }
        catch (Exception ex) {
            try {
                FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from $java.home/lib/jaxrs.properties", ex);
                if (inputStream != null) {
                }
            }
            catch (Throwable var11_24) {
                if (inputStream == null) throw var11_24;
                try {
                    inputStream.close();
                    throw var11_24;
                }
                catch (IOException ex) {
                    FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                }
                throw var11_24;
            }
lbl44:
            // 1 sources

            try {
                inputStream.close();
                return var9_18;
            }
            catch (IOException ex) {
                FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
            }
            return var9_18;
lbl50:
            // 1 sources

            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
            }
        }
        try {
            systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from a system property", se);
        }
        moduleClassLoader = FactoryFinder.getModuleClassLoader();
        if (moduleClassLoader == null) throw new ClassNotFoundException("Provider for " + factoryId + " cannot be found", null);
        serviceId = "META-INF/services/" + factoryId;
        try {
            is = moduleClassLoader.getResourceAsStream(serviceId);
            var8_17 = null;
            try {
                if (is == null) throw new ClassNotFoundException("Provider for " + factoryId + " cannot be found", null);
                rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                var10_23 = null;
                try {
                    factoryClassName = rd.readLine();
                    if (factoryClassName == null) throw new ClassNotFoundException("Provider for " + factoryId + " cannot be found", null);
                    if ("".equals(factoryClassName) != false) throw new ClassNotFoundException("Provider for " + factoryId + " cannot be found", null);
                    var12_29 = FactoryFinder.newInstance(factoryClassName, moduleClassLoader);
                    return var12_29;
                }
                catch (Throwable var11_27) {
                    var10_23 = var11_27;
                    throw var11_27;
                }
                finally {
                    if (rd != null) {
                        if (var10_23 != null) {
                            try {
                                rd.close();
                            }
                            catch (Throwable var13_30) {
                                var10_23.addSuppressed(var13_30);
                            }
                        } else {
                            rd.close();
                        }
                    }
                }
            }
            catch (Throwable var9_21) {
                var8_17 = var9_21;
                throw var9_21;
            }
            finally {
                if (is != null) {
                    if (var8_17 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable var13_31) {
                            var8_17.addSuppressed(var13_31);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (Exception var7_15) {
            // empty catch block
        }
        throw new ClassNotFoundException("Provider for " + factoryId + " cannot be found", null);
    }

    private static ClassLoader getModuleClassLoader() {
        try {
            Object module;
            Object moduleLoader;
            final Class<?> moduleClass = Class.forName("org.jboss.modules.Module");
            Class<?> moduleIdentifierClass = Class.forName("org.jboss.modules.ModuleIdentifier");
            Class<?> moduleLoaderClass = Class.forName("org.jboss.modules.ModuleLoader");
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                moduleLoader = moduleClass.getMethod("getBootModuleLoader", new Class[0]).invoke(null, new Object[0]);
            } else {
                try {
                    moduleLoader = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return moduleClass.getMethod("getBootModuleLoader", new Class[0]).invoke(null, new Object[0]);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            }
            try {
                Object moduleIdentifier = moduleIdentifierClass.getMethod("create", String.class).invoke(null, RESTEASY_JAXRS_API_MODULE);
                module = moduleLoaderClass.getMethod("loadModule", moduleIdentifierClass).invoke(moduleLoader, moduleIdentifier);
            }
            catch (Exception e) {
                return null;
            }
            if (sm == null) {
                return (ClassLoader)moduleClass.getMethod("getClassLoader", new Class[0]).invoke(module, new Object[0]);
            }
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws Exception {
                        return (ClassLoader)moduleClass.getMethod("getClassLoader", new Class[0]).invoke(module, new Object[0]);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

