/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRegistry;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.annotations.providers.jaxb.DoNotUseJAXBProvider;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBContextFinder;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBProvider;
import org.jboss.resteasy.plugins.providers.jaxb.IgnoredMediaTypes;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBContextFinder;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBMarshalException;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBUnmarshalException;
import org.jboss.resteasy.plugins.providers.jaxb.SecureUnmarshaller;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.LogMessages;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.Messages;
import org.jboss.resteasy.util.FindAnnotation;
import org.xml.sax.InputSource;

@Provider
@Produces(value={"application/xml", "application/*+xml", "text/xml", "text/*+xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml", "text/*+xml"})
public class JAXBXmlTypeProvider
extends AbstractJAXBProvider<Object> {
    protected static final String OBJECT_FACTORY_NAME = ".ObjectFactory";

    @Override
    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", ((Object)((Object)this)).getClass().getName());
        JAXBElement<?> result = JAXBXmlTypeProvider.wrapInJAXBElement(t, type);
        super.writeTo(result, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", ((Object)((Object)this)).getClass().getName());
            JAXBContext jaxb = this.getJAXBContext(type, mediaType);
            if (jaxb == null) {
                jaxb = this.getJAXBContextFinder(type, annotations, mediaType);
            }
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            unmarshaller = JAXBXmlTypeProvider.decorateUnmarshaller(type, annotations, mediaType, unmarshaller);
            Object obj = null;
            if (this.needsSecurity()) {
                SAXSource source = null;
                source = JAXBXmlTypeProvider.getCharset(mediaType) == null ? new SAXSource(new InputSource(new InputStreamReader(entityStream, StandardCharsets.UTF_8))) : new SAXSource(new InputSource(entityStream));
                unmarshaller = new SecureUnmarshaller(unmarshaller, this.isDisableExternalEntities(), this.isEnableSecureProcessingFeature(), this.isDisableDTDs());
                obj = unmarshaller.unmarshal((Source)source);
            } else if (JAXBXmlTypeProvider.getCharset(mediaType) == null) {
                InputSource is = new InputSource(entityStream);
                is.setEncoding(StandardCharsets.UTF_8.name());
                StreamSource source = new StreamSource(new InputStreamReader(entityStream, StandardCharsets.UTF_8));
                source.setInputStream(entityStream);
                obj = unmarshaller.unmarshal((Source)source);
            } else {
                obj = unmarshaller.unmarshal((Source)new StreamSource(entityStream));
            }
            if (obj instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)obj;
                return element.getValue();
            }
            return obj;
        }
        catch (JAXBException e) {
            throw new JAXBUnmarshalException(e);
        }
    }

    private JAXBContext getJAXBContext(Class<Object> type, MediaType mediaType) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : getJAXBContext", ((Object)((Object)this)).getClass().getName());
        ContextResolver resolver = this.providers.getContextResolver(JAXBContext.class, mediaType);
        JAXBContext finder = null;
        if (resolver != null && (finder = (JAXBContext)resolver.getContext(type)) == null) {
            throw new JAXBUnmarshalException(Messages.MESSAGES.couldNotFindUsersJAXBContext(mediaType));
        }
        return finder;
    }

    private JAXBContext getJAXBContextFinder(Class<Object> type, Annotation[] annotations, MediaType mediaType) throws IOException {
        try {
            LogMessages.LOGGER.debugf("Provider : %s,  Method : getJAXBContextFinder", ((Object)((Object)this)).getClass().getName());
            ContextResolver resolver = this.providers.getContextResolver(JAXBContextFinder.class, mediaType);
            JAXBContextFinder finder = (JAXBContextFinder)resolver.getContext(type);
            if (finder == null) {
                throw new JAXBUnmarshalException(Messages.MESSAGES.couldNotFindJAXBContextFinder(mediaType));
            }
            JAXBContext jaxb = finder.findCacheXmlTypeContext(mediaType, annotations, type);
            return jaxb;
        }
        catch (JAXBException e) {
            throw new JAXBUnmarshalException(e);
        }
    }

    @Override
    protected boolean isReadWritable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAnnotationPresent(XmlType.class) && !type.isAnnotationPresent(XmlRootElement.class) && FindAnnotation.findAnnotation(type, (Annotation[])annotations, DoNotUseJAXBProvider.class) == null && !IgnoredMediaTypes.ignored(type, annotations, mediaType);
    }

    public static Object findObjectFactory(Class<?> type) {
        try {
            Class<?> factoryClass = AbstractJAXBContextFinder.findDefaultObjectFactoryClass(type);
            if (factoryClass != null && factoryClass.isAnnotationPresent(XmlRegistry.class)) {
                return factoryClass.newInstance();
            }
            throw new JAXBMarshalException(Messages.MESSAGES.validXmlRegistryCouldNotBeLocated());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JAXBMarshalException(e);
        }
    }

    public static JAXBElement<?> wrapInJAXBElement(Object t, Class<?> type) {
        try {
            final Object factory = JAXBXmlTypeProvider.findObjectFactory(type);
            Method[] method = System.getSecurityManager() == null ? factory.getClass().getDeclaredMethods() : AccessController.doPrivileged(new PrivilegedExceptionAction<Method[]>(){

                @Override
                public Method[] run() throws Exception {
                    return factory.getClass().getDeclaredMethods();
                }
            });
            for (Method current : method) {
                if (current.getParameterTypes().length != 1 || !current.getParameterTypes()[0].equals(type) || !current.getName().startsWith("create")) continue;
                Object result = current.invoke(factory, t);
                return (JAXBElement)JAXBElement.class.cast(result);
            }
            throw new JAXBMarshalException(Messages.MESSAGES.createMethodNotFound(type));
        }
        catch (IllegalAccessException | IllegalArgumentException | PrivilegedActionException e) {
            throw new JAXBMarshalException(e);
        }
        catch (InvocationTargetException e) {
            throw new JAXBMarshalException(e.getCause());
        }
    }
}

