/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime;

import jakarta.batch.operations.BatchRuntimeException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.util.BatchUtil;
import org.wildfly.security.manager.WildFlySecurityManager;

class SerializableData
implements Serializable {
    private final byte[] serialized;
    private final Serializable raw;

    private SerializableData(byte[] serialized, Serializable raw) {
        this.serialized = serialized;
        this.raw = raw;
    }

    public static SerializableData of(Serializable data) {
        if (data instanceof SerializableData) {
            return (SerializableData)data;
        }
        if (data instanceof byte[]) {
            return new SerializableData((byte[])data, null);
        }
        if (data == null) {
            return new SerializableData(null, null);
        }
        Class<?> c = data.getClass();
        if (c.isArray()) {
            c = c.getComponentType();
        }
        if (SerializableData.requiresSerialization(c)) {
            try {
                return new SerializableData(BatchUtil.objectToBytes(data), null);
            }
            catch (IOException e) {
                if (data instanceof Throwable) {
                    Throwable exceptionData = (Throwable)data;
                    BatchLogger.LOGGER.failedToSerializeException(e, exceptionData);
                    BatchRuntimeException replacementException = new BatchRuntimeException(exceptionData.getMessage());
                    replacementException.setStackTrace(exceptionData.getStackTrace());
                    try {
                        return new SerializableData(BatchUtil.objectToBytes((Object)replacementException), null);
                    }
                    catch (IOException e1) {
                        throw BatchMessages.MESSAGES.failedToSerialize(e1, (Serializable)((Object)replacementException));
                    }
                }
                throw BatchMessages.MESSAGES.failedToSerialize(e, data);
            }
        }
        return new SerializableData(null, data);
    }

    public Serializable deserialize() throws BatchRuntimeException {
        if (this.raw != null) {
            return this.raw;
        }
        if (this.serialized != null) {
            ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            if (cl == null) {
                cl = WildFlySecurityManager.getClassLoaderPrivileged(SerializableData.class);
            }
            try {
                return BatchUtil.bytesToSerializableObject(this.serialized, cl);
            }
            catch (IOException e) {
                throw BatchMessages.MESSAGES.failedToDeserialize(e, (Serializable)((Object)Arrays.toString(this.serialized)));
            }
            catch (ClassNotFoundException e) {
                throw BatchMessages.MESSAGES.failedToDeserialize(e, (Serializable)((Object)Arrays.toString(this.serialized)));
            }
        }
        return null;
    }

    byte[] getSerialized() throws BatchRuntimeException {
        if (this.serialized != null) {
            return this.serialized;
        }
        try {
            return BatchUtil.objectToBytes(this.raw);
        }
        catch (IOException e) {
            throw BatchMessages.MESSAGES.failedToSerialize(e, this.raw);
        }
    }

    public int hashCode() {
        int hash = 17;
        if (this.raw != null) {
            hash = 31 * hash + this.raw.hashCode();
        }
        if (this.serialized != null) {
            hash = 31 * hash + Arrays.hashCode(this.serialized);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SerializableData)) {
            return false;
        }
        SerializableData other = (SerializableData)obj;
        return (this.raw == null ? other.raw == null : this.raw.equals(other.raw)) && Arrays.equals(this.serialized, other.serialized);
    }

    private static boolean requiresSerialization(Class<?> c) {
        return !c.isPrimitive() && c != String.class && c != Byte.class && c != Double.class && c != Float.class && c != Integer.class && c != Long.class && c != Short.class && c != BigDecimal.class && c != BigInteger.class;
    }
}

