/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager.transport.remote.socket;

import jakarta.resource.spi.work.WorkException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.spi.workmanager.Address;
import org.jboss.jca.core.workmanager.transport.remote.AbstractRemoteTransport;
import org.jboss.jca.core.workmanager.transport.remote.ProtocolMessages;
import org.jboss.jca.core.workmanager.transport.remote.socket.Communication;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class SocketTransport
extends AbstractRemoteTransport<String>
implements Runnable {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)SocketTransport.class.getName());
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private String host = null;
    private int port = 0;
    private Set<String> peers = null;
    private AtomicBoolean running = new AtomicBoolean(false);
    private ServerSocket ss = null;
    private boolean initialized = false;

    public void startup() throws Throwable {
        if (!this.running.get()) {
            InetSocketAddress address = new InetSocketAddress(this.host, this.port);
            this.ss = new ServerSocket();
            this.ss.bind(address);
            this.running.set(true);
            this.getExecutorService().submit(this);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() throws Throwable {
        if (this.peers != null && !this.initialized) {
            for (String addr : this.peers) {
                log.tracef("Peer: %s", addr);
                try {
                    this.sendMessage(addr, ProtocolMessages.Request.JOIN, new Serializable[]{this.getOwnAddress()});
                    Set workManagers = (Set)((Object)this.sendMessage(addr, ProtocolMessages.Request.GET_WORKMANAGERS, new Serializable[0]));
                    log.tracef("Peer WorkManagers: %s", workManagers);
                    if (workManagers == null) continue;
                    for (Address a : workManagers) {
                        this.join(a, addr);
                        long shortRunningFree = (Long)this.sendMessage(addr, ProtocolMessages.Request.GET_SHORTRUNNING_FREE, new Serializable[]{a});
                        long longRunningFree = (Long)this.sendMessage(addr, ProtocolMessages.Request.GET_LONGRUNNING_FREE, new Serializable[]{a});
                        this.localUpdateShortRunningFree(a, shortRunningFree);
                        this.localUpdateLongRunningFree(a, longRunningFree);
                    }
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
        this.initialized = true;
    }

    public void shutdown() throws Throwable {
        this.running.set(false);
        if (this.ss != null) {
            this.ss.close();
        }
    }

    @Override
    protected Serializable sendMessage(String address, ProtocolMessages.Request request, Serializable ... parameters) throws WorkException {
        String[] addressPart = address.split(":");
        Socket socket = null;
        ObjectOutputStream oos = null;
        if (log.isTraceEnabled()) {
            log.tracef("%s:%d: sending message=%s to %s:%s", new Object[]{this.ss.getInetAddress().getHostName(), this.ss.getLocalPort(), request, addressPart[0], addressPart[1]});
        }
        try {
            socket = new Socket(addressPart[0], (int)Integer.valueOf(addressPart[1]));
            oos = new ObjectOutputStream(socket.getOutputStream());
            oos.writeInt(request.ordinal());
            oos.writeInt(request.getNumberOfParameter());
            if (parameters != null) {
                for (Serializable o : parameters) {
                    oos.writeObject(o);
                }
            }
            oos.flush();
            Serializable serializable = this.parseResponse(socket);
            return serializable;
        }
        catch (Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug("Error sending command: " + throwable.getMessage(), throwable);
            }
            if (throwable instanceof WorkException) {
                throw (WorkException)throwable;
            }
            WorkException we = new WorkException(throwable.getMessage());
            we.initCause(throwable);
            throw we;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Serializable parseResponse(Socket socket) throws Throwable {
        ObjectInputStream ois = null;
        try {
            Serializable parameter;
            ois = new ObjectInputStream(socket.getInputStream());
            int commandOrdinalPosition = ois.readInt();
            int numberOfParameters = ois.readInt();
            Serializable[] parameters = new Serializable[numberOfParameters];
            for (int i = 0; i < numberOfParameters; ++i) {
                parameters[i] = parameter = (Serializable)ois.readObject();
            }
            ProtocolMessages.Response response = ProtocolMessages.Response.values()[commandOrdinalPosition];
            switch (response) {
                case OK_VOID: {
                    parameter = null;
                    return parameter;
                }
                case OK_SERIALIZABLE: {
                    parameter = parameters[0];
                    return parameter;
                }
                case WORK_EXCEPTION: {
                    WorkException we = (WorkException)((Object)parameters[0]);
                    throw we;
                }
                case GENERIC_EXCEPTION: {
                    Throwable t = (Throwable)parameters[0];
                    throw t;
                }
            }
            if (!log.isDebugEnabled()) throw new WorkException("Unknown response received on socket Transport");
            log.debug("Unknown response received on socket Transport");
            throw new WorkException("Unknown response received on socket Transport");
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPeers(Set<String> peers) {
        this.peers = peers;
    }

    @Override
    public String getOwnAddress() {
        return this.host + ":" + this.port;
    }

    @Override
    public void run() {
        while (this.running.get()) {
            try {
                Socket socket = this.ss.accept();
                Communication r = new Communication(this, socket);
                this.getExecutorService().submit(r);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) continue;
                log.trace(e.getMessage());
            }
        }
    }

    public String toString() {
        return "SocketTransport [host=" + this.host + ", port=" + this.port + ", running=" + this.running + ", ss=" + this.ss + "]";
    }
}

