/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.client;

import io.opentracing.Span;
import io.opentracing.contrib.jaxrs2.internal.URIUtils;
import io.opentracing.tag.Tags;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;

public interface ClientSpanDecorator {
    public static final ClientSpanDecorator STANDARD_TAGS = new ClientSpanDecorator(){

        @Override
        public void decorateRequest(ClientRequestContext requestContext, Span span) {
            Tags.COMPONENT.set(span, "jaxrs");
            Tags.PEER_HOSTNAME.set(span, requestContext.getUri().getHost());
            Tags.PEER_PORT.set(span, Integer.valueOf(requestContext.getUri().getPort()));
            Tags.HTTP_METHOD.set(span, requestContext.getMethod());
            String url = URIUtils.url(requestContext.getUri());
            if (url != null) {
                Tags.HTTP_URL.set(span, url);
            }
        }

        @Override
        public void decorateResponse(ClientResponseContext responseContext, Span span) {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(responseContext.getStatus()));
        }
    };
    public static final ClientSpanDecorator HTTP_PATH_OPERATION_NAME = new ClientSpanDecorator(){

        @Override
        public void decorateRequest(ClientRequestContext clientRequestContext, Span span) {
            span.setOperationName(URIUtils.path(clientRequestContext.getUri()));
        }

        @Override
        public void decorateResponse(ClientResponseContext response, Span span) {
        }
    };

    public void decorateRequest(ClientRequestContext var1, Span var2);

    public void decorateResponse(ClientResponseContext var1, Span var2);
}

