/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.common.pool;

import jakarta.resource.spi.ConnectionRequestInfo;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.Util;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.connector.util.ModelNodeUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.adapters.jdbc.WrappedConnectionRequestInfo;
import org.jboss.jca.core.api.connectionmanager.pool.FlushMode;
import org.jboss.jca.core.api.connectionmanager.pool.Pool;
import org.jboss.jca.core.api.management.ConnectionFactory;
import org.jboss.jca.core.api.management.Connector;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.msc.service.ServiceController;

public abstract class PoolOperations
implements OperationStepHandler {
    private final PoolMatcher matcher;
    private final boolean disallowMonitor;

    protected PoolOperations(PoolMatcher matcher, boolean disallowMonitor) {
        this.matcher = matcher;
        this.disallowMonitor = disallowMonitor;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String jndiName;
        ModelNode model;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        if (!address.getElement(0).getKey().equals("deployment") && (model = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel()).isDefined()) {
            jndiName = Util.getJndiName(context, model);
            if (this.isDisabledDatasource(context, address, model)) {
                throw ConnectorLogger.ROOT_LOGGER.datasourceIsDisabled(jndiName);
            }
        } else {
            jndiName = address.getLastElement().getValue();
        }
        final Object[] parameters = this.getParameters(context, operation);
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController managementRepoService = context.getServiceRegistry(PoolOperations.this.disallowMonitor).getService(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE);
                    if (managementRepoService != null) {
                        ModelNode operationResult = null;
                        try {
                            ManagementRepository repository = (ManagementRepository)managementRepoService.getValue();
                            List<Pool> pools = PoolOperations.this.matcher.match(jndiName, repository);
                            if (pools.isEmpty()) {
                                throw ConnectorLogger.ROOT_LOGGER.failedToMatchPool(jndiName);
                            }
                            for (Pool pool : pools) {
                                operationResult = PoolOperations.this.invokeCommandOn(pool, parameters);
                            }
                        }
                        catch (Exception e) {
                            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToInvokeOperation(e.getLocalizedMessage()));
                        }
                        if (operationResult != null) {
                            context.getResult().set(operationResult);
                        }
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected abstract ModelNode invokeCommandOn(Pool var1, Object ... var2) throws Exception;

    protected abstract Object[] getParameters(OperationContext var1, ModelNode var2);

    private boolean isDisabledDatasource(OperationContext context, PathAddress address, ModelNode datasourceNode) throws OperationFailedException {
        return address.getElement(0).getValue().equals("datasources") && ModelNodeUtil.getBooleanIfSetOrGetDefault(context, datasourceNode, Constants.ENABLED) == false;
    }

    private static class RaPoolMatcher
    implements PoolMatcher {
        private RaPoolMatcher() {
        }

        @Override
        public List<Pool> match(String jndiName, ManagementRepository repository) {
            ArrayList<Pool> result = new ArrayList<Pool>(repository.getConnectors().size());
            if (repository.getConnectors() != null) {
                for (Connector c : repository.getConnectors()) {
                    if (c.getConnectionFactories() == null || c.getConnectionFactories().size() == 0) continue;
                    for (ConnectionFactory cf : c.getConnectionFactories()) {
                        if (cf == null || cf.getPool() == null || !jndiName.equalsIgnoreCase(cf.getJndiName())) continue;
                        result.add(cf.getPool());
                    }
                }
            }
            return result;
        }
    }

    private static class DsPoolMatcher
    implements PoolMatcher {
        private DsPoolMatcher() {
        }

        @Override
        public List<Pool> match(String jndiName, ManagementRepository repository) {
            ArrayList<Pool> result = new ArrayList<Pool>(repository.getDataSources().size());
            if (repository.getDataSources() != null) {
                for (DataSource ds : repository.getDataSources()) {
                    if (!jndiName.equalsIgnoreCase(ds.getJndiName()) || ds.getPool() == null) continue;
                    result.add(ds.getPool());
                }
            }
            result.trimToSize();
            return result;
        }
    }

    private static interface PoolMatcher {
        public List<Pool> match(String var1, ManagementRepository var2);
    }

    public static class TestConnectionInPool
    extends PoolOperations {
        public static final TestConnectionInPool DS_INSTANCE = new TestConnectionInPool(new DsPoolMatcher());
        public static final TestConnectionInPool RA_INSTANCE = new TestConnectionInPool(new RaPoolMatcher());

        protected TestConnectionInPool(PoolMatcher matcher) {
            super(matcher, true);
        }

        @Override
        protected ModelNode invokeCommandOn(Pool pool, Object ... parameters) throws Exception {
            boolean returnedValue;
            if (parameters != null) {
                WrappedConnectionRequestInfo cri = new WrappedConnectionRequestInfo((String)parameters[0], (String)parameters[1]);
                returnedValue = pool.testConnection((ConnectionRequestInfo)cri, null);
            } else {
                returnedValue = pool.testConnection();
            }
            if (!returnedValue) {
                throw ConnectorLogger.ROOT_LOGGER.invalidConnection();
            }
            ModelNode result = new ModelNode();
            result.add(returnedValue);
            return result;
        }

        @Override
        protected Object[] getParameters(OperationContext context, ModelNode operation) {
            Object[] parameters = null;
            try {
                if (operation.hasDefined(Constants.USERNAME.getName()) || operation.hasDefined(Constants.PASSWORD.getName())) {
                    parameters = new Object[]{Constants.USERNAME.resolveModelAttribute(context, operation).asString(), Constants.PASSWORD.resolveModelAttribute(context, operation).asString()};
                }
            }
            catch (OperationFailedException operationFailedException) {
                // empty catch block
            }
            return parameters;
        }
    }

    public static class FlushGracefullyConnectionInPool
    extends PoolOperations {
        public static final FlushGracefullyConnectionInPool DS_INSTANCE = new FlushGracefullyConnectionInPool(new DsPoolMatcher());
        public static final FlushGracefullyConnectionInPool RA_INSTANCE = new FlushGracefullyConnectionInPool(new RaPoolMatcher());

        protected FlushGracefullyConnectionInPool(PoolMatcher matcher) {
            super(matcher, true);
        }

        @Override
        protected ModelNode invokeCommandOn(Pool pool, Object ... parameters) {
            pool.flush(FlushMode.GRACEFULLY);
            return null;
        }

        @Override
        protected Object[] getParameters(OperationContext context, ModelNode operation) {
            return null;
        }
    }

    public static class FlushInvalidConnectionInPool
    extends PoolOperations {
        public static final FlushInvalidConnectionInPool DS_INSTANCE = new FlushInvalidConnectionInPool(new DsPoolMatcher());
        public static final FlushInvalidConnectionInPool RA_INSTANCE = new FlushInvalidConnectionInPool(new RaPoolMatcher());

        protected FlushInvalidConnectionInPool(PoolMatcher matcher) {
            super(matcher, true);
        }

        @Override
        protected ModelNode invokeCommandOn(Pool pool, Object ... parameters) {
            pool.flush(FlushMode.INVALID);
            return null;
        }

        @Override
        protected Object[] getParameters(OperationContext context, ModelNode operation) {
            return null;
        }
    }

    public static class FlushAllConnectionInPool
    extends PoolOperations {
        public static final FlushAllConnectionInPool DS_INSTANCE = new FlushAllConnectionInPool(new DsPoolMatcher());
        public static final FlushAllConnectionInPool RA_INSTANCE = new FlushAllConnectionInPool(new RaPoolMatcher());

        protected FlushAllConnectionInPool(PoolMatcher matcher) {
            super(matcher, true);
        }

        @Override
        protected ModelNode invokeCommandOn(Pool pool, Object ... parameters) {
            pool.flush(FlushMode.ALL);
            return null;
        }

        @Override
        protected Object[] getParameters(OperationContext context, ModelNode operation) {
            return null;
        }
    }

    public static class DumpQueuedThreadInPool
    extends PoolOperations {
        public static final DumpQueuedThreadInPool DS_INSTANCE = new DumpQueuedThreadInPool(new DsPoolMatcher());
        public static final DumpQueuedThreadInPool RA_INSTANCE = new DumpQueuedThreadInPool(new RaPoolMatcher());

        protected DumpQueuedThreadInPool(PoolMatcher matcher) {
            super(matcher, false);
        }

        @Override
        protected ModelNode invokeCommandOn(Pool pool, Object ... parameters) {
            ModelNode result = new ModelNode();
            for (String line : pool.dumpQueuedThreads()) {
                result.add(line);
            }
            return result;
        }

        @Override
        protected Object[] getParameters(OperationContext context, ModelNode operation) {
            return null;
        }
    }

    public static class FlushIdleConnectionInPool
    extends PoolOperations {
        public static final FlushIdleConnectionInPool DS_INSTANCE = new FlushIdleConnectionInPool(new DsPoolMatcher());
        public static final FlushIdleConnectionInPool RA_INSTANCE = new FlushIdleConnectionInPool(new RaPoolMatcher());

        protected FlushIdleConnectionInPool(PoolMatcher matcher) {
            super(matcher, true);
        }

        @Override
        protected ModelNode invokeCommandOn(Pool pool, Object ... parameters) {
            pool.flush(FlushMode.IDLE);
            return null;
        }

        @Override
        protected Object[] getParameters(OperationContext context, ModelNode operation) {
            return null;
        }
    }
}

