/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jaxrs.Jackson2Annotations;
import org.jboss.as.jaxrs.JacksonAnnotations;
import org.jboss.as.jaxrs.JaxrsAttribute;
import org.jboss.as.jaxrs.JaxrsServerConfig;
import org.jboss.as.jaxrs.JaxrsServerConfigService;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.jaxrs.deployment.ResteasyDeploymentData;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.jandex.DotName;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JaxrsIntegrationProcessor
implements DeploymentUnitProcessor {
    private static final String JAX_RS_SERVLET_NAME = "jakarta.ws.rs.core.Application";
    private static final String SERVLET_INIT_PARAM = "jakarta.ws.rs.Application";
    public static final String RESTEASY_SCAN = "resteasy.scan";
    public static final String RESTEASY_SCAN_RESOURCES = "resteasy.scan.resources";
    public static final String RESTEASY_SCAN_PROVIDERS = "resteasy.scan.providers";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Object providers;
        StringBuilder buf;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        DeploymentUnit parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData webdata = warMetaData.getMergedJBossWebMetaData();
        this.setConfigParameters(phaseContext, webdata);
        ResteasyDeploymentData resteasy = (ResteasyDeploymentData)deploymentUnit.getAttachment(JaxrsAttachments.RESTEASY_DEPLOYMENT_DATA);
        if (resteasy == null) {
            return;
        }
        deploymentUnit.getDeploymentSubsystemModel("jaxrs");
        List params = webdata.getContextParams();
        boolean entityExpandEnabled = false;
        if (params != null) {
            for (ParamValueMetaData param : params) {
                if (!param.getParamName().equals("resteasy.document.expand.entity.references")) continue;
                entityExpandEnabled = true;
            }
        }
        if (!entityExpandEnabled) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.document.expand.entity.references", "false");
        }
        Map attachmentMap = (Map)parent.getAttachment(JaxrsAttachments.ADDITIONAL_RESTEASY_DEPLOYMENT_DATA);
        ArrayList<ResteasyDeploymentData> additionalData = new ArrayList<ResteasyDeploymentData>();
        ModuleSpecification moduleSpec = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (moduleSpec != null && attachmentMap != null) {
            HashSet<ModuleIdentifier> identifiers = new HashSet<ModuleIdentifier>();
            for (ModuleDependency moduleDependency : moduleSpec.getAllDependencies()) {
                if (identifiers.contains(moduleDependency.getIdentifier())) continue;
                identifiers.add(moduleDependency.getIdentifier());
                if (!attachmentMap.containsKey(moduleDependency.getIdentifier())) continue;
                additionalData.add((ResteasyDeploymentData)attachmentMap.get(moduleDependency.getIdentifier()));
            }
            resteasy.merge(additionalData);
        }
        if (!resteasy.getScannedResourceClasses().isEmpty()) {
            buf = null;
            for (String string : resteasy.getScannedResourceClasses()) {
                if (buf == null) {
                    buf = new StringBuilder();
                    buf.append(string);
                    continue;
                }
                buf.append(",").append(string);
            }
            String resources = buf.toString();
            JaxrsLogger.JAXRS_LOGGER.debugf("Adding Jakarta RESTful Web Services resource classes: %s", resources);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.scanned.resources", resources);
        }
        if (!resteasy.getScannedProviderClasses().isEmpty()) {
            buf = null;
            for (String string : resteasy.getScannedProviderClasses()) {
                if (buf == null) {
                    buf = new StringBuilder();
                    buf.append(string);
                    continue;
                }
                buf.append(",").append(string);
            }
            providers = buf.toString();
            JaxrsLogger.JAXRS_LOGGER.debugf("Adding Jakarta RESTful Web Services provider classes: %s", providers);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.scanned.providers", (String)providers);
        }
        if (!resteasy.getScannedJndiComponentResources().isEmpty()) {
            buf = null;
            for (String string : resteasy.getScannedJndiComponentResources()) {
                if (buf == null) {
                    buf = new StringBuilder();
                    buf.append(string);
                    continue;
                }
                buf.append(",").append(string);
            }
            providers = buf.toString();
            JaxrsLogger.JAXRS_LOGGER.debugf("Adding Jakarta RESTful Web Services jndi component resource classes: %s", providers);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.scanned.jndi.resources", (String)providers);
        }
        if (!resteasy.isUnwrappedExceptionsParameterSet()) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.unwrapped.exceptions", "jakarta.ejb.EJBException");
        }
        if (JaxrsIntegrationProcessor.findContextParam(webdata, "resteasy.preferJacksonOverJsonB") == null) {
            String prop = WildFlySecurityManager.getPropertyPrivileged((String)"resteasy.preferJacksonOverJsonB", null);
            if (prop != null) {
                JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.preferJacksonOverJsonB", prop);
            } else {
                JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.preferJacksonOverJsonB", Boolean.toString(this.hasJacksonAnnotations(deploymentUnit)));
            }
        }
        boolean managementAdded = false;
        if (resteasy.getScannedApplicationClasses().size() > 0 || resteasy.hasBootClasses() || resteasy.isDispatcherCreated()) {
            this.addManagement(deploymentUnit, resteasy);
            managementAdded = true;
        }
        if (resteasy.hasBootClasses() || resteasy.isDispatcherCreated()) {
            return;
        }
        HashSet<Class<? extends Application>> applicationClassSet = new HashSet<Class<? extends Application>>();
        for (Class<? extends Application> clazz : resteasy.getScannedApplicationClasses()) {
            if (!clazz.isAnnotationPresent(ApplicationPath.class) && !JaxrsIntegrationProcessor.servletMappingsExist(webdata, clazz.getName())) continue;
            applicationClassSet.add(clazz);
        }
        if (applicationClassSet.size() == 0) {
            JBossServletMetaData jBossServletMetaData = new JBossServletMetaData();
            jBossServletMetaData.setName(JAX_RS_SERVLET_NAME);
            jBossServletMetaData.setServletClass(HttpServlet30Dispatcher.class.getName());
            jBossServletMetaData.setAsyncSupported(true);
            this.addServlet(webdata, jBossServletMetaData);
            this.setServletMappingPrefix(webdata, JAX_RS_SERVLET_NAME, jBossServletMetaData);
        } else {
            for (Class clazz : applicationClassSet) {
                String servletName = null;
                servletName = clazz.getName();
                JBossServletMetaData servlet = new JBossServletMetaData();
                servlet.setLoadOnStartup("0");
                servlet.setName(servletName);
                servlet.setServletClass(HttpServlet30Dispatcher.class.getName());
                servlet.setAsyncSupported(true);
                this.setServletInitParam(servlet, SERVLET_INIT_PARAM, clazz.getName());
                this.addServlet(webdata, servlet);
                if (!JaxrsIntegrationProcessor.servletMappingsExist(webdata, servletName)) {
                    try {
                        ArrayList<String> patterns = new ArrayList<String>();
                        String pathValue = URLDecoder.decode(clazz.getAnnotation(ApplicationPath.class).value().trim(), "UTF-8");
                        if (!pathValue.startsWith("/")) {
                            pathValue = "/" + pathValue;
                        }
                        String prefix = pathValue;
                        pathValue = pathValue.endsWith("/") ? pathValue + "*" : pathValue + "/*";
                        patterns.add(pathValue);
                        this.setServletInitParam(servlet, "resteasy.servlet.mapping.prefix", prefix);
                        ServletMappingMetaData mapping = new ServletMappingMetaData();
                        mapping.setServletName(servletName);
                        mapping.setUrlPatterns(patterns);
                        if (webdata.getServletMappings() == null) {
                            webdata.setServletMappings(new ArrayList());
                        }
                        webdata.getServletMappings().add(mapping);
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.setServletMappingPrefix(webdata, servletName, servlet);
            }
        }
        if (!managementAdded && webdata.getServletMappings() != null) {
            for (ServletMappingMetaData servletMappingMetaData : webdata.getServletMappings()) {
                if (!JAX_RS_SERVLET_NAME.equals(servletMappingMetaData.getServletName())) continue;
                this.addManagement(deploymentUnit, resteasy);
                break;
            }
        }
        if (deploymentUnit.getParent() == null && (webdata.getServletMappings() == null || webdata.getServletMappings().isEmpty())) {
            JaxrsLogger.JAXRS_LOGGER.noServletDeclaration(deploymentUnit.getName());
        }
    }

    private void addManagement(DeploymentUnit deploymentUnit, ResteasyDeploymentData resteasy) {
        Set<String> classes = resteasy.getScannedResourceClasses();
        for (String jndiComp : resteasy.getScannedJndiComponentResources()) {
            String[] jndiCompArray = jndiComp.split(";");
            classes.add(jndiCompArray[1]);
        }
        ArrayList<String> rootRestClasses = new ArrayList<String>(classes);
        Collections.sort(rootRestClasses);
        for (String componentClass : rootRestClasses) {
            try {
                DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
                deploymentResourceSupport.getDeploymentSubModel("jaxrs", PathElement.pathElement((String)"rest-resource", (String)componentClass));
            }
            catch (Exception e) {
                JaxrsLogger.JAXRS_LOGGER.failedToRegisterManagementViewForRESTResources(componentClass, e);
            }
        }
    }

    protected void setServletInitParam(JBossServletMetaData servlet, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = servlet.getInitParam();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            servlet.setInitParam(params);
        }
        params.add(param);
    }

    private boolean hasJacksonAnnotations(DeploymentUnit deploymentUnit) {
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (Jackson2Annotations jackson2Annotations : Jackson2Annotations.values()) {
            if (!this.checkAnnotation(jackson2Annotations.getDotName(), index)) continue;
            return true;
        }
        for (Enum enum_ : JacksonAnnotations.values()) {
            if (!this.checkAnnotation(((JacksonAnnotations)enum_).getDotName(), index)) continue;
            return true;
        }
        return false;
    }

    private boolean checkAnnotation(DotName name, CompositeIndex index) {
        List list = index.getAnnotations(name);
        if (list != null && !list.isEmpty()) {
            JaxrsLogger.JAXRS_LOGGER.jacksonAnnotationDetected("resteasy.preferJacksonOverJsonB");
            return true;
        }
        return false;
    }

    private void setServletMappingPrefix(JBossWebMetaData webdata, String servletName, JBossServletMetaData servlet) {
        List mappings = webdata.getServletMappings();
        if (mappings != null) {
            boolean mappingSet = false;
            for (ServletMappingMetaData mapping : mappings) {
                if (!mapping.getServletName().equals(servletName) || mapping.getUrlPatterns() == null) continue;
                for (String pattern : mapping.getUrlPatterns()) {
                    if (mappingSet) {
                        JaxrsLogger.JAXRS_LOGGER.moreThanOneServletMapping(servletName, pattern);
                        continue;
                    }
                    mappingSet = true;
                    String realPattern = pattern;
                    if (realPattern.endsWith("*")) {
                        realPattern = realPattern.substring(0, realPattern.length() - 1);
                    }
                    this.setServletInitParam(servlet, "resteasy.servlet.mapping.prefix", realPattern);
                }
            }
        }
    }

    private void addServlet(JBossWebMetaData webdata, JBossServletMetaData servlet) {
        if (webdata.getServlets() == null) {
            webdata.setServlets(new JBossServletsMetaData());
        }
        webdata.getServlets().add((MappableMetaData)servlet);
    }

    public void undeploy(DeploymentUnit context) {
        try {
            Module module = (Module)context.getAttachment(Attachments.MODULE);
            Class typeFactoryClass = module.getClassLoader().loadClass("com.fasterxml.jackson.databind.type.TypeFactory");
            Method defaultInstanceMethod = typeFactoryClass.getMethod("defaultInstance", new Class[0]);
            Object typeFactory = defaultInstanceMethod.invoke(null, new Object[0]);
            Method clearCache = typeFactoryClass.getDeclaredMethod("clearCache", new Class[0]);
            clearCache.invoke(typeFactory, new Object[0]);
        }
        catch (Exception e) {
            JaxrsLogger.JAXRS_LOGGER.debugf("Failed to clear class utils LRU map", new Object[0]);
        }
    }

    protected void setFilterInitParam(FilterMetaData filter, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = filter.getInitParam();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            filter.setInitParam(params);
        }
        params.add(param);
    }

    public static ParamValueMetaData findContextParam(JBossWebMetaData webdata, String name) {
        List params = webdata.getContextParams();
        if (params == null) {
            return null;
        }
        for (ParamValueMetaData param : params) {
            if (!param.getParamName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public static ParamValueMetaData findInitParam(JBossWebMetaData webdata, String name) {
        JBossServletsMetaData servlets = webdata.getServlets();
        if (servlets == null) {
            return null;
        }
        for (JBossServletMetaData servlet : servlets) {
            List initParams = servlet.getInitParam();
            if (initParams == null) continue;
            for (ParamValueMetaData param : initParams) {
                if (!param.getParamName().equals(name)) continue;
                return param;
            }
        }
        return null;
    }

    public static boolean servletMappingsExist(JBossWebMetaData webdata, String servletName) {
        List mappings = webdata.getServletMappings();
        if (mappings == null) {
            return false;
        }
        for (ServletMappingMetaData mapping : mappings) {
            if (!mapping.getServletName().equals(servletName)) continue;
            return true;
        }
        return false;
    }

    public static void setContextParameter(JBossWebMetaData webdata, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        String resteasyName = name;
        resteasyName = resteasyName.equals("resteasy-prefer-jackson-over-jsonb") ? "resteasy.preferJacksonOverJsonB" : resteasyName.replace("-", ".");
        param.setParamName(resteasyName);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = webdata.getContextParams();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            webdata.setContextParams(params);
        }
        params.add(param);
    }

    private void setConfigParameters(DeploymentPhaseContext phaseContext, JBossWebMetaData webdata) {
        ServiceName name;
        ServiceRegistry registry = phaseContext.getServiceRegistry();
        JaxrsServerConfig config = (JaxrsServerConfig)registry.getRequiredService(name = JaxrsServerConfigService.CONFIG_SERVICE).getValue();
        ModelNode modelNode = config.isJaxrs20RequestMatching();
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.JAXRS_2_0_REQUEST_MATCHING, modelNode)) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "jaxrs-2-0-request-matching", modelNode.asString());
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_ADD_CHARSET, modelNode = config.isResteasyAddCharset())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-add-charset", modelNode.asString());
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_BUFFER_EXCEPTION_ENTITY, modelNode = config.isResteasyBufferExceptionEntity())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-buffer-exception-entity", modelNode.asString());
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_DISABLE_HTML_SANITIZER, modelNode = config.isResteasyDisableHtmlSanitizer())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-disable-html-sanitizer", modelNode.asString());
        }
        if (this.isSubstantiveList(modelNode = config.getResteasyDisableProviders())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-disable-providers", this.convertListToString(modelNode));
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_DOCUMENT_EXPAND_ENTITY_REFERENCES, modelNode = config.isResteasyDocumentExpandEntityReferences())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-document-expand-entity-references", modelNode.asString());
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_DOCUMENT_SECURE_DISABLE_DTDS, modelNode = config.isResteasySecureDisableDTDs())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-document-secure-disableDTDs", modelNode.asString());
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_DOCUMENT_SECURE_PROCESSING_FEATURE, modelNode = config.isResteasyDocumentSecureProcessingFeature())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-document-secure-processing-feature", modelNode.asString());
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_GZIP_MAX_INPUT, modelNode = config.getResteasyGzipMaxInput())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-gzip-max-input", modelNode.asString());
        }
        if (this.isSubstantiveList(modelNode = config.getResteasyJndiResources())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-jndi-resources", this.convertListToString(modelNode));
        }
        if (this.isSubstantiveList(modelNode = config.getResteasyLanguageMappings())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-language-mappings", this.convertMapToString(modelNode));
        }
        if (this.isSubstantiveList(modelNode = config.getResteasyMediaTypeMappings())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-media-type-mappings", this.convertMapToString(modelNode));
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_MEDIA_TYPE_PARAM_MAPPING, modelNode = config.getResteasyMediaTypeParamMapping())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-media-type-param-mapping", modelNode.asString());
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_PREFER_JACKSON_OVER_JSONB, modelNode = config.isResteasyPreferJacksonOverJsonB())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-prefer-jackson-over-jsonb", modelNode.asString());
        }
        if (this.isSubstantiveList(modelNode = config.getResteasyProviders())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-providers", this.convertListToString(modelNode));
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_RFC7232_PRECONDITIONS, modelNode = config.isResteasyRFC7232Preconditions())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-rfc7232preconditions", modelNode.asString());
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_ROLE_BASED_SECURITY, modelNode = config.isResteasyRoleBasedSecurity())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-role-based-security", modelNode.asString());
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_SECURE_RANDOM_MAX_USE, modelNode = config.getResteasySecureRandomMaxUse())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-secure-random-max-use", modelNode.asString());
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_USE_BUILTIN_PROVIDERS, modelNode = config.isResteasyUseBuiltinProviders())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-use-builtin-providers", modelNode.asString());
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_USE_CONTAINER_FORM_PARAMS, modelNode = config.isResteasyUseContainerFormParams())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-use-container-form-params", modelNode.asString());
        }
        if (this.isTransmittable((AttributeDefinition)JaxrsAttribute.RESTEASY_WIDER_REQUEST_MATCHING, modelNode = config.isResteasyWiderRequestMatching())) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy-wider-request-matching", modelNode.asString());
        }
    }

    private boolean isTransmittable(AttributeDefinition attribute, ModelNode modelNode) {
        if (modelNode == null || ModelType.UNDEFINED.equals((Object)modelNode.getType())) {
            return false;
        }
        String value = modelNode.asString();
        if ("".equals(value.trim())) {
            return false;
        }
        return !value.equals(attribute.getDefaultValue());
    }

    private boolean isSubstantiveList(ModelNode modelNode) {
        if (modelNode == null || ModelType.UNDEFINED.equals((Object)modelNode.getType())) {
            return false;
        }
        return modelNode.asList().size() != 0;
    }

    private String convertListToString(ModelNode modelNode) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ModelNode value : modelNode.asList()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(value.asString());
        }
        return sb.toString();
    }

    private String convertMapToString(ModelNode modelNode) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String key : modelNode.keys()) {
            ModelNode value = modelNode.get(key);
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(key + ":" + value.asString());
        }
        return sb.toString();
    }
}

