/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.jaspic;

import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.cdi.spi.CDIPerRequestInitializer;
import org.glassfish.soteria.mechanisms.jaspic.DefaultAuthConfigProvider;
import org.glassfish.soteria.mechanisms.jaspic.HttpBridgeServerAuthModule;

public final class Jaspic {
    public static final String IS_AUTHENTICATION = "org.glassfish.soteria.security.message.request.authentication";
    public static final String IS_AUTHENTICATION_FROM_FILTER = "org.glassfish.soteria.security.message.request.authenticationFromFilter";
    public static final String IS_SECURE_RESPONSE = "org.glassfish.soteria.security.message.request.secureResponse";
    public static final String IS_REFRESH = "org.glassfish.soteria.security.message.request.isRefresh";
    public static final String DID_AUTHENTICATION = "org.glassfish.soteria.security.message.request.didAuthentication";
    public static final String AUTH_PARAMS = "org.glassfish.soteria.security.message.request.authParams";
    public static final String LOGGEDIN_USERNAME = "org.glassfish.soteria.security.message.loggedin.username";
    public static final String LOGGEDIN_ROLES = "org.glassfish.soteria.security.message.loggedin.roles";
    public static final String LAST_AUTH_STATUS = "org.glassfish.soteria.security.message.authStatus";
    public static final String CONTEXT_REGISTRATION_ID = "org.glassfish.soteria.security.message.registrationId";
    private static final String IS_MANDATORY = "jakarta.security.auth.message.MessagePolicy.isMandatory";
    private static final String REGISTER_SESSION = "javax.servlet.http.registerSession";

    private Jaspic() {
    }

    public static boolean authenticate(HttpServletRequest request, HttpServletResponse response, AuthenticationParameters authParameters) {
        try {
            request.setAttribute(IS_AUTHENTICATION, (Object)true);
            if (authParameters != null) {
                request.setAttribute(AUTH_PARAMS, (Object)authParameters);
            }
            boolean bl = request.authenticate(response);
            return bl;
        }
        catch (ServletException | IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            request.removeAttribute(IS_AUTHENTICATION);
            if (authParameters != null) {
                request.removeAttribute(AUTH_PARAMS);
            }
        }
    }

    public static AuthenticationParameters getAuthParameters(HttpServletRequest request) {
        AuthenticationParameters authParameters = (AuthenticationParameters)request.getAttribute(AUTH_PARAMS);
        if (authParameters == null) {
            authParameters = new AuthenticationParameters();
        }
        return authParameters;
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) {
        try {
            request.logout();
            request.getSession().invalidate();
        }
        catch (ServletException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void cleanSubject(final Subject subject) {
        if (subject != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    subject.getPrincipals().clear();
                    return null;
                }
            });
        }
    }

    public static boolean isRegisterSession(MessageInfo messageInfo) {
        return Boolean.valueOf((String)messageInfo.getMap().get(REGISTER_SESSION));
    }

    public static boolean isProtectedResource(MessageInfo messageInfo) {
        return Boolean.valueOf((String)messageInfo.getMap().get(IS_MANDATORY));
    }

    public static void setRegisterSession(MessageInfo messageInfo, String username, Set<String> roles) {
        messageInfo.getMap().put(REGISTER_SESSION, Boolean.TRUE.toString());
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        request.setAttribute(LOGGEDIN_USERNAME, (Object)username);
        request.setAttribute(LOGGEDIN_ROLES, roles);
    }

    public static boolean isAuthenticationRequest(HttpServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute(IS_AUTHENTICATION));
    }

    public static void notifyContainerAboutLogin(Subject clientSubject, CallbackHandler handler, Principal callerPrincipal, Set<String> groups) {
        Jaspic.handleCallbacks(clientSubject, handler, new CallerPrincipalCallback(clientSubject, callerPrincipal), groups);
    }

    public static void notifyContainerAboutLogin(Subject clientSubject, CallbackHandler handler, String callerPrincipalName, Set<String> groups) {
        Jaspic.handleCallbacks(clientSubject, handler, new CallerPrincipalCallback(clientSubject, callerPrincipalName), groups);
    }

    private static void handleCallbacks(Subject clientSubject, CallbackHandler handler, CallerPrincipalCallback callerPrincipalCallback, Set<String> groups) {
        if (clientSubject == null) {
            throw new IllegalArgumentException("Null clientSubject!");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Null callback handler!");
        }
        try {
            if (groups == null || Utils.isEmpty(groups) || callerPrincipalCallback.getPrincipal() == null && callerPrincipalCallback.getName() == null) {
                handler.handle(new Callback[]{callerPrincipalCallback});
            } else {
                handler.handle(new Callback[]{callerPrincipalCallback, new GroupPrincipalCallback(clientSubject, groups.toArray(new String[groups.size()]))});
            }
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setLastAuthenticationStatus(HttpServletRequest request, AuthenticationStatus status) {
        request.setAttribute(LAST_AUTH_STATUS, (Object)status);
    }

    public static AuthenticationStatus getLastAuthenticationStatus(HttpServletRequest request) {
        return (AuthenticationStatus)request.getAttribute(LAST_AUTH_STATUS);
    }

    public static AuthStatus fromAuthenticationStatus(AuthenticationStatus authenticationStatus) {
        switch (authenticationStatus) {
            case NOT_DONE: 
            case SUCCESS: {
                return AuthStatus.SUCCESS;
            }
            case SEND_FAILURE: {
                return AuthStatus.SEND_FAILURE;
            }
            case SEND_CONTINUE: {
                return AuthStatus.SEND_CONTINUE;
            }
        }
        throw new IllegalStateException("Unhandled status:" + authenticationStatus.name());
    }

    public static void setDidAuthentication(HttpServletRequest request) {
        request.setAttribute(DID_AUTHENTICATION, (Object)Boolean.TRUE);
    }

    public static String getAppContextID(ServletContext context) {
        return context.getVirtualServerName() + " " + context.getContextPath();
    }

    public static String registerServerAuthModule(final CDIPerRequestInitializer cdiPerRequestInitializer, final ServletContext servletContext) {
        String registrationId = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return AuthConfigFactory.getFactory().registerConfigProvider((AuthConfigProvider)new DefaultAuthConfigProvider(() -> new HttpBridgeServerAuthModule(cdiPerRequestInitializer)), "HttpServlet", Jaspic.getAppContextID(servletContext), "Default single SAM authentication config provider");
            }
        });
        servletContext.setAttribute(CONTEXT_REGISTRATION_ID, (Object)registrationId);
        return registrationId;
    }

    public static void deregisterServerAuthModule(ServletContext servletContext) {
        final String registrationId = (String)servletContext.getAttribute(CONTEXT_REGISTRATION_ID);
        if (!Utils.isEmpty(registrationId)) {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return AuthConfigFactory.getFactory().removeRegistration(registrationId);
                }
            });
        }
    }
}

