/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.file;

import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import io.smallrye.config.source.file.FileSystemConfigSource;
import java.util.Collections;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class FileSystemConfigSourceFactory
implements ConfigSourceFactory {
    public static final String SMALLRYE_CONFIG_SOURCE_FILE_LOCATIONS = "smallrye.config.source.file.locations";

    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        ConfigValue value = context.getValue(SMALLRYE_CONFIG_SOURCE_FILE_LOCATIONS);
        if (value == null || value.getValue() == null) {
            return Collections.emptyList();
        }
        return Stream.of((Object[])Converters.newArrayConverter((Converter)Converters.getImplicitConverter(String.class), String[].class).convert(value.getValue())).map(location -> new FileSystemConfigSource((String)location)).collect(Collectors.toList());
    }

    public OptionalInt getPriority() {
        return OptionalInt.of(290);
    }
}

