/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.client.manager;

import jakarta.transaction.TransactionManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.infinispan.client.NearCacheFactory;
import org.wildfly.clustering.infinispan.client.RegisteredRemoteCache;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.near.SimpleNearCacheFactory;

public class RemoteCacheManager
extends org.infinispan.client.hotrod.RemoteCacheManager
implements RemoteCacheContainer {
    private final Map<String, NearCacheFactory<?, ?>> nearCacheFactories = new ConcurrentHashMap();
    private final String name;
    private final Registrar<String> registrar;

    public RemoteCacheManager(String name, Configuration configuration, Registrar<String> registrar) {
        super(configuration, false);
        this.name = name;
        this.registrar = registrar;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName, TransactionMode transactionMode, TransactionManager transactionManager) {
        return this.getCache(cacheName, this.getConfiguration().forceReturnValues(), transactionMode, transactionManager);
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName, boolean forceReturnValue, TransactionMode transactionMode, TransactionManager transactionManager) {
        return new RegisteredRemoteCache(this, super.getCache(cacheName, forceReturnValue, transactionMode, transactionManager), this.registrar);
    }

    @Override
    public <K, V> RemoteCacheContainer.NearCacheRegistration registerNearCacheFactory(final String cacheName, NearCacheFactory<K, V> factory) {
        final Map<String, NearCacheFactory<?, ?>> factories = this.nearCacheFactories;
        factories.put(cacheName, factory);
        return new RemoteCacheContainer.NearCacheRegistration(){

            @Override
            public void close() {
                factories.remove(cacheName);
            }
        };
    }

    protected <K, V> NearCacheService<K, V> createNearCacheService(String cacheName, NearCacheConfiguration config) {
        SimpleNearCacheFactory defaultFactory = new SimpleNearCacheFactory(config);
        SimpleNearCacheFactory factory = cacheName != null ? (NearCacheFactory)this.nearCacheFactories.getOrDefault(cacheName, defaultFactory) : defaultFactory;
        return factory.createService(this.listenerNotifier);
    }
}

