/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.capability.AbstractCapability;
import org.jboss.as.controller.capability.DynamicNameMappers;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.Assert;

public class RuntimeCapability<T>
extends AbstractCapability {
    private static final boolean ALLOW_MULTIPLE = false;
    private final Class<?> serviceValueType;
    private volatile ServiceName serviceName;
    private final T runtimeAPI;
    private final boolean allowMultipleRegistrations;
    private final Set<String> additionalPackages;

    public static String buildDynamicCapabilityName(String baseName, String dynamicNameElement) {
        return RuntimeCapability.buildDynamicCapabilityName(baseName, new String[]{dynamicNameElement});
    }

    public RuntimeCapability<T> fromBaseCapability(String dynamicElement) {
        return this.fromBaseCapability(new String[]{dynamicElement});
    }

    public static String buildDynamicCapabilityName(String baseName, String ... dynamicNameElement) {
        assert (baseName != null);
        assert (dynamicNameElement != null);
        assert (dynamicNameElement.length > 0);
        StringBuilder sb = new StringBuilder(baseName);
        for (String part : dynamicNameElement) {
            sb.append(".").append(part);
        }
        return sb.toString();
    }

    private RuntimeCapability(Builder<T> builder) {
        super(((Builder)builder).baseName, ((Builder)builder).dynamic, ((Builder)builder).requirements, ((Builder)builder).dynamicNameMapper);
        this.runtimeAPI = ((Builder)builder).runtimeAPI;
        this.serviceValueType = ((Builder)builder).serviceValueType;
        this.allowMultipleRegistrations = ((Builder)builder).allowMultipleRegistrations;
        this.additionalPackages = ((Builder)builder).additionalPackages == null ? Collections.emptySet() : Collections.unmodifiableSet(((Builder)builder).additionalPackages);
    }

    private RuntimeCapability(String baseName, Class<?> serviceValueType, ServiceName baseServiceName, T runtimeAPI, Set<String> requirements, boolean allowMultipleRegistrations, Function<PathAddress, String[]> dynamicNameMapper, Set<String> additionalPackages, String ... dynamicElement) {
        super(RuntimeCapability.buildDynamicCapabilityName(baseName, dynamicElement), false, requirements, dynamicNameMapper);
        this.runtimeAPI = runtimeAPI;
        this.serviceValueType = serviceValueType;
        if (serviceValueType != null) {
            Assert.assertNotNull((Object)baseServiceName);
            this.serviceName = baseServiceName.append(dynamicElement);
        } else assert (baseServiceName == null);
        this.allowMultipleRegistrations = allowMultipleRegistrations;
        this.additionalPackages = additionalPackages;
    }

    public ServiceName getCapabilityServiceName() {
        return this.getCapabilityServiceName((Class)null);
    }

    public ServiceName getCapabilityServiceName(Class<?> serviceValueType) {
        if (this.serviceValueType == null || serviceValueType != null && !serviceValueType.isAssignableFrom(this.serviceValueType)) {
            throw ControllerLogger.MGMT_OP_LOGGER.invalidCapabilityServiceType(this.getName(), serviceValueType);
        }
        return this.getServiceName();
    }

    public ServiceName getCapabilityServiceName(String ... dynamicNameElements) {
        return this.getCapabilityServiceName((Class<?>)null, dynamicNameElements);
    }

    public ServiceName getCapabilityServiceName(PathAddress address) {
        return this.getCapabilityServiceName(address, null);
    }

    public ServiceName getCapabilityServiceName(String dynamicNameElement, Class<?> serviceValueType) {
        return this.getCapabilityServiceName(serviceValueType, dynamicNameElement);
    }

    public ServiceName getCapabilityServiceName(Class<?> serviceValueType, String ... dynamicNameElements) {
        return this.fromBaseCapability(dynamicNameElements).getCapabilityServiceName(serviceValueType);
    }

    public ServiceName getCapabilityServiceName(PathAddress address, Class<?> serviceValueType) {
        return this.fromBaseCapability(address).getCapabilityServiceName(serviceValueType);
    }

    public Class<?> getCapabilityServiceValueType() {
        return this.serviceValueType;
    }

    public T getRuntimeAPI() {
        return this.runtimeAPI;
    }

    public boolean isAllowMultipleRegistrations() {
        return this.allowMultipleRegistrations;
    }

    public RuntimeCapability<T> fromBaseCapability(String ... dynamicElement) {
        assert (this.isDynamicallyNamed());
        assert (dynamicElement != null);
        assert (dynamicElement.length > 0);
        return new RuntimeCapability<T>(this.getName(), this.serviceValueType, this.getServiceName(), this.runtimeAPI, this.getRequirements(), this.allowMultipleRegistrations, this.dynamicNameMapper, this.additionalPackages, dynamicElement);
    }

    private ServiceName getServiceName() {
        ServiceName result = this.serviceName;
        if (result == null && this.serviceValueType != null) {
            result = this.serviceName = ServiceNameFactory.parseServiceName(this.getName());
        }
        return result;
    }

    public RuntimeCapability<T> fromBaseCapability(PathAddress path) {
        assert (this.isDynamicallyNamed());
        assert (path != null);
        String[] dynamicElement = (String[])this.dynamicNameMapper.apply(path);
        assert (dynamicElement.length > 0);
        return new RuntimeCapability<T>(this.getName(), this.serviceValueType, this.getServiceName(), this.runtimeAPI, this.getRequirements(), this.allowMultipleRegistrations, this.dynamicNameMapper, this.additionalPackages, dynamicElement);
    }

    @Override
    public Set<String> getAdditionalRequiredPackages() {
        return this.additionalPackages;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public Set<String> getRequirements() {
        return super.getRequirements();
    }

    @Override
    public boolean isDynamicallyNamed() {
        return super.isDynamicallyNamed();
    }

    @Override
    public String getDynamicName(String dynamicNameElement) {
        return super.getDynamicName(dynamicNameElement);
    }

    @Override
    public String getDynamicName(PathAddress address) {
        return super.getDynamicName(address);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static class Builder<T> {
        private final String baseName;
        private final T runtimeAPI;
        private final boolean dynamic;
        private Class<?> serviceValueType;
        private Set<String> requirements;
        private boolean allowMultipleRegistrations = false;
        private Function<PathAddress, String[]> dynamicNameMapper = DynamicNameMappers.SIMPLE;
        private Set<String> additionalPackages;

        public static Builder<Void> of(String name) {
            return new Builder<Object>(name, false, null);
        }

        public static Builder<Void> of(String name, boolean dynamic) {
            return new Builder<Object>(name, dynamic, null);
        }

        public static Builder<Void> of(String name, Class<?> serviceValueType) {
            return new Builder<Object>(name, false, null).setServiceType(serviceValueType);
        }

        public static Builder<Void> of(String name, boolean dynamic, Class<?> serviceValueType) {
            return new Builder<Object>(name, dynamic, null).setServiceType(serviceValueType);
        }

        public static <T> Builder<T> of(String name, T runtimeAPI) {
            return new Builder<T>(name, false, runtimeAPI);
        }

        public static <T> Builder<T> of(String name, boolean dynamic, T runtimeAPI) {
            return new Builder<T>(name, dynamic, runtimeAPI);
        }

        private Builder(String baseName, boolean dynamic, T runtimeAPI) {
            assert (baseName != null);
            assert (baseName.length() > 0);
            this.baseName = baseName;
            this.runtimeAPI = runtimeAPI;
            this.dynamic = dynamic;
        }

        public Builder<T> setServiceType(Class<?> type) {
            this.serviceValueType = type;
            return this;
        }

        public Builder<T> addRequirements(String ... requirements) {
            assert (requirements != null);
            if (this.requirements == null) {
                this.requirements = new HashSet<String>(requirements.length);
            }
            Collections.addAll(this.requirements, requirements);
            return this;
        }

        public Builder<T> setAllowMultipleRegistrations(boolean allowMultipleRegistrations) {
            this.allowMultipleRegistrations = allowMultipleRegistrations;
            return this;
        }

        public Builder<T> setDynamicNameMapper(Function<PathAddress, String[]> mapper) {
            assert (mapper != null);
            this.dynamicNameMapper = mapper;
            return this;
        }

        public Builder<T> addAdditionalRequiredPackages(String ... packages) {
            assert (packages != null);
            if (this.additionalPackages == null) {
                this.additionalPackages = new HashSet<String>(packages.length);
            }
            Collections.addAll(this.additionalPackages, packages);
            return this;
        }

        public RuntimeCapability<T> build() {
            return new RuntimeCapability(this);
        }
    }
}

