/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.persistence.impl;

import java.util.Objects;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.spi.MarshalledValue;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1002)
public class MarshalledValueImpl
implements MarshalledValue {
    static final MarshalledValue EMPTY = new MarshalledValueImpl(null, null, null, -1L, -1L);
    private final ByteBuffer valueBytes;
    private final ByteBuffer metadataBytes;
    private final ByteBuffer internalMetadataBytes;
    private final long created;
    private final long lastUsed;

    @ProtoFactory
    MarshalledValueImpl(byte[] value, byte[] metadata, long created, long lastUsed, byte[] internalMetadata) {
        this((ByteBuffer)ByteBufferImpl.create((byte[])value), (ByteBuffer)ByteBufferImpl.create((byte[])metadata), (ByteBuffer)ByteBufferImpl.create((byte[])internalMetadata), created, lastUsed);
    }

    MarshalledValueImpl(ByteBuffer valueBytes, ByteBuffer metadataBytes, ByteBuffer internalMetadataBytes, long created, long lastUsed) {
        this.valueBytes = valueBytes;
        this.metadataBytes = metadataBytes;
        this.internalMetadataBytes = internalMetadataBytes;
        this.created = created;
        this.lastUsed = lastUsed;
    }

    @ProtoField(number=1, name="value")
    byte[] getValue() {
        return this.valueBytes == null ? Util.EMPTY_BYTE_ARRAY : MarshallUtil.toByteArray((ByteBuffer)this.valueBytes);
    }

    @ProtoField(number=2, name="metadata")
    byte[] getMetadata() {
        return this.metadataBytes == null ? Util.EMPTY_BYTE_ARRAY : MarshallUtil.toByteArray((ByteBuffer)this.metadataBytes);
    }

    @Override
    @ProtoField(number=3, name="created", defaultValue="-1")
    public long getCreated() {
        return this.created;
    }

    @Override
    @ProtoField(number=4, name="lastUsed", defaultValue="-1")
    public long getLastUsed() {
        return this.lastUsed;
    }

    @ProtoField(value=5)
    byte[] getInternalMetadata() {
        return this.internalMetadataBytes == null ? Util.EMPTY_BYTE_ARRAY : MarshallUtil.toByteArray((ByteBuffer)this.internalMetadataBytes);
    }

    @Override
    public ByteBuffer getValueBytes() {
        return this.valueBytes;
    }

    @Override
    public ByteBuffer getMetadataBytes() {
        return this.metadataBytes;
    }

    @Override
    public ByteBuffer getInternalMetadataBytes() {
        return this.internalMetadataBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarshalledValueImpl that = (MarshalledValueImpl)o;
        return this.created == that.created && this.lastUsed == that.lastUsed && Objects.equals(this.valueBytes, that.valueBytes) && Objects.equals(this.metadataBytes, that.metadataBytes) && Objects.equals(this.internalMetadataBytes, that.internalMetadataBytes);
    }

    public int hashCode() {
        return Objects.hash(this.valueBytes, this.metadataBytes, this.internalMetadataBytes, this.created, this.lastUsed);
    }

    public String toString() {
        return "MarshalledValueImpl{valueBytes=" + this.valueBytes + ", metadataBytes=" + this.metadataBytes + ", internalMetadataBytes=" + this.internalMetadataBytes + ", created=" + this.created + ", lastUsed=" + this.lastUsed + '}';
    }
}

